/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.javax.security.auth.login;

import java.io.IOException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Security;
import java.util.HashMap;
import java.util.Map;
import org.apache.harmony.javax.security.auth.AuthPermission;
import org.apache.harmony.javax.security.auth.Subject;
import org.apache.harmony.javax.security.auth.callback.Callback;
import org.apache.harmony.javax.security.auth.callback.CallbackHandler;
import org.apache.harmony.javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.harmony.javax.security.auth.login.AppConfigurationEntry;
import org.apache.harmony.javax.security.auth.login.Configuration;
import org.apache.harmony.javax.security.auth.login.LoginException;
import org.apache.harmony.javax.security.auth.spi.LoginModule;

public class LoginContext {
    private static final String DEFAULT_CALLBACK_HANDLER_PROPERTY = "auth.login.defaultCallbackHandler";
    private static final int OPTIONAL = 0;
    private static final int REQUIRED = 1;
    private static final int REQUISITE = 2;
    private static final int SUFFICIENT = 3;
    private Subject subject;
    private boolean userProvidedSubject;
    private boolean userProvidedConfig;
    private AccessControlContext userContext;
    private CallbackHandler callbackHandler;
    private Module[] modules;
    private Map<String, ?> sharedState;
    private ClassLoader contextClassLoader;
    private boolean loggedIn;

    public LoginContext(String string) throws LoginException {
        this.init(string, null, null, null);
    }

    public LoginContext(String string, CallbackHandler callbackHandler) throws LoginException {
        if (callbackHandler == null) {
            throw new LoginException("auth.34");
        }
        this.init(string, null, callbackHandler, null);
    }

    public LoginContext(String string, Subject subject) throws LoginException {
        if (subject == null) {
            throw new LoginException("auth.03");
        }
        this.init(string, subject, null, null);
    }

    public LoginContext(String string, Subject subject, CallbackHandler callbackHandler) throws LoginException {
        if (subject == null) {
            throw new LoginException("auth.03");
        }
        if (callbackHandler == null) {
            throw new LoginException("auth.34");
        }
        this.init(string, subject, callbackHandler, null);
    }

    public LoginContext(String string, Subject subject, CallbackHandler callbackHandler, Configuration configuration) throws LoginException {
        this.init(string, subject, callbackHandler, configuration);
    }

    private void init(String string, Subject subject, final CallbackHandler callbackHandler, Configuration configuration) throws LoginException {
        AppConfigurationEntry[] appConfigurationEntryArray;
        this.subject = subject;
        boolean bl = this.userProvidedSubject = this.subject != null;
        if (string == null) {
            throw new LoginException("auth.00");
        }
        if (configuration == null) {
            configuration = Configuration.getAccessibleConfiguration();
        } else {
            this.userProvidedConfig = true;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && !this.userProvidedConfig) {
            securityManager.checkPermission(new AuthPermission("createLoginContext." + string));
        }
        if ((appConfigurationEntryArray = configuration.getAppConfigurationEntry(string)) == null) {
            if (securityManager != null && !this.userProvidedConfig) {
                securityManager.checkPermission(new AuthPermission("createLoginContext.other"));
            }
            if ((appConfigurationEntryArray = configuration.getAppConfigurationEntry("other")) == null) {
                throw new LoginException("auth.35 " + string);
            }
        }
        this.modules = new Module[appConfigurationEntryArray.length];
        int n2 = 0;
        while (n2 < this.modules.length) {
            this.modules[n2] = new Module(appConfigurationEntryArray[n2]);
            ++n2;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    LoginContext.this.contextClassLoader = Thread.currentThread().getContextClassLoader();
                    if (LoginContext.this.contextClassLoader == null) {
                        LoginContext.this.contextClassLoader = ClassLoader.getSystemClassLoader();
                    }
                    if (callbackHandler == null) {
                        String string = Security.getProperty(LoginContext.DEFAULT_CALLBACK_HANDLER_PROPERTY);
                        if (string == null || string.length() == 0) {
                            return null;
                        }
                        Class<?> clazz = Class.forName(string, true, LoginContext.this.contextClassLoader);
                        LoginContext.this.callbackHandler = (CallbackHandler)clazz.newInstance();
                    } else {
                        LoginContext.this.callbackHandler = callbackHandler;
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Throwable throwable = privilegedActionException.getCause();
            throw (LoginException)new LoginException("auth.36").initCause(throwable);
        }
        if (this.userProvidedConfig) {
            this.userContext = AccessController.getContext();
        } else if (this.callbackHandler != null) {
            this.userContext = AccessController.getContext();
            this.callbackHandler = new ContextedCallbackHandler(this.callbackHandler);
        }
    }

    public Subject getSubject() {
        if (this.userProvidedSubject || this.loggedIn) {
            return this.subject;
        }
        return null;
    }

    public void login() throws LoginException {
        PrivilegedExceptionAction<Void> privilegedExceptionAction = new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws LoginException {
                LoginContext.this.loginImpl();
                return null;
            }
        };
        try {
            if (this.userProvidedConfig) {
                AccessController.doPrivileged(privilegedExceptionAction, this.userContext);
            } else {
                AccessController.doPrivileged(privilegedExceptionAction);
            }
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (LoginException)privilegedActionException.getException();
        }
    }

    private void loginImpl() throws LoginException {
        Module[] moduleArray;
        if (this.subject == null) {
            this.subject = new Subject();
        }
        if (this.sharedState == null) {
            this.sharedState = new HashMap();
        }
        Throwable throwable = null;
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        Module[] moduleArray2 = this.modules;
        int n2 = this.modules.length;
        int n3 = 0;
        while (n3 < n2) {
            block27: {
                Module module = moduleArray2[n3];
                try {
                    module.create(this.subject, this.callbackHandler, this.sharedState);
                    if (!module.module.login()) break block27;
                    int n4 = module.getFlag();
                    nArray2[n4] = nArray2[n4] + 1;
                    int n5 = module.getFlag();
                    nArray[n5] = nArray[n5] + 1;
                    if (module.getFlag() == 3) {
                    }
                    break block27;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    }
                    if (module.klass == null) {
                        nArray2[1] = nArray2[1] + 1;
                        break;
                    }
                    int n6 = module.getFlag();
                    nArray2[n6] = nArray2[n6] + 1;
                    if (module.getFlag() != 2) break block27;
                }
                break;
            }
            ++n3;
        }
        boolean bl = true;
        if (nArray[1] == nArray2[1] && nArray[2] == nArray2[2]) {
            if (nArray2[1] == 0 && nArray2[2] == 0) {
                if (nArray[0] != 0 || nArray[3] != 0) {
                    bl = false;
                }
            } else {
                bl = false;
            }
        }
        int[] nArray3 = new int[4];
        nArray2[3] = 0;
        nArray2[2] = 0;
        nArray2[1] = 0;
        nArray2[0] = 0;
        if (!bl) {
            moduleArray = this.modules;
            int n7 = this.modules.length;
            int n8 = 0;
            while (n8 < n7) {
                block28: {
                    Module module = moduleArray[n8];
                    if (module.klass != null) {
                        int n9 = module.getFlag();
                        nArray2[n9] = nArray2[n9] + 1;
                        try {
                            module.module.commit();
                            int n10 = module.getFlag();
                            nArray3[n10] = nArray3[n10] + 1;
                        }
                        catch (Throwable throwable3) {
                            if (throwable != null) break block28;
                            throwable = throwable3;
                        }
                    }
                }
                ++n8;
            }
        }
        bl = true;
        if (nArray3[1] == nArray2[1] && nArray3[2] == nArray2[2]) {
            if (nArray2[1] == 0 && nArray2[2] == 0) {
                if (nArray3[0] != 0 || nArray3[3] != 0) {
                    bl = false;
                }
            } else {
                bl = false;
            }
        }
        if (bl) {
            moduleArray = this.modules;
            int n11 = this.modules.length;
            int n12 = 0;
            while (n12 < n11) {
                block29: {
                    Module module = moduleArray[n12];
                    try {
                        module.module.abort();
                    }
                    catch (Throwable throwable4) {
                        if (throwable != null) break block29;
                        throwable = throwable4;
                    }
                }
                ++n12;
            }
            if (throwable instanceof PrivilegedActionException && throwable.getCause() != null) {
                throwable = throwable.getCause();
            }
            if (throwable instanceof LoginException) {
                throw (LoginException)throwable;
            }
            throw (LoginException)new LoginException("auth.37").initCause(throwable);
        }
        this.loggedIn = true;
    }

    public void logout() throws LoginException {
        PrivilegedExceptionAction<Void> privilegedExceptionAction = new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws LoginException {
                LoginContext.this.logoutImpl();
                return null;
            }
        };
        try {
            if (this.userProvidedConfig) {
                AccessController.doPrivileged(privilegedExceptionAction, this.userContext);
            } else {
                AccessController.doPrivileged(privilegedExceptionAction);
            }
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (LoginException)privilegedActionException.getException();
        }
    }

    private void logoutImpl() throws LoginException {
        if (this.subject == null) {
            throw new LoginException("auth.38");
        }
        this.loggedIn = false;
        Throwable throwable = null;
        int n2 = 0;
        Module[] moduleArray = this.modules;
        int n3 = this.modules.length;
        int n4 = 0;
        while (n4 < n3) {
            block7: {
                Module module = moduleArray[n4];
                try {
                    module.module.logout();
                    ++n2;
                }
                catch (Throwable throwable2) {
                    if (throwable != null) break block7;
                    throwable = throwable2;
                }
            }
            ++n4;
        }
        if (throwable != null || n2 == 0) {
            if (throwable instanceof PrivilegedActionException && throwable.getCause() != null) {
                throwable = throwable.getCause();
            }
            if (throwable instanceof LoginException) {
                throw (LoginException)throwable;
            }
            throw (LoginException)new LoginException("auth.37").initCause(throwable);
        }
    }

    private class ContextedCallbackHandler
    implements CallbackHandler {
        private final CallbackHandler hiddenHandlerRef;

        ContextedCallbackHandler(CallbackHandler callbackHandler) {
            this.hiddenHandlerRef = callbackHandler;
        }

        @Override
        public void handle(final Callback[] callbackArray) throws IOException, UnsupportedCallbackException {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws IOException, UnsupportedCallbackException {
                        ContextedCallbackHandler.this.hiddenHandlerRef.handle(callbackArray);
                        return null;
                    }
                }, LoginContext.this.userContext);
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (privilegedActionException.getCause() instanceof UnsupportedCallbackException) {
                    throw (UnsupportedCallbackException)privilegedActionException.getCause();
                }
                throw (IOException)privilegedActionException.getCause();
            }
        }
    }

    private final class Module {
        AppConfigurationEntry entry;
        int flag;
        LoginModule module;
        Class<?> klass;

        Module(AppConfigurationEntry appConfigurationEntry) {
            this.entry = appConfigurationEntry;
            AppConfigurationEntry.LoginModuleControlFlag loginModuleControlFlag = appConfigurationEntry.getControlFlag();
            this.flag = loginModuleControlFlag == AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL ? 0 : (loginModuleControlFlag == AppConfigurationEntry.LoginModuleControlFlag.REQUISITE ? 2 : (loginModuleControlFlag == AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT ? 3 : 1));
        }

        int getFlag() {
            return this.flag;
        }

        void create(Subject subject, CallbackHandler callbackHandler, Map<String, ?> map) throws LoginException {
            String string = this.entry.getLoginModuleName();
            if (this.klass == null) {
                try {
                    this.klass = Class.forName(string, false, LoginContext.this.contextClassLoader);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw (LoginException)new LoginException("auth.39 " + string).initCause(classNotFoundException);
                }
            }
            if (this.module == null) {
                try {
                    this.module = (LoginModule)this.klass.newInstance();
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw (LoginException)new LoginException("auth.3A " + string).initCause(illegalAccessException);
                }
                catch (InstantiationException instantiationException) {
                    throw (LoginException)new LoginException("auth.3A" + string).initCause(instantiationException);
                }
                this.module.initialize(subject, callbackHandler, map, this.entry.getOptions());
            }
        }
    }
}

