/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.javax.security.auth.login;

import org.apache.harmony.javax.security.auth.AuthPermission;
import org.apache.harmony.javax.security.auth.login.AppConfigurationEntry;

public abstract class Configuration {
    private static Configuration configuration;
    private static final AuthPermission GET_LOGIN_CONFIGURATION;
    private static final AuthPermission SET_LOGIN_CONFIGURATION;
    private static final String LOGIN_CONFIGURATION_PROVIDER = "login.configuration.provider";

    static {
        GET_LOGIN_CONFIGURATION = new AuthPermission("getLoginConfiguration");
        SET_LOGIN_CONFIGURATION = new AuthPermission("setLoginConfiguration");
    }

    protected Configuration() {
    }

    public static Configuration getConfiguration() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(GET_LOGIN_CONFIGURATION);
        }
        return Configuration.getAccessibleConfiguration();
    }

    private static final Configuration getDefaultProvider() {
        return new Configuration(){

            @Override
            public void refresh() {
            }

            @Override
            public AppConfigurationEntry[] getAppConfigurationEntry(String string) {
                return new AppConfigurationEntry[0];
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Configuration getAccessibleConfiguration() {
        Configuration configuration = Configuration.configuration;
        if (configuration == null) {
            Class<Configuration> clazz = Configuration.class;
            synchronized (Configuration.class) {
                if (Configuration.configuration == null) {
                    Configuration.configuration = Configuration.getDefaultProvider();
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return Configuration.configuration;
            }
        }
        return configuration;
    }

    public static void setConfiguration(Configuration configuration) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SET_LOGIN_CONFIGURATION);
        }
        Configuration.configuration = configuration;
    }

    public abstract AppConfigurationEntry[] getAppConfigurationEntry(String var1);

    public abstract void refresh();
}

