/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.javax.security.auth;

import java.security.DomainCombiner;
import java.security.Principal;
import java.security.ProtectionDomain;
import java.util.Set;
import org.apache.harmony.javax.security.auth.AuthPermission;
import org.apache.harmony.javax.security.auth.Subject;

public class SubjectDomainCombiner
implements DomainCombiner {
    private Subject subject;
    private static final AuthPermission _GET = new AuthPermission("getSubjectFromDomainCombiner");

    public SubjectDomainCombiner(Subject subject) {
        if (subject == null) {
            throw new NullPointerException();
        }
        this.subject = subject;
    }

    public Subject getSubject() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(_GET);
        }
        return this.subject;
    }

    @Override
    public ProtectionDomain[] combine(ProtectionDomain[] protectionDomainArray, ProtectionDomain[] protectionDomainArray2) {
        int n2 = 0;
        if (protectionDomainArray != null) {
            n2 += protectionDomainArray.length;
        }
        if (protectionDomainArray2 != null) {
            n2 += protectionDomainArray2.length;
        }
        if (n2 == 0) {
            return null;
        }
        ProtectionDomain[] protectionDomainArray3 = new ProtectionDomain[n2];
        int n3 = 0;
        if (protectionDomainArray != null) {
            Set<Principal> set = this.subject.getPrincipals();
            Principal[] principalArray = set.toArray(new Principal[set.size()]);
            n3 = 0;
            while (n3 < protectionDomainArray.length) {
                if (protectionDomainArray[n3] != null) {
                    ProtectionDomain protectionDomain;
                    protectionDomainArray3[n3] = protectionDomain = new ProtectionDomain(protectionDomainArray[n3].getCodeSource(), protectionDomainArray[n3].getPermissions(), protectionDomainArray[n3].getClassLoader(), principalArray);
                }
                ++n3;
            }
        }
        if (protectionDomainArray2 != null) {
            System.arraycopy(protectionDomainArray2, 0, protectionDomainArray3, n3, protectionDomainArray2.length);
        }
        return protectionDomainArray3;
    }
}

