/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.javax.security.auth;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.DomainCombiner;
import java.security.Permission;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.apache.harmony.javax.security.auth.AuthPermission;
import org.apache.harmony.javax.security.auth.PrivateCredentialPermission;
import org.apache.harmony.javax.security.auth.SubjectDomainCombiner;

public final class Subject
implements Serializable {
    private static final long serialVersionUID = -8308522755600156056L;
    private static final AuthPermission _AS = new AuthPermission("doAs");
    private static final AuthPermission _AS_PRIVILEGED = new AuthPermission("doAsPrivileged");
    private static final AuthPermission _SUBJECT = new AuthPermission("getSubject");
    private static final AuthPermission _PRINCIPALS = new AuthPermission("modifyPrincipals");
    private static final AuthPermission _PRIVATE_CREDENTIALS = new AuthPermission("modifyPrivateCredentials");
    private static final AuthPermission _PUBLIC_CREDENTIALS = new AuthPermission("modifyPublicCredentials");
    private static final AuthPermission _READ_ONLY = new AuthPermission("setReadOnly");
    private final Set<Principal> principals;
    private boolean readOnly;
    private transient SecureSet<Object> privateCredentials;
    private transient SecureSet<Object> publicCredentials;

    public Subject() {
        this.principals = new SecureSet<Principal>(_PRINCIPALS);
        this.publicCredentials = new SecureSet(_PUBLIC_CREDENTIALS);
        this.privateCredentials = new SecureSet(_PRIVATE_CREDENTIALS);
        this.readOnly = false;
    }

    public Subject(boolean bl, Set<? extends Principal> set, Set<?> set2, Set<?> set3) {
        if (set == null || set2 == null || set3 == null) {
            throw new NullPointerException();
        }
        this.principals = new SecureSet<Principal>(_PRINCIPALS, set);
        this.publicCredentials = new SecureSet(_PUBLIC_CREDENTIALS, set2);
        this.privateCredentials = new SecureSet(_PRIVATE_CREDENTIALS, set3);
        this.readOnly = bl;
    }

    public static Object doAs(Subject subject, PrivilegedAction privilegedAction) {
        Subject.checkPermission(_AS);
        return Subject.doAs_PrivilegedAction(subject, privilegedAction, AccessController.getContext());
    }

    public static Object doAsPrivileged(Subject subject, PrivilegedAction privilegedAction, AccessControlContext accessControlContext) {
        Subject.checkPermission(_AS_PRIVILEGED);
        if (accessControlContext == null) {
            return Subject.doAs_PrivilegedAction(subject, privilegedAction, new AccessControlContext(new ProtectionDomain[0]));
        }
        return Subject.doAs_PrivilegedAction(subject, privilegedAction, accessControlContext);
    }

    private static Object doAs_PrivilegedAction(Subject subject, PrivilegedAction privilegedAction, final AccessControlContext accessControlContext) {
        final SubjectDomainCombiner subjectDomainCombiner = subject == null ? null : new SubjectDomainCombiner(subject);
        PrivilegedAction privilegedAction2 = new PrivilegedAction(){

            public Object run() {
                return new AccessControlContext(accessControlContext, subjectDomainCombiner);
            }
        };
        AccessControlContext accessControlContext2 = (AccessControlContext)AccessController.doPrivileged(privilegedAction2);
        return AccessController.doPrivileged(privilegedAction, accessControlContext2);
    }

    public static Object doAs(Subject subject, PrivilegedExceptionAction privilegedExceptionAction) throws PrivilegedActionException {
        Subject.checkPermission(_AS);
        return Subject.doAs_PrivilegedExceptionAction(subject, privilegedExceptionAction, AccessController.getContext());
    }

    public static Object doAsPrivileged(Subject subject, PrivilegedExceptionAction privilegedExceptionAction, AccessControlContext accessControlContext) throws PrivilegedActionException {
        Subject.checkPermission(_AS_PRIVILEGED);
        if (accessControlContext == null) {
            return Subject.doAs_PrivilegedExceptionAction(subject, privilegedExceptionAction, new AccessControlContext(new ProtectionDomain[0]));
        }
        return Subject.doAs_PrivilegedExceptionAction(subject, privilegedExceptionAction, accessControlContext);
    }

    private static Object doAs_PrivilegedExceptionAction(Subject subject, PrivilegedExceptionAction privilegedExceptionAction, final AccessControlContext accessControlContext) throws PrivilegedActionException {
        final SubjectDomainCombiner subjectDomainCombiner = subject == null ? null : new SubjectDomainCombiner(subject);
        PrivilegedAction<AccessControlContext> privilegedAction = new PrivilegedAction<AccessControlContext>(){

            @Override
            public AccessControlContext run() {
                return new AccessControlContext(accessControlContext, subjectDomainCombiner);
            }
        };
        AccessControlContext accessControlContext2 = AccessController.doPrivileged(privilegedAction);
        return AccessController.doPrivileged(privilegedExceptionAction, accessControlContext2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Subject subject = (Subject)object;
        return this.principals.equals(subject.principals) && this.publicCredentials.equals(subject.publicCredentials) && this.privateCredentials.equals(subject.privateCredentials);
    }

    public Set<Principal> getPrincipals() {
        return this.principals;
    }

    public <T extends Principal> Set<T> getPrincipals(Class<T> clazz) {
        return ((SecureSet)this.principals).get(clazz);
    }

    public Set<Object> getPrivateCredentials() {
        return this.privateCredentials;
    }

    public <T> Set<T> getPrivateCredentials(Class<T> clazz) {
        return this.privateCredentials.get(clazz);
    }

    public Set<Object> getPublicCredentials() {
        return this.publicCredentials;
    }

    public <T> Set<T> getPublicCredentials(Class<T> clazz) {
        return this.publicCredentials.get(clazz);
    }

    public int hashCode() {
        return this.principals.hashCode() + this.privateCredentials.hashCode() + this.publicCredentials.hashCode();
    }

    public void setReadOnly() {
        Subject.checkPermission(_READ_ONLY);
        this.readOnly = true;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Subject:\n");
        Iterator<Object> iterator = this.principals.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append("\tPrincipal: ");
            stringBuilder.append(iterator.next());
            stringBuilder.append('\n');
        }
        iterator = this.publicCredentials.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append("\tPublic Credential: ");
            stringBuilder.append(iterator.next());
            stringBuilder.append('\n');
        }
        int n2 = stringBuilder.length() - 1;
        iterator = this.privateCredentials.iterator();
        try {
            while (iterator.hasNext()) {
                stringBuilder.append("\tPrivate Credential: ");
                stringBuilder.append(iterator.next());
                stringBuilder.append('\n');
            }
        }
        catch (SecurityException securityException) {
            stringBuilder.delete(n2, stringBuilder.length());
            stringBuilder.append("\tPrivate Credentials: no accessible information\n");
        }
        return stringBuilder.toString();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.publicCredentials = new SecureSet(_PUBLIC_CREDENTIALS);
        this.privateCredentials = new SecureSet(_PRIVATE_CREDENTIALS);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    public static Subject getSubject(final AccessControlContext accessControlContext) {
        Subject.checkPermission(_SUBJECT);
        if (accessControlContext == null) {
            throw new NullPointerException("auth.09");
        }
        PrivilegedAction<DomainCombiner> privilegedAction = new PrivilegedAction<DomainCombiner>(){

            @Override
            public DomainCombiner run() {
                return accessControlContext.getDomainCombiner();
            }
        };
        DomainCombiner domainCombiner = AccessController.doPrivileged(privilegedAction);
        if (domainCombiner == null || !(domainCombiner instanceof SubjectDomainCombiner)) {
            return null;
        }
        return ((SubjectDomainCombiner)domainCombiner).getSubject();
    }

    private static void checkPermission(Permission permission) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(permission);
        }
    }

    private void checkState() {
        if (this.readOnly) {
            throw new IllegalStateException("auth.0A");
        }
    }

    private final class SecureSet<SST>
    extends AbstractSet<SST>
    implements Serializable {
        private static final long serialVersionUID = 7911754171111800359L;
        private LinkedList<SST> elements;
        private int setType;
        private static final int SET_Principal = 0;
        private static final int SET_PrivCred = 1;
        private static final int SET_PubCred = 2;
        private transient AuthPermission permission;

        protected SecureSet(AuthPermission authPermission) {
            this.permission = authPermission;
            this.elements = new LinkedList();
        }

        protected SecureSet(AuthPermission authPermission, Collection<? extends SST> collection) {
            this(authPermission);
            boolean bl = collection.getClass().getClassLoader() == null;
            for (SST SST : collection) {
                super.verifyElement(SST);
                if (!bl && this.elements.contains(SST)) continue;
                this.elements.add(SST);
            }
        }

        private void verifyElement(Object object) {
            if (object == null) {
                throw new NullPointerException();
            }
            if (this.permission == _PRINCIPALS && !Principal.class.isAssignableFrom(object.getClass())) {
                throw new IllegalArgumentException("auth.0B");
            }
        }

        @Override
        public boolean add(SST SST) {
            this.verifyElement(SST);
            Subject.this.checkState();
            Subject.checkPermission(this.permission);
            if (!this.elements.contains(SST)) {
                this.elements.add(SST);
                return true;
            }
            return false;
        }

        @Override
        public Iterator<SST> iterator() {
            if (this.permission == _PRIVATE_CREDENTIALS) {
                return new SecureIterator(this.elements.iterator()){

                    @Override
                    public SST next() {
                        Object e2 = this.iterator.next();
                        Subject.checkPermission(new PrivateCredentialPermission(e2.getClass().getName(), Subject.this.principals));
                        return e2;
                    }
                };
            }
            return new SecureIterator(this.elements.iterator());
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            if (collection == null) {
                throw new NullPointerException();
            }
            return super.retainAll(collection);
        }

        @Override
        public int size() {
            return this.elements.size();
        }

        protected final <E> Set<E> get(final Class<E> clazz) {
            if (clazz == null) {
                throw new NullPointerException();
            }
            AbstractSet abstractSet = new AbstractSet<E>(){
                private LinkedList<E> elements = new LinkedList();

                @Override
                public boolean add(E e2) {
                    if (!clazz.isAssignableFrom(e2.getClass())) {
                        throw new IllegalArgumentException("auth.0C " + clazz.getName());
                    }
                    if (this.elements.contains(e2)) {
                        return false;
                    }
                    this.elements.add(e2);
                    return true;
                }

                @Override
                public Iterator<E> iterator() {
                    return this.elements.iterator();
                }

                @Override
                public boolean retainAll(Collection<?> collection) {
                    if (collection == null) {
                        throw new NullPointerException();
                    }
                    return super.retainAll(collection);
                }

                @Override
                public int size() {
                    return this.elements.size();
                }
            };
            for (SST SST : this) {
                if (!clazz.isAssignableFrom(SST.getClass())) continue;
                abstractSet.add(clazz.cast(SST));
            }
            return abstractSet;
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            switch (this.setType) {
                case 0: {
                    this.permission = _PRINCIPALS;
                    break;
                }
                case 1: {
                    this.permission = _PRIVATE_CREDENTIALS;
                    break;
                }
                case 2: {
                    this.permission = _PUBLIC_CREDENTIALS;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            Iterator iterator = this.elements.iterator();
            while (iterator.hasNext()) {
                this.verifyElement(iterator.next());
            }
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            if (this.permission == _PRIVATE_CREDENTIALS) {
                Iterator<SST> iterator = this.iterator();
                while (iterator.hasNext()) {
                    iterator.next();
                }
                this.setType = 1;
            } else {
                this.setType = this.permission == _PRINCIPALS ? 0 : 2;
            }
            objectOutputStream.defaultWriteObject();
        }

        private class SecureIterator
        implements Iterator<SST> {
            protected Iterator<SST> iterator;

            protected SecureIterator(Iterator<SST> iterator) {
                this.iterator = iterator;
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public SST next() {
                return this.iterator.next();
            }

            @Override
            public void remove() {
                Subject.this.checkState();
                Subject.checkPermission(SecureSet.this.permission);
                this.iterator.remove();
            }
        }
    }
}

