/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.javax.security.auth;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Principal;
import java.util.Set;

public final class PrivateCredentialPermission
extends Permission {
    private static final long serialVersionUID = 5284372143517237068L;
    private static final String READ = "read";
    private String credentialClass;
    private transient int offset;
    private transient CredOwner[] set;

    public PrivateCredentialPermission(String string, String string2) {
        super(string);
        if (!READ.equalsIgnoreCase(string2)) {
            throw new IllegalArgumentException("auth.11");
        }
        this.initTargetName(string);
    }

    PrivateCredentialPermission(String string, Set<Principal> set) {
        super(string);
        this.credentialClass = string;
        this.set = new CredOwner[set.size()];
        for (Principal principal : set) {
            CredOwner credOwner = new CredOwner(principal.getClass().getName(), principal.getName());
            boolean bl = false;
            int n2 = 0;
            while (n2 < this.offset) {
                if (this.set[n2].equals(credOwner)) {
                    bl = true;
                    break;
                }
                ++n2;
            }
            if (bl) continue;
            this.set[this.offset++] = credOwner;
        }
    }

    private void initTargetName(String string) {
        if (string == null) {
            throw new NullPointerException("auth.0E");
        }
        if ((string = string.trim()).length() == 0) {
            throw new IllegalArgumentException("auth.0F");
        }
        int n2 = string.indexOf(32);
        if (n2 == -1) {
            throw new IllegalArgumentException("auth.10");
        }
        this.credentialClass = string.substring(0, n2);
        ++n2;
        int n3 = 0;
        int n4 = string.length();
        int n5 = 0;
        while (n2 < n4) {
            int n6 = string.indexOf(32, n2);
            n5 = string.indexOf(34, n6 + 2);
            if (n6 == -1 || n5 == -1 || string.charAt(n6 + 1) != '\"') {
                throw new IllegalArgumentException("auth.10");
            }
            n2 = n5 + 2;
            ++n3;
        }
        if (n3 < 1) {
            throw new IllegalArgumentException("auth.10");
        }
        n2 = string.indexOf(32);
        ++n2;
        this.set = new CredOwner[n3];
        int n7 = 0;
        while (n7 < n3) {
            int n8 = string.indexOf(32, n2);
            int n9 = string.indexOf(34, n8 + 2);
            String string2 = string.substring(n2, n8);
            String string3 = string.substring(n8 + 2, n9);
            CredOwner credOwner = new CredOwner(string2, string3);
            boolean bl = false;
            int n10 = 0;
            while (n10 < this.offset) {
                if (this.set[n10].equals(credOwner)) {
                    bl = true;
                    break;
                }
                ++n10;
            }
            if (!bl) {
                this.set[this.offset++] = credOwner;
            }
            n2 = n9 + 2;
            ++n7;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.initTargetName(this.getName());
    }

    public String[][] getPrincipals() {
        String[][] stringArray = new String[this.offset][2];
        int n2 = 0;
        while (n2 < stringArray.length) {
            stringArray[n2][0] = this.set[n2].principalClass;
            stringArray[n2][1] = this.set[n2].principalName;
            ++n2;
        }
        return stringArray;
    }

    @Override
    public String getActions() {
        return READ;
    }

    public String getCredentialClass() {
        return this.credentialClass;
    }

    @Override
    public int hashCode() {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.offset) {
            n2 += this.set[n3].hashCode();
            ++n3;
        }
        return this.getCredentialClass().hashCode() + n2;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        PrivateCredentialPermission privateCredentialPermission = (PrivateCredentialPermission)object;
        return this.credentialClass.equals(privateCredentialPermission.credentialClass) && this.offset == privateCredentialPermission.offset && this.sameMembers(this.set, privateCredentialPermission.set, this.offset);
    }

    @Override
    public boolean implies(Permission permission) {
        if (permission == null || this.getClass() != permission.getClass()) {
            return false;
        }
        PrivateCredentialPermission privateCredentialPermission = (PrivateCredentialPermission)permission;
        if (!"*".equals(this.credentialClass) && !this.credentialClass.equals(privateCredentialPermission.getCredentialClass())) {
            return false;
        }
        if (privateCredentialPermission.offset == 0) {
            return true;
        }
        CredOwner[] credOwnerArray = this.set;
        CredOwner[] credOwnerArray2 = privateCredentialPermission.set;
        int n2 = this.offset;
        int n3 = privateCredentialPermission.offset;
        int n4 = 0;
        while (n4 < n2) {
            int n5 = 0;
            while (n5 < n3) {
                if (credOwnerArray[n4].implies(credOwnerArray2[n5])) break;
                ++n5;
            }
            if (n5 == credOwnerArray2.length) {
                return false;
            }
            ++n4;
        }
        return true;
    }

    @Override
    public PermissionCollection newPermissionCollection() {
        return null;
    }

    private boolean sameMembers(Object[] objectArray, Object[] objectArray2, int n2) {
        if (objectArray == null && objectArray2 == null) {
            return true;
        }
        if (objectArray == null || objectArray2 == null) {
            return false;
        }
        int n3 = 0;
        while (n3 < n2) {
            boolean bl = false;
            int n4 = 0;
            while (n4 < n2) {
                if (objectArray[n3].equals(objectArray2[n4])) {
                    bl = true;
                    break;
                }
                ++n4;
            }
            if (!bl) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    private static final class CredOwner
    implements Serializable {
        private static final long serialVersionUID = -5607449830436408266L;
        String principalClass;
        String principalName;
        private transient boolean isClassWildcard;
        private transient boolean isPNameWildcard;

        CredOwner(String string, String string2) {
            if ("*".equals(string)) {
                this.isClassWildcard = true;
            }
            if ("*".equals(string2)) {
                this.isPNameWildcard = true;
            }
            if (this.isClassWildcard && !this.isPNameWildcard) {
                throw new IllegalArgumentException("auth.12");
            }
            this.principalClass = string;
            this.principalName = string2;
        }

        boolean implies(Object object) {
            if (object == this) {
                return true;
            }
            CredOwner credOwner = (CredOwner)object;
            return !(!this.isClassWildcard && !this.principalClass.equals(credOwner.principalClass) || !this.isPNameWildcard && !this.principalName.equals(credOwner.principalName));
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof CredOwner) {
                CredOwner credOwner = (CredOwner)object;
                return this.principalClass.equals(credOwner.principalClass) && this.principalName.equals(credOwner.principalName);
            }
            return false;
        }

        public int hashCode() {
            return this.principalClass.hashCode() + this.principalName.hashCode();
        }
    }
}

