/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber.extensions.jingle;

import java.util.List;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.ContentPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.JingleAction;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.JingleIQ;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.Reason;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.ReasonPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.SessionInfoPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.SessionInfoType;
import org.jivesoftware.smack.packet.IQ;

public class JinglePacketFactory {
    public static JingleIQ createRinging(JingleIQ jingleIQ) {
        return JinglePacketFactory.createSessionInfo(jingleIQ.getTo(), jingleIQ.getFrom(), jingleIQ.getSID(), SessionInfoType.ringing);
    }

    public static JingleIQ createSessionInfo(String string, String string2, String string3) {
        JingleIQ jingleIQ = new JingleIQ();
        jingleIQ.setFrom(string);
        jingleIQ.setTo(string2);
        jingleIQ.setType(IQ.Type.SET);
        jingleIQ.setSID(string3);
        jingleIQ.setAction(JingleAction.SESSION_INFO);
        return jingleIQ;
    }

    public static JingleIQ createSessionInfo(String string, String string2, String string3, SessionInfoType sessionInfoType) {
        JingleIQ jingleIQ = JinglePacketFactory.createSessionInfo(string, string2, string3);
        SessionInfoPacketExtension sessionInfoPacketExtension = new SessionInfoPacketExtension(sessionInfoType);
        jingleIQ.setSessionInfo(sessionInfoPacketExtension);
        return jingleIQ;
    }

    public static JingleIQ createBusy(String string, String string2, String string3) {
        return JinglePacketFactory.createSessionTerminate(string, string2, string3, Reason.BUSY, null);
    }

    public static JingleIQ createBye(String string, String string2, String string3) {
        return JinglePacketFactory.createSessionTerminate(string, string2, string3, Reason.SUCCESS, "Nice talking to you!");
    }

    public static JingleIQ createCancel(String string, String string2, String string3) {
        return JinglePacketFactory.createSessionTerminate(string, string2, string3, Reason.CANCEL, "Oops!");
    }

    public static JingleIQ createSessionTerminate(String string, String string2, String string3, Reason reason, String string4) {
        JingleIQ jingleIQ = new JingleIQ();
        jingleIQ.setTo(string2);
        jingleIQ.setFrom(string);
        jingleIQ.setType(IQ.Type.SET);
        jingleIQ.setSID(string3);
        jingleIQ.setAction(JingleAction.SESSION_TERMINATE);
        ReasonPacketExtension reasonPacketExtension = new ReasonPacketExtension(reason, string4, null);
        jingleIQ.setReason(reasonPacketExtension);
        return jingleIQ;
    }

    public static JingleIQ createSessionAccept(String string, String string2, String string3, Iterable<ContentPacketExtension> iterable) {
        JingleIQ jingleIQ = new JingleIQ();
        jingleIQ.setTo(string2);
        jingleIQ.setFrom(string);
        jingleIQ.setResponder(string);
        jingleIQ.setType(IQ.Type.SET);
        jingleIQ.setSID(string3);
        jingleIQ.setAction(JingleAction.SESSION_ACCEPT);
        for (ContentPacketExtension contentPacketExtension : iterable) {
            jingleIQ.addContent(contentPacketExtension);
        }
        return jingleIQ;
    }

    public static JingleIQ createSessionAccept(String string, String string2, String string3, String string4) {
        JingleIQ jingleIQ = new JingleIQ();
        jingleIQ.setTo(string2);
        jingleIQ.setFrom(string);
        jingleIQ.setResponder(string);
        jingleIQ.setType(IQ.Type.SET);
        jingleIQ.setSID(string3);
        jingleIQ.setAction(JingleAction.SESSION_ACCEPT);
        jingleIQ.setSdpJsonString(string4);
        return jingleIQ;
    }

    public static JingleIQ createSessionInitiate(String string, String string2, String string3, String string4, List<ContentPacketExtension> list) {
        JingleIQ jingleIQ = new JingleIQ();
        jingleIQ.setTo(string2);
        jingleIQ.setFrom(string);
        jingleIQ.setInitiator(string);
        jingleIQ.setType(IQ.Type.SET);
        jingleIQ.setSdpJsonString(string4);
        jingleIQ.setSID(string3);
        jingleIQ.setAction(JingleAction.SESSION_INITIATE);
        for (ContentPacketExtension contentPacketExtension : list) {
            jingleIQ.addContent(contentPacketExtension);
        }
        return jingleIQ;
    }

    public static JingleIQ createContentAdd(String string, String string2, String string3, List<ContentPacketExtension> list) {
        JingleIQ jingleIQ = new JingleIQ();
        jingleIQ.setTo(string2);
        jingleIQ.setFrom(string);
        jingleIQ.setInitiator(string);
        jingleIQ.setType(IQ.Type.SET);
        jingleIQ.setSID(string3);
        jingleIQ.setAction(JingleAction.CONTENT_ADD);
        for (ContentPacketExtension contentPacketExtension : list) {
            jingleIQ.addContent(contentPacketExtension);
        }
        return jingleIQ;
    }

    public static JingleIQ createContentAccept(String string, String string2, String string3, Iterable<ContentPacketExtension> iterable) {
        JingleIQ jingleIQ = new JingleIQ();
        jingleIQ.setTo(string2);
        jingleIQ.setFrom(string);
        jingleIQ.setInitiator(string);
        jingleIQ.setType(IQ.Type.SET);
        jingleIQ.setSID(string3);
        jingleIQ.setAction(JingleAction.CONTENT_ACCEPT);
        for (ContentPacketExtension contentPacketExtension : iterable) {
            jingleIQ.addContent(contentPacketExtension);
        }
        return jingleIQ;
    }

    public static JingleIQ createContentReject(String string, String string2, String string3, Iterable<ContentPacketExtension> iterable) {
        JingleIQ jingleIQ = new JingleIQ();
        jingleIQ.setTo(string2);
        jingleIQ.setFrom(string);
        jingleIQ.setInitiator(string);
        jingleIQ.setType(IQ.Type.SET);
        jingleIQ.setSID(string3);
        jingleIQ.setAction(JingleAction.CONTENT_REJECT);
        if (iterable != null) {
            for (ContentPacketExtension contentPacketExtension : iterable) {
                jingleIQ.addContent(contentPacketExtension);
            }
        }
        return jingleIQ;
    }

    public static JingleIQ createContentModify(String string, String string2, String string3, ContentPacketExtension contentPacketExtension) {
        JingleIQ jingleIQ = new JingleIQ();
        jingleIQ.setTo(string2);
        jingleIQ.setFrom(string);
        jingleIQ.setInitiator(string);
        jingleIQ.setType(IQ.Type.SET);
        jingleIQ.setSID(string3);
        jingleIQ.setAction(JingleAction.CONTENT_MODIFY);
        jingleIQ.addContent(contentPacketExtension);
        return jingleIQ;
    }

    public static JingleIQ createContentRemove(String string, String string2, String string3, Iterable<ContentPacketExtension> iterable) {
        JingleIQ jingleIQ = new JingleIQ();
        jingleIQ.setTo(string2);
        jingleIQ.setFrom(string);
        jingleIQ.setInitiator(string);
        jingleIQ.setType(IQ.Type.SET);
        jingleIQ.setSID(string3);
        jingleIQ.setAction(JingleAction.CONTENT_REMOVE);
        for (ContentPacketExtension contentPacketExtension : iterable) {
            jingleIQ.addContent(contentPacketExtension);
        }
        return jingleIQ;
    }

    public static JingleIQ createCallAccept(String string, String string2, String string3) {
        JingleIQ jingleIQ = new JingleIQ();
        jingleIQ.setTo(string2);
        jingleIQ.setFrom(string);
        jingleIQ.setInitiator(string);
        jingleIQ.setType(IQ.Type.SET);
        jingleIQ.setSID(string3);
        jingleIQ.setAction(JingleAction.CALL_ACCEPT);
        return jingleIQ;
    }

    public static JingleIQ createCallerRelay(String string, String string2, String string3, String string4) {
        JingleIQ jingleIQ = new JingleIQ();
        jingleIQ.setTo(string2);
        jingleIQ.setFrom(string);
        jingleIQ.setInitiator(string);
        jingleIQ.setType(IQ.Type.SET);
        jingleIQ.setSID(string3);
        jingleIQ.setAction(JingleAction.CALLER_RELAY);
        ReasonPacketExtension reasonPacketExtension = new ReasonPacketExtension(Reason.SUCCESS, string4, null);
        jingleIQ.setReason(reasonPacketExtension);
        return jingleIQ;
    }
}

