/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber.extensions.jingle;

import net.java.sip.communicator.impl.protocol.jabber.extensions.DefaultPacketExtensionProvider;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.CandidatePacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.CoinPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.ContentPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.CryptoPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.EncryptionPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.IceUdpTransportPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.InputEvtPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.JingleAction;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.JingleIQ;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.MuteSessionInfoPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.ParameterPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.PayloadTypePacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.RTPHdrExtPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.RawUdpTransportPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.ReasonPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.ReasonProvider;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.RemoteCandidatePacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.RtpDescriptionPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.SessionInfoPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.SessionInfoType;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.TransferPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.TransferredPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.ZrtpHashPacketExtension;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.provider.ProviderManager;
import org.xmlpull.v1.XmlPullParser;

public class JingleIQProvider
implements IQProvider {
    public JingleIQProvider() {
        ProviderManager providerManager = ProviderManager.getInstance();
        providerManager.addExtensionProvider("description", "urn:xmpp:jingle:apps:rtp:1", new DefaultPacketExtensionProvider<RtpDescriptionPacketExtension>(RtpDescriptionPacketExtension.class));
        providerManager.addExtensionProvider("payload-type", "urn:xmpp:jingle:apps:rtp:1", new DefaultPacketExtensionProvider<PayloadTypePacketExtension>(PayloadTypePacketExtension.class));
        providerManager.addExtensionProvider("parameter", "urn:xmpp:jingle:apps:rtp:1", new DefaultPacketExtensionProvider<ParameterPacketExtension>(ParameterPacketExtension.class));
        providerManager.addExtensionProvider("rtp-hdrext", "urn:xmpp:jingle:apps:rtp:rtp-hdrext:0", new DefaultPacketExtensionProvider<RTPHdrExtPacketExtension>(RTPHdrExtPacketExtension.class));
        providerManager.addExtensionProvider("encryption", "urn:xmpp:jingle:apps:rtp:1", new DefaultPacketExtensionProvider<EncryptionPacketExtension>(EncryptionPacketExtension.class));
        providerManager.addExtensionProvider("zrtp-hash", "urn:xmpp:jingle:apps:rtp:zrtp:1", new DefaultPacketExtensionProvider<ZrtpHashPacketExtension>(ZrtpHashPacketExtension.class));
        providerManager.addExtensionProvider("crypto", "urn:xmpp:jingle:apps:rtp:1", new DefaultPacketExtensionProvider<CryptoPacketExtension>(CryptoPacketExtension.class));
        providerManager.addExtensionProvider("transport", "urn:xmpp:jingle:transports:ice-udp:1", new DefaultPacketExtensionProvider<IceUdpTransportPacketExtension>(IceUdpTransportPacketExtension.class));
        providerManager.addExtensionProvider("transport", "urn:xmpp:jingle:transports:raw-udp:1", new DefaultPacketExtensionProvider<RawUdpTransportPacketExtension>(RawUdpTransportPacketExtension.class));
        providerManager.addExtensionProvider("candidate", "urn:xmpp:jingle:transports:ice-udp:1", new DefaultPacketExtensionProvider<CandidatePacketExtension>(CandidatePacketExtension.class));
        providerManager.addExtensionProvider("candidate", "urn:xmpp:jingle:transports:raw-udp:1", new DefaultPacketExtensionProvider<CandidatePacketExtension>(CandidatePacketExtension.class));
        providerManager.addExtensionProvider("remote-candidate", "urn:xmpp:jingle:transports:ice-udp:1", new DefaultPacketExtensionProvider<RemoteCandidatePacketExtension>(RemoteCandidatePacketExtension.class));
        providerManager.addExtensionProvider("inputevt", "http://jitsi.org/protocol/inputevt", new DefaultPacketExtensionProvider<InputEvtPacketExtension>(InputEvtPacketExtension.class));
        providerManager.addExtensionProvider("conference-info", "", new DefaultPacketExtensionProvider<CoinPacketExtension>(CoinPacketExtension.class));
        providerManager.addExtensionProvider("transfer", "urn:xmpp:jingle:transfer:0", new DefaultPacketExtensionProvider<TransferPacketExtension>(TransferPacketExtension.class));
        providerManager.addExtensionProvider("transferred", "urn:xmpp:jingle:transfer:0", new DefaultPacketExtensionProvider<TransferredPacketExtension>(TransferredPacketExtension.class));
    }

    @Override
    public JingleIQ parseIQ(XmlPullParser xmlPullParser) throws Exception {
        JingleIQ jingleIQ = new JingleIQ();
        JingleAction jingleAction = JingleAction.parseString(xmlPullParser.getAttributeValue("", "action"));
        String string = xmlPullParser.getAttributeValue("", "initiator");
        String string2 = xmlPullParser.getAttributeValue("", "responder");
        String string3 = xmlPullParser.getAttributeValue("", "sid");
        String string4 = xmlPullParser.getAttributeValue("", "sdp_json_string");
        jingleIQ.setAction(jingleAction);
        jingleIQ.setInitiator(string);
        jingleIQ.setResponder(string2);
        jingleIQ.setSID(string3);
        jingleIQ.setSdpJsonString(string4);
        boolean bl = false;
        DefaultPacketExtensionProvider<ContentPacketExtension> defaultPacketExtensionProvider = new DefaultPacketExtensionProvider<ContentPacketExtension>(ContentPacketExtension.class);
        ReasonProvider reasonProvider = new ReasonProvider();
        DefaultPacketExtensionProvider<TransferPacketExtension> defaultPacketExtensionProvider2 = new DefaultPacketExtensionProvider<TransferPacketExtension>(TransferPacketExtension.class);
        DefaultPacketExtensionProvider<CoinPacketExtension> defaultPacketExtensionProvider3 = new DefaultPacketExtensionProvider<CoinPacketExtension>(CoinPacketExtension.class);
        while (!bl) {
            int n2 = xmlPullParser.next();
            String string5 = xmlPullParser.getName();
            String string6 = xmlPullParser.getNamespace();
            if (n2 == 2) {
                Object object;
                if (string5.equals("content")) {
                    object = (ContentPacketExtension)defaultPacketExtensionProvider.parseExtension(xmlPullParser);
                    jingleIQ.addContent((ContentPacketExtension)object);
                } else if (string5.equals("reason")) {
                    object = reasonProvider.parseExtension(xmlPullParser);
                    jingleIQ.setReason((ReasonPacketExtension)object);
                } else if (string5.equals("transfer") && string6.equals("urn:xmpp:jingle:transfer:0")) {
                    jingleIQ.addExtension(defaultPacketExtensionProvider2.parseExtension(xmlPullParser));
                } else if (string5.equals("conference-info")) {
                    jingleIQ.addExtension(defaultPacketExtensionProvider3.parseExtension(xmlPullParser));
                }
                if (string6.equals("urn:xmpp:jingle:apps:rtp:info:1")) {
                    object = SessionInfoType.valueOf(string5);
                    if (object == SessionInfoType.mute || object == SessionInfoType.unmute) {
                        String string7 = xmlPullParser.getAttributeValue("", "name");
                        jingleIQ.setSessionInfo(new MuteSessionInfoPacketExtension(object == SessionInfoType.mute, string7));
                    } else {
                        jingleIQ.setSessionInfo(new SessionInfoPacketExtension((SessionInfoType)((Object)object)));
                    }
                }
            }
            if (n2 != 3 || !xmlPullParser.getName().equals("jingle")) continue;
            bl = true;
        }
        return jingleIQ;
    }
}

