/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber.extensions.jingle;

import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.ContentPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.JingleAction;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.ReasonPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.SessionInfoPacketExtension;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.PacketExtension;

public class JingleIQ
extends IQ {
    public static final String NAMESPACE = "urn:xmpp:jingle:1";
    public static final String ELEMENT_NAME = "jingle";
    public static final String ACTION_ATTR_NAME = "action";
    public static final String INITIATOR_ATTR_NAME = "initiator";
    public static final String RESPONDER_ATTR_NAME = "responder";
    public static final String SID_ATTR_NAME = "sid";
    public static final String SDP_JSON_STRING_ATTR_NAME = "sdp_json_string";
    private JingleAction action;
    private String initiator;
    private String responder;
    private String sid;
    private ReasonPacketExtension reason;
    private SessionInfoPacketExtension sessionInfo;
    private final List<ContentPacketExtension> contentList = new ArrayList<ContentPacketExtension>();
    private String sdp_json_string;
    private String statistic;

    @Override
    public String getChildElementXML() {
        StringBuilder stringBuilder = new StringBuilder("<jingle");
        stringBuilder.append(" xmlns='urn:xmpp:jingle:1'");
        stringBuilder.append(" action='" + (Object)((Object)this.getAction()) + "'");
        if (this.initiator != null) {
            stringBuilder.append(" initiator='" + this.getInitiator() + "'");
        }
        if (this.responder != null) {
            stringBuilder.append(" responder='" + this.getResponder() + "'");
        }
        stringBuilder.append(" sid='" + this.getSID() + "'");
        if (this.sdp_json_string != null) {
            stringBuilder.append(" sdp_json_string='" + this.getSdpJsonString() + "'");
        }
        String string = this.getExtensionsXML();
        if (this.contentList.size() == 0 && this.reason == null && this.sessionInfo == null && (string == null || string.length() == 0)) {
            stringBuilder.append("/>");
        } else {
            stringBuilder.append(">");
            if (this.statistic != null) {
                stringBuilder.append(this.statistic);
            }
            for (ContentPacketExtension contentPacketExtension : this.contentList) {
                stringBuilder.append(contentPacketExtension.toXML());
            }
            if (this.reason != null) {
                stringBuilder.append(this.reason.toXML());
            }
            if (this.sessionInfo != null) {
                stringBuilder.append(this.sessionInfo.toXML());
            }
            if (string != null && string.length() != 0) {
                stringBuilder.append(string);
            }
            stringBuilder.append("</jingle>");
        }
        return stringBuilder.toString();
    }

    public void setSID(String string) {
        this.sid = string;
    }

    public String getSID() {
        return this.sid;
    }

    public static String generateSID() {
        return new BigInteger(64, new SecureRandom()).toString(32);
    }

    public void setResponder(String string) {
        this.responder = string;
    }

    public String getResponder() {
        return this.responder;
    }

    public void setInitiator(String string) {
        this.initiator = string;
    }

    public String getInitiator() {
        return this.initiator;
    }

    public void setSdpJsonString(String string) {
        this.sdp_json_string = string;
    }

    public String getSdpJsonString() {
        return this.sdp_json_string;
    }

    public void setStatistic(String string) {
        this.statistic = string;
    }

    public String getStatistic() {
        return this.statistic;
    }

    public void setAction(JingleAction jingleAction) {
        this.action = jingleAction;
    }

    public JingleAction getAction() {
        return this.action;
    }

    public void setReason(ReasonPacketExtension reasonPacketExtension) {
        this.reason = reasonPacketExtension;
    }

    public ReasonPacketExtension getReason() {
        return this.reason;
    }

    public List<ContentPacketExtension> getContentList() {
        return this.contentList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addContent(ContentPacketExtension contentPacketExtension) {
        List<ContentPacketExtension> list = this.contentList;
        synchronized (list) {
            this.contentList.add(contentPacketExtension);
        }
    }

    public boolean containsContentChildOfType(Class<? extends PacketExtension> clazz) {
        return this.getContentForType(clazz) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContentPacketExtension getContentForType(Class<? extends PacketExtension> clazz) {
        List<ContentPacketExtension> list = this.contentList;
        synchronized (list) {
            for (ContentPacketExtension contentPacketExtension : this.contentList) {
                PacketExtension packetExtension = contentPacketExtension.getFirstChildOfType(clazz);
                if (packetExtension == null) continue;
                return contentPacketExtension;
            }
        }
        return null;
    }

    public void setSessionInfo(SessionInfoPacketExtension sessionInfoPacketExtension) {
        this.sessionInfo = sessionInfoPacketExtension;
    }

    public SessionInfoPacketExtension getSessionInfo() {
        return this.sessionInfo;
    }
}

