/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber.extensions.jingle;

import ch.imvs.sdes4j.srtp.SrtpCryptoAttribute;
import net.java.sip.communicator.impl.protocol.jabber.extensions.AbstractPacketExtension;

public class CryptoPacketExtension
extends AbstractPacketExtension {
    public static final String ELEMENT_NAME = "crypto";
    public static final String NAMESPACE = "urn:xmpp:jingle:apps:rtp:1";
    public static final String CRYPTO_SUITE_ATTR_NAME = "crypto-suite";
    public static final String KEY_PARAMS_ATTR_NAME = "key-params";
    public static final String SESSION_PARAMS_ATTR_NAME = "session-params";
    public static final String TAG_ATTR_NAME = "tag";

    public CryptoPacketExtension() {
        super(NAMESPACE, ELEMENT_NAME);
    }

    public CryptoPacketExtension(SrtpCryptoAttribute srtpCryptoAttribute) {
        this();
        this.initialize(srtpCryptoAttribute);
    }

    private void initialize(SrtpCryptoAttribute srtpCryptoAttribute) {
        this.setTag(Integer.toString(srtpCryptoAttribute.getTag()));
        this.setCryptoSuite(srtpCryptoAttribute.getCryptoSuite().encode());
        this.setKeyParams(srtpCryptoAttribute.getKeyParamsString());
        String string = srtpCryptoAttribute.getSessionParamsString();
        if (string != null) {
            this.setSessionParams(string);
        }
    }

    public void setCryptoSuite(String string) {
        super.setAttribute(CRYPTO_SUITE_ATTR_NAME, string);
    }

    public String getCryptoSuite() {
        return this.getAttributeAsString(CRYPTO_SUITE_ATTR_NAME);
    }

    public boolean equalsCryptoSuite(String string) {
        String string2 = this.getCryptoSuite();
        return CryptoPacketExtension.equalsStrings(string2, string);
    }

    public void setKeyParams(String string) {
        super.setAttribute(KEY_PARAMS_ATTR_NAME, string);
    }

    public String getKeyParams() {
        return this.getAttributeAsString(KEY_PARAMS_ATTR_NAME);
    }

    public boolean equalsKeyParams(String string) {
        String string2 = this.getKeyParams();
        return CryptoPacketExtension.equalsStrings(string2, string);
    }

    public void setSessionParams(String string) {
        super.setAttribute(SESSION_PARAMS_ATTR_NAME, string);
    }

    public String getSessionParams() {
        return this.getAttributeAsString(SESSION_PARAMS_ATTR_NAME);
    }

    public boolean equalsSessionParams(String string) {
        String string2 = this.getSessionParams();
        return CryptoPacketExtension.equalsStrings(string2, string);
    }

    public void setTag(String string) {
        super.setAttribute(TAG_ATTR_NAME, string);
    }

    public String getTag() {
        return this.getAttributeAsString(TAG_ATTR_NAME);
    }

    public boolean equalsTag(String string) {
        String string2 = this.getTag();
        return CryptoPacketExtension.equalsStrings(string2, string);
    }

    public SrtpCryptoAttribute toSrtpCryptoAttribute() {
        return SrtpCryptoAttribute.create(this.getTag(), this.getCryptoSuite(), this.getKeyParams(), this.getSessionParams());
    }

    private static boolean equalsStrings(String string, String string2) {
        return string == null && string2 == null || string.equals(string2);
    }

    public boolean equals(Object object) {
        if (object instanceof CryptoPacketExtension) {
            CryptoPacketExtension cryptoPacketExtension = (CryptoPacketExtension)object;
            return cryptoPacketExtension.equalsCryptoSuite(this.getCryptoSuite()) && cryptoPacketExtension.equalsKeyParams(this.getKeyParams()) && cryptoPacketExtension.equalsSessionParams(this.getSessionParams()) && cryptoPacketExtension.equalsTag(this.getTag());
        }
        return false;
    }
}

