/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber.extensions;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jivesoftware.smack.packet.PacketExtension;

public abstract class AbstractPacketExtension
implements PacketExtension {
    private String namespace;
    private final String elementName;
    protected final Map<String, String> attributes = new LinkedHashMap<String, String>();
    private String textContent;
    private List<PacketExtension> childExtensions = new ArrayList<PacketExtension>();

    protected AbstractPacketExtension(String string, String string2) {
        this.namespace = string;
        this.elementName = string2;
    }

    @Override
    public String getElementName() {
        return this.elementName;
    }

    public void setNamespace(String string) {
        this.namespace = string;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toXML() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<").append(this.getElementName()).append(" ");
        if (this.getNamespace() != null) {
            stringBuilder.append("xmlns='").append(this.getNamespace()).append("'");
        }
        for (Map.Entry<String, String> object2 : this.attributes.entrySet()) {
            stringBuilder.append(" ").append(object2.getKey()).append("='").append(object2.getValue()).append("'");
        }
        List<? extends PacketExtension> list = this.getChildExtensions();
        String string = this.getText();
        if (list == null) {
            if (string == null || string.length() == 0) {
                stringBuilder.append("/>");
                return stringBuilder.toString();
            }
            stringBuilder.append('>');
        } else {
            List<? extends PacketExtension> list2 = list;
            synchronized (list2) {
                if (list.isEmpty() && (string == null || string.length() == 0)) {
                    stringBuilder.append("/>");
                    return stringBuilder.toString();
                }
                stringBuilder.append(">");
                for (PacketExtension packetExtension : list) {
                    stringBuilder.append(packetExtension.toXML());
                }
            }
        }
        if (string != null && string.trim().length() > 0) {
            stringBuilder.append(string);
        }
        stringBuilder.append("</").append(this.getElementName()).append(">");
        return stringBuilder.toString();
    }

    public List<? extends PacketExtension> getChildExtensions() {
        return this.childExtensions;
    }

    public void addChildExtension(PacketExtension packetExtension) {
        this.childExtensions.add(packetExtension);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String string, Object object) {
        Map<String, String> map = this.attributes;
        synchronized (map) {
            if (object != null) {
                this.attributes.put(string, object.toString());
            } else {
                this.attributes.remove(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttribute(String string) {
        Map<String, String> map = this.attributes;
        synchronized (map) {
            this.attributes.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(String string) {
        Map<String, String> map = this.attributes;
        synchronized (map) {
            return this.attributes.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAttributeAsString(String string) {
        Map<String, String> map = this.attributes;
        synchronized (map) {
            String string2 = this.attributes.get(string);
            return string2 == null ? null : string2.toString();
        }
    }

    public int getAttributeAsInt(String string) {
        return this.getAttributeAsInt(string, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAttributeAsInt(String string, int n2) {
        Map<String, String> map = this.attributes;
        synchronized (map) {
            String string2 = this.getAttributeAsString(string);
            return string2 == null ? n2 : Integer.parseInt(string2);
        }
    }

    public URI getAttributeAsURI(String string) throws IllegalArgumentException {
        Map<String, String> map = this.attributes;
        synchronized (map) {
            String string2;
            block6: {
                string2 = this.getAttributeAsString(string);
                if (string2 != null) break block6;
                return null;
            }
            try {
                URI uRI = new URI(string2);
                return uRI;
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new IllegalArgumentException(uRISyntaxException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getAttributeNames() {
        Map<String, String> map = this.attributes;
        synchronized (map) {
            return new ArrayList<String>(this.attributes.keySet());
        }
    }

    public void setText(String string) {
        this.textContent = string;
    }

    public String getText() {
        return this.textContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends PacketExtension> T getFirstChildOfType(Class<T> clazz) {
        List<? extends PacketExtension> list;
        List<? extends PacketExtension> list2 = list = this.getChildExtensions();
        synchronized (list2) {
            for (PacketExtension packetExtension : list) {
                if (!clazz.isInstance(packetExtension)) continue;
                PacketExtension packetExtension2 = packetExtension;
                return (T)packetExtension2;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends PacketExtension> List<T> getChildExtensionsOfType(Class<T> clazz) {
        List<? extends PacketExtension> list = this.getChildExtensions();
        ArrayList<PacketExtension> arrayList = new ArrayList<PacketExtension>();
        if (list == null) {
            return arrayList;
        }
        List<? extends PacketExtension> list2 = list;
        synchronized (list2) {
            for (PacketExtension packetExtension : list) {
                if (!clazz.isInstance(packetExtension)) continue;
                PacketExtension packetExtension2 = packetExtension;
                arrayList.add(packetExtension2);
            }
        }
        return arrayList;
    }
}

