/*
 * Decompiled with CFR 0.152.
 */
package internal.org.apache.http.entity.mime.content;

import internal.org.apache.http.entity.mime.MinimalField;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class Header
implements Iterable<MinimalField> {
    private final List<MinimalField> fields = new LinkedList<MinimalField>();
    private final Map<String, List<MinimalField>> fieldMap = new HashMap<String, List<MinimalField>>();

    public void addField(MinimalField minimalField) {
        if (minimalField == null) {
            return;
        }
        String string = minimalField.getName().toLowerCase(Locale.US);
        List<MinimalField> list = this.fieldMap.get(string);
        if (list == null) {
            list = new LinkedList<MinimalField>();
            this.fieldMap.put(string, list);
        }
        list.add(minimalField);
        this.fields.add(minimalField);
    }

    public List<MinimalField> getFields() {
        return new ArrayList<MinimalField>(this.fields);
    }

    public MinimalField getField(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string.toLowerCase(Locale.US);
        List<MinimalField> list = this.fieldMap.get(string2);
        if (list != null && !list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public List<MinimalField> getFields(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string.toLowerCase(Locale.US);
        List<MinimalField> list = this.fieldMap.get(string2);
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        return new ArrayList<MinimalField>(list);
    }

    public int removeFields(String string) {
        if (string == null) {
            return 0;
        }
        String string2 = string.toLowerCase(Locale.US);
        List<MinimalField> list = this.fieldMap.remove(string2);
        if (list == null || list.isEmpty()) {
            return 0;
        }
        this.fields.removeAll(list);
        return list.size();
    }

    public void setField(MinimalField minimalField) {
        if (minimalField == null) {
            return;
        }
        String string = minimalField.getName().toLowerCase(Locale.US);
        List<MinimalField> list = this.fieldMap.get(string);
        if (list == null || list.isEmpty()) {
            this.addField(minimalField);
            return;
        }
        list.clear();
        list.add(minimalField);
        int n2 = -1;
        int n3 = 0;
        Iterator<MinimalField> iterator = this.fields.iterator();
        while (iterator.hasNext()) {
            MinimalField minimalField2 = iterator.next();
            if (minimalField2.getName().equalsIgnoreCase(minimalField.getName())) {
                iterator.remove();
                if (n2 == -1) {
                    n2 = n3;
                }
            }
            ++n3;
        }
        this.fields.add(n2, minimalField);
    }

    @Override
    public Iterator<MinimalField> iterator() {
        return Collections.unmodifiableList(this.fields).iterator();
    }

    public String toString() {
        return this.fields.toString();
    }
}

