/*
 * Decompiled with CFR 0.152.
 */
package internal.org.apache.http.entity.mime.content;

import internal.org.apache.http.entity.mime.content.AbstractContentBody;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileBody
extends AbstractContentBody {
    private final File file;
    private final String filename;
    private final String charset;

    public FileBody(File file, String string, String string2, String string3) {
        super(string2);
        if (file == null) {
            throw new IllegalArgumentException("File may not be null");
        }
        this.file = file;
        this.filename = string != null ? string : file.getName();
        this.charset = string3;
    }

    public FileBody(File file, String string, String string2) {
        this(file, null, string, string2);
    }

    public FileBody(File file, String string) {
        this(file, string, null);
    }

    public FileBody(File file) {
        this(file, "application/octet-stream");
    }

    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        if (outputStream == null) {
            throw new IllegalArgumentException("Output stream may not be null");
        }
        FileInputStream fileInputStream = new FileInputStream(this.file);
        try {
            int n2;
            byte[] byArray = new byte[4096];
            while ((n2 = ((InputStream)fileInputStream).read(byArray)) != -1) {
                outputStream.write(byArray, 0, n2);
            }
            outputStream.flush();
        }
        finally {
            ((InputStream)fileInputStream).close();
        }
    }

    @Override
    public String getTransferEncoding() {
        return "binary";
    }

    @Override
    public String getCharset() {
        return this.charset;
    }

    @Override
    public long getContentLength() {
        return this.file.length();
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    public File getFile() {
        return this.file;
    }
}

