/*
 * Decompiled with CFR 0.152.
 */
package internal.org.apache.http.entity.mime;

import internal.org.apache.http.entity.mime.FormBodyPart;
import internal.org.apache.http.entity.mime.Header;
import internal.org.apache.http.entity.mime.HttpMultipartMode;
import internal.org.apache.http.entity.mime.MIME;
import internal.org.apache.http.entity.mime.MinimalField;
import internal.org.apache.http.entity.mime.content.ContentBody;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.util.ByteArrayBuffer;

public class HttpMultipart {
    private static final ByteArrayBuffer FIELD_SEP = HttpMultipart.encode(MIME.DEFAULT_CHARSET, ": ");
    private static final ByteArrayBuffer CR_LF = HttpMultipart.encode(MIME.DEFAULT_CHARSET, "\r\n");
    private static final ByteArrayBuffer TWO_DASHES = HttpMultipart.encode(MIME.DEFAULT_CHARSET, "--");
    private final String subType;
    private final Charset charset;
    private final String boundary;
    private final List<FormBodyPart> parts;
    private final HttpMultipartMode mode;

    private static ByteArrayBuffer encode(Charset charset, String string) {
        ByteBuffer byteBuffer = charset.encode(CharBuffer.wrap(string));
        ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer(byteBuffer.remaining());
        byteArrayBuffer.append(byteBuffer.array(), byteBuffer.position(), byteBuffer.remaining());
        return byteArrayBuffer;
    }

    private static void writeBytes(ByteArrayBuffer byteArrayBuffer, OutputStream outputStream) throws IOException {
        outputStream.write(byteArrayBuffer.buffer(), 0, byteArrayBuffer.length());
    }

    private static void writeBytes(String string, Charset charset, OutputStream outputStream) throws IOException {
        ByteArrayBuffer byteArrayBuffer = HttpMultipart.encode(charset, string);
        HttpMultipart.writeBytes(byteArrayBuffer, outputStream);
    }

    private static void writeBytes(String string, OutputStream outputStream) throws IOException {
        ByteArrayBuffer byteArrayBuffer = HttpMultipart.encode(MIME.DEFAULT_CHARSET, string);
        HttpMultipart.writeBytes(byteArrayBuffer, outputStream);
    }

    private static void writeField(MinimalField minimalField, OutputStream outputStream) throws IOException {
        HttpMultipart.writeBytes(minimalField.getName(), outputStream);
        HttpMultipart.writeBytes(FIELD_SEP, outputStream);
        HttpMultipart.writeBytes(minimalField.getBody(), outputStream);
        HttpMultipart.writeBytes(CR_LF, outputStream);
    }

    private static void writeField(MinimalField minimalField, Charset charset, OutputStream outputStream) throws IOException {
        HttpMultipart.writeBytes(minimalField.getName(), charset, outputStream);
        HttpMultipart.writeBytes(FIELD_SEP, outputStream);
        HttpMultipart.writeBytes(minimalField.getBody(), charset, outputStream);
        HttpMultipart.writeBytes(CR_LF, outputStream);
    }

    public HttpMultipart(String string, Charset charset, String string2, HttpMultipartMode httpMultipartMode) {
        if (string == null) {
            throw new IllegalArgumentException("Multipart subtype may not be null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("Multipart boundary may not be null");
        }
        this.subType = string;
        this.charset = charset != null ? charset : MIME.DEFAULT_CHARSET;
        this.boundary = string2;
        this.parts = new ArrayList<FormBodyPart>();
        this.mode = httpMultipartMode;
    }

    public HttpMultipart(String string, Charset charset, String string2) {
        this(string, charset, string2, HttpMultipartMode.STRICT);
    }

    public HttpMultipart(String string, String string2) {
        this(string, null, string2);
    }

    public String getSubType() {
        return this.subType;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public HttpMultipartMode getMode() {
        return this.mode;
    }

    public List<FormBodyPart> getBodyParts() {
        return this.parts;
    }

    public void addBodyPart(FormBodyPart formBodyPart) {
        if (formBodyPart == null) {
            return;
        }
        this.parts.add(formBodyPart);
    }

    public String getBoundary() {
        return this.boundary;
    }

    private void doWriteTo(HttpMultipartMode httpMultipartMode, OutputStream outputStream, boolean bl) throws IOException {
        ByteArrayBuffer byteArrayBuffer = HttpMultipart.encode(this.charset, this.getBoundary());
        for (FormBodyPart formBodyPart : this.parts) {
            HttpMultipart.writeBytes(TWO_DASHES, outputStream);
            HttpMultipart.writeBytes(byteArrayBuffer, outputStream);
            HttpMultipart.writeBytes(CR_LF, outputStream);
            Header header = formBodyPart.getHeader();
            switch (httpMultipartMode) {
                case STRICT: {
                    for (MinimalField minimalField : header) {
                        HttpMultipart.writeField(minimalField, outputStream);
                    }
                    break;
                }
                case BROWSER_COMPATIBLE: {
                    MinimalField minimalField;
                    minimalField = formBodyPart.getHeader().getField("Content-Disposition");
                    HttpMultipart.writeField(minimalField, this.charset, outputStream);
                    String string = formBodyPart.getBody().getFilename();
                    if (string == null) break;
                    MinimalField minimalField2 = formBodyPart.getHeader().getField("Content-Type");
                    HttpMultipart.writeField(minimalField2, this.charset, outputStream);
                }
            }
            HttpMultipart.writeBytes(CR_LF, outputStream);
            if (bl) {
                formBodyPart.getBody().writeTo(outputStream);
            }
            HttpMultipart.writeBytes(CR_LF, outputStream);
        }
        HttpMultipart.writeBytes(TWO_DASHES, outputStream);
        HttpMultipart.writeBytes(byteArrayBuffer, outputStream);
        HttpMultipart.writeBytes(TWO_DASHES, outputStream);
        HttpMultipart.writeBytes(CR_LF, outputStream);
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        this.doWriteTo(this.mode, outputStream, true);
    }

    public long getTotalLength() {
        long l2 = 0L;
        for (FormBodyPart object2 : this.parts) {
            ContentBody contentBody = object2.getBody();
            long l3 = contentBody.getContentLength();
            if (l3 >= 0L) {
                l2 += l3;
                continue;
            }
            return -1L;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.doWriteTo(this.mode, byteArrayOutputStream, false);
            Object object3 = byteArrayOutputStream.toByteArray();
            return l2 + (long)((Object)object3).length;
        }
        catch (IOException iOException) {
            return -1L;
        }
    }
}

