/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sdp.fields;

import gov.nist.core.NameValue;
import gov.nist.javax.sdp.fields.SDPField;
import javax.sdp.Attribute;
import javax.sdp.SdpException;
import javax.sdp.SdpParseException;

public class AttributeField
extends SDPField
implements Attribute {
    protected NameValue attribute;

    public NameValue getAttribute() {
        return this.attribute;
    }

    public AttributeField() {
        super("a=");
    }

    public void setAttribute(NameValue nameValue) {
        this.attribute = nameValue;
        this.attribute.setSeparator(":");
    }

    @Override
    public String encode() {
        String string = "a=";
        if (this.attribute != null) {
            string = String.valueOf(string) + this.attribute.encode();
        }
        return String.valueOf(string) + "\r\n";
    }

    @Override
    public String toString() {
        return this.encode();
    }

    @Override
    public String getName() throws SdpParseException {
        NameValue nameValue = this.getAttribute();
        if (nameValue == null) {
            return null;
        }
        String string = nameValue.getName();
        if (string == null) {
            return null;
        }
        return string;
    }

    @Override
    public void setName(String string) throws SdpException {
        if (string == null) {
            throw new SdpException("The name is null");
        }
        NameValue nameValue = this.getAttribute();
        if (nameValue == null) {
            nameValue = new NameValue();
        }
        nameValue.setName(string);
        this.setAttribute(nameValue);
    }

    @Override
    public boolean hasValue() throws SdpParseException {
        NameValue nameValue = this.getAttribute();
        if (nameValue == null) {
            return false;
        }
        Object object = nameValue.getValueAsObject();
        return object != null;
    }

    @Override
    public String getValue() throws SdpParseException {
        NameValue nameValue = this.getAttribute();
        if (nameValue == null) {
            return null;
        }
        Object object = nameValue.getValueAsObject();
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return (String)object;
        }
        return object.toString();
    }

    @Override
    public void setValue(String string) throws SdpException {
        if (string == null) {
            throw new SdpException("The value is null");
        }
        NameValue nameValue = this.getAttribute();
        if (nameValue == null) {
            nameValue = new NameValue();
        }
        nameValue.setValueAsObject(string);
        this.setAttribute(nameValue);
    }

    public void setValueAllowNull(String string) {
        NameValue nameValue = this.getAttribute();
        if (nameValue == null) {
            nameValue = new NameValue();
        }
        nameValue.setValueAsObject(string);
        this.setAttribute(nameValue);
    }

    @Override
    public Object clone() {
        AttributeField attributeField = (AttributeField)super.clone();
        if (this.attribute != null) {
            attributeField.attribute = (NameValue)this.attribute.clone();
        }
        return attributeField;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof AttributeField)) {
            return false;
        }
        AttributeField attributeField = (AttributeField)object;
        return attributeField.getAttribute().getName().equalsIgnoreCase(this.getAttribute().getName()) && this.getAttribute().getValueAsObject().equals(attributeField.getAttribute().getValueAsObject());
    }

    public int hashCode() {
        if (this.getAttribute() == null) {
            throw new UnsupportedOperationException("Attribute is null cannot compute hashCode ");
        }
        return this.encode().hashCode();
    }
}

