/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.core;

import gov.nist.core.GenericObject;
import gov.nist.core.GenericObjectList;
import java.util.Map;

public class NameValue
extends GenericObject
implements Map.Entry<String, String> {
    private static final long serialVersionUID = -1857729012596437950L;
    protected boolean isQuotedString;
    protected final boolean isFlagParameter;
    private String separator;
    private String quotes;
    private String name;
    private Object value;

    public NameValue() {
        this.name = null;
        this.value = "";
        this.separator = "=";
        this.quotes = "";
        this.isFlagParameter = false;
    }

    public NameValue(String string, Object object, boolean bl) {
        this.name = string;
        this.value = object;
        this.separator = "=";
        this.quotes = "";
        this.isFlagParameter = bl;
    }

    public NameValue(String string, Object object) {
        this(string, object, false);
    }

    public void setSeparator(String string) {
        this.separator = string;
    }

    public void setQuotedValue() {
        this.isQuotedString = true;
        this.quotes = "\"";
    }

    public boolean isValueQuoted() {
        return this.isQuotedString;
    }

    public String getName() {
        return this.name;
    }

    public Object getValueAsObject() {
        return this.isFlagParameter ? "" : this.value;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setValueAsObject(Object object) {
        this.value = object;
    }

    @Override
    public String encode() {
        return this.encode(new StringBuilder()).toString();
    }

    @Override
    public StringBuilder encode(StringBuilder stringBuilder) {
        if (this.name != null && this.value != null && !this.isFlagParameter) {
            if (GenericObject.isMySubclass(this.value.getClass())) {
                GenericObject genericObject = (GenericObject)this.value;
                stringBuilder.append(this.name).append(this.separator).append(this.quotes);
                genericObject.encode(stringBuilder);
                stringBuilder.append(this.quotes);
                return stringBuilder;
            }
            if (GenericObjectList.isMySubclass(this.value.getClass())) {
                GenericObjectList genericObjectList = (GenericObjectList)this.value;
                stringBuilder.append(this.name).append(this.separator).append(genericObjectList.encode());
                return stringBuilder;
            }
            if (this.value.toString().length() == 0) {
                if (this.isQuotedString) {
                    stringBuilder.append(this.name).append(this.separator).append(this.quotes).append(this.quotes);
                    return stringBuilder;
                }
                stringBuilder.append(this.name).append(this.separator);
                return stringBuilder;
            }
            stringBuilder.append(this.name).append(this.separator).append(this.quotes).append(this.value.toString()).append(this.quotes);
            return stringBuilder;
        }
        if (this.name == null && this.value != null) {
            if (GenericObject.isMySubclass(this.value.getClass())) {
                GenericObject genericObject = (GenericObject)this.value;
                genericObject.encode(stringBuilder);
                return stringBuilder;
            }
            if (GenericObjectList.isMySubclass(this.value.getClass())) {
                GenericObjectList genericObjectList = (GenericObjectList)this.value;
                stringBuilder.append(genericObjectList.encode());
                return stringBuilder;
            }
            stringBuilder.append(this.quotes).append(this.value.toString()).append(this.quotes);
            return stringBuilder;
        }
        if (this.name != null && (this.value == null || this.isFlagParameter)) {
            stringBuilder.append(this.name);
            return stringBuilder;
        }
        return stringBuilder;
    }

    @Override
    public Object clone() {
        NameValue nameValue = (NameValue)super.clone();
        if (this.value != null) {
            nameValue.value = NameValue.makeClone(this.value);
        }
        return nameValue;
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!object.getClass().equals(this.getClass())) {
            return false;
        }
        NameValue nameValue = (NameValue)object;
        if (this == nameValue) {
            return true;
        }
        if (this.name == null && nameValue.name != null || this.name != null && nameValue.name == null) {
            return false;
        }
        if (this.name != null && nameValue.name != null && this.name.compareToIgnoreCase(nameValue.name) != 0) {
            return false;
        }
        if (this.value != null && nameValue.value == null || this.value == null && nameValue.value != null) {
            return false;
        }
        if (this.value == nameValue.value) {
            return true;
        }
        if (this.value instanceof String) {
            if (this.isQuotedString) {
                return this.value.equals(nameValue.value);
            }
            String string = (String)this.value;
            String string2 = (String)nameValue.value;
            return string.compareToIgnoreCase(string2) == 0;
        }
        return this.value.equals(nameValue.value);
    }

    @Override
    public String getKey() {
        return this.name;
    }

    @Override
    public String getValue() {
        return this.value == null ? null : this.value.toString();
    }

    @Override
    public String setValue(String string) {
        String string2 = this.value == null ? null : string;
        this.value = string;
        return string2;
    }

    @Override
    public int hashCode() {
        return this.encode().toLowerCase().hashCode();
    }
}

