/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.core;

import com.easemob.util.EMLog;
import gov.nist.core.GenericObject;
import gov.nist.core.InternalErrorHandler;
import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public abstract class GenericObjectList
extends LinkedList<GenericObject>
implements Serializable,
Cloneable {
    private static final String TAG = "GenericObjectList";
    protected static final String SEMICOLON = ";";
    protected static final String COLON = ":";
    protected static final String COMMA = ",";
    protected static final String SLASH = "/";
    protected static final String SP = " ";
    protected static final String EQUALS = "=";
    protected static final String STAR = "*";
    protected static final String NEWLINE = "\r\n";
    protected static final String RETURN = "\n";
    protected static final String LESS_THAN = "<";
    protected static final String GREATER_THAN = ">";
    protected static final String AT = "@";
    protected static final String DOT = ".";
    protected static final String QUESTION = "?";
    protected static final String POUND = "#";
    protected static final String AND = "&";
    protected static final String LPAREN = "(";
    protected static final String RPAREN = ")";
    protected static final String DOUBLE_QUOTE = "\"";
    protected static final String QUOTE = "'";
    protected static final String HT = "\t";
    protected static final String PERCENT = "%";
    protected int indentation;
    protected String listName = null;
    private ListIterator<? extends GenericObject> myListIterator;
    private String stringRep = "";
    protected Class<?> myClass;

    protected String getIndentation() {
        char[] cArray = new char[this.indentation];
        Arrays.fill(cArray, ' ');
        return new String(cArray);
    }

    protected static boolean isCloneable(Object object) {
        return object instanceof Cloneable;
    }

    public static boolean isMySubclass(Class<?> clazz) {
        return GenericObjectList.class.isAssignableFrom(clazz);
    }

    @Override
    public Object clone() {
        GenericObjectList genericObjectList = (GenericObjectList)super.clone();
        ListIterator<GenericObject> listIterator = genericObjectList.listIterator();
        while (listIterator.hasNext()) {
            GenericObject genericObject = (GenericObject)((GenericObject)listIterator.next()).clone();
            listIterator.set(genericObject);
        }
        return genericObjectList;
    }

    public void setMyClass(Class clazz) {
        this.myClass = clazz;
    }

    protected GenericObjectList() {
    }

    protected GenericObjectList(String string) {
        this();
        this.listName = string;
    }

    protected GenericObjectList(String string, String string2) {
        this(string);
        try {
            this.myClass = Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            InternalErrorHandler.handleException(classNotFoundException);
        }
    }

    protected GenericObjectList(String string, Class clazz) {
        this(string);
        this.myClass = clazz;
    }

    protected GenericObject next(ListIterator listIterator) {
        try {
            return (GenericObject)listIterator.next();
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
    }

    protected GenericObject first() {
        this.myListIterator = this.listIterator(0);
        try {
            return this.myListIterator.next();
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
    }

    protected GenericObject next() {
        if (this.myListIterator == null) {
            this.myListIterator = this.listIterator(0);
        }
        try {
            return this.myListIterator.next();
        }
        catch (NoSuchElementException noSuchElementException) {
            this.myListIterator = null;
            return null;
        }
    }

    protected void concatenate(GenericObjectList genericObjectList) {
        this.concatenate(genericObjectList, false);
    }

    protected void concatenate(GenericObjectList genericObjectList, boolean bl) {
        if (!bl) {
            this.addAll(genericObjectList);
        } else {
            this.addAll(0, genericObjectList);
        }
    }

    private void sprint(String string) {
        if (string == null) {
            this.stringRep = String.valueOf(this.stringRep) + this.getIndentation();
            this.stringRep = String.valueOf(this.stringRep) + "<null>\n";
            return;
        }
        if (string.compareTo("}") == 0 || string.compareTo("]") == 0) {
            --this.indentation;
        }
        this.stringRep = String.valueOf(this.stringRep) + this.getIndentation();
        this.stringRep = String.valueOf(this.stringRep) + string;
        this.stringRep = String.valueOf(this.stringRep) + RETURN;
        if (string.compareTo("{") == 0 || string.compareTo("[") == 0) {
            ++this.indentation;
        }
    }

    public String debugDump() {
        this.stringRep = "";
        GenericObject genericObject = this.first();
        if (genericObject == null) {
            return "<null>";
        }
        this.sprint("listName:");
        this.sprint(this.listName);
        this.sprint("{");
        while (genericObject != null) {
            this.sprint("[");
            this.sprint(genericObject.debugDump(this.indentation));
            genericObject = this.next();
            this.sprint("]");
        }
        this.sprint("}");
        return this.stringRep;
    }

    public String debugDump(int n2) {
        int n3 = this.indentation;
        this.indentation = n2;
        String string = this.debugDump();
        this.indentation = n3;
        return string;
    }

    @Override
    public void addFirst(GenericObject genericObject) {
        if (this.myClass == null) {
            this.myClass = genericObject.getClass();
        } else {
            super.addFirst(genericObject);
        }
    }

    public void mergeObjects(GenericObjectList genericObjectList) {
        if (genericObjectList == null) {
            return;
        }
        ListIterator listIterator = this.listIterator();
        ListIterator listIterator2 = genericObjectList.listIterator();
        while (listIterator.hasNext()) {
            GenericObject genericObject = (GenericObject)listIterator.next();
            while (listIterator2.hasNext()) {
                Object e2 = listIterator2.next();
                genericObject.merge(e2);
            }
        }
    }

    public String encode() {
        if (this.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        ListIterator listIterator = this.listIterator();
        if (listIterator.hasNext()) {
            while (true) {
                Object e2;
                if ((e2 = listIterator.next()) instanceof GenericObject) {
                    GenericObject genericObject = (GenericObject)e2;
                    stringBuilder.append(genericObject.encode());
                } else {
                    stringBuilder.append(e2.toString());
                }
                if (!listIterator.hasNext()) break;
                stringBuilder.append(SEMICOLON);
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public String toString() {
        return this.encode();
    }

    @Override
    public int hashCode() {
        return 42;
    }

    @Override
    public boolean equals(Object object) {
        Object e2;
        ListIterator listIterator;
        ListIterator listIterator2;
        if (object == null) {
            return false;
        }
        if (!this.getClass().equals(object.getClass())) {
            return false;
        }
        GenericObjectList genericObjectList = (GenericObjectList)object;
        if (this.size() != genericObjectList.size()) {
            return false;
        }
        ListIterator listIterator3 = this.listIterator();
        while (listIterator3.hasNext()) {
            listIterator2 = listIterator3.next();
            listIterator = genericObjectList.listIterator();
            try {
                while (!listIterator2.equals(e2 = listIterator.next())) {
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                return false;
            }
        }
        listIterator2 = genericObjectList.listIterator();
        while (listIterator2.hasNext()) {
            listIterator = listIterator2.next();
            listIterator3 = this.listIterator();
            try {
                while (!listIterator.equals(e2 = listIterator3.next())) {
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                return false;
            }
        }
        return true;
    }

    public boolean match(Object object) {
        block5: {
            if (!this.getClass().equals(object.getClass())) {
                return false;
            }
            GenericObjectList genericObjectList = (GenericObjectList)object;
            ListIterator listIterator = genericObjectList.listIterator();
            if (listIterator.hasNext()) {
                Object e2 = listIterator.next();
                Object object2 = null;
                ListIterator listIterator2 = this.listIterator();
                while (listIterator2.hasNext()) {
                    object2 = listIterator2.next();
                    if (object2 instanceof GenericObject) {
                        EMLog.d(TAG, "Trying to match  = " + ((GenericObject)object2).encode());
                    }
                    if (!(GenericObject.isMySubclass(object2.getClass()) && ((GenericObject)object2).match(e2) || GenericObjectList.isMySubclass(object2.getClass()) && ((GenericObjectList)object2).match(e2))) {
                        continue;
                    }
                    break block5;
                }
                EMLog.d(TAG, ((GenericObject)e2).encode());
                return false;
            }
        }
        return true;
    }
}

