/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.core;

import gov.nist.core.GenericObjectList;
import gov.nist.core.InternalErrorHandler;
import gov.nist.core.Match;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public abstract class GenericObject
implements Serializable,
Cloneable {
    protected static final String SEMICOLON = ";";
    protected static final String COLON = ":";
    protected static final String COMMA = ",";
    protected static final String SLASH = "/";
    protected static final String SP = " ";
    protected static final String EQUALS = "=";
    protected static final String STAR = "*";
    protected static final String NEWLINE = "\r\n";
    protected static final String RETURN = "\n";
    protected static final String LESS_THAN = "<";
    protected static final String GREATER_THAN = ">";
    protected static final String AT = "@";
    protected static final String DOT = ".";
    protected static final String QUESTION = "?";
    protected static final String POUND = "#";
    protected static final String AND = "&";
    protected static final String LPAREN = "(";
    protected static final String RPAREN = ")";
    protected static final String DOUBLE_QUOTE = "\"";
    protected static final String QUOTE = "'";
    protected static final String HT = "\t";
    protected static final String PERCENT = "%";
    protected static final Set<Class<?>> immutableClasses = new HashSet(10);
    static final String[] immutableClassNames = new String[]{"String", "Character", "Boolean", "Byte", "Short", "Integer", "Long", "Float", "Double"};
    protected int indentation = 0;
    protected String stringRepresentation = "";
    protected Match matchExpression;

    static {
        try {
            int n2 = 0;
            while (n2 < immutableClassNames.length) {
                immutableClasses.add(Class.forName("java.lang." + immutableClassNames[n2]));
                ++n2;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("Internal error", classNotFoundException);
        }
    }

    public void setMatcher(Match match) {
        if (match == null) {
            throw new IllegalArgumentException("null arg!");
        }
        this.matchExpression = match;
    }

    public Match getMatcher() {
        return this.matchExpression;
    }

    public static Class<?> getClassFromName(String string) {
        try {
            return Class.forName(string);
        }
        catch (Exception exception) {
            InternalErrorHandler.handleException(exception);
            return null;
        }
    }

    public static boolean isMySubclass(Class<?> clazz) {
        return GenericObject.class.isAssignableFrom(clazz);
    }

    public static Object makeClone(Object object) {
        if (object == null) {
            throw new NullPointerException("null obj!");
        }
        Class<?> clazz = object.getClass();
        Object object2 = object;
        if (immutableClasses.contains(clazz)) {
            return object;
        }
        if (clazz.isArray()) {
            Class<?> clazz2 = clazz.getComponentType();
            if (!clazz2.isPrimitive()) {
                object2 = ((Object[])object).clone();
            } else {
                if (clazz2 == Character.TYPE) {
                    object2 = ((char[])object).clone();
                } else if (clazz2 == Boolean.TYPE) {
                    object2 = ((boolean[])object).clone();
                }
                if (clazz2 == Byte.TYPE) {
                    object2 = ((byte[])object).clone();
                } else if (clazz2 == Short.TYPE) {
                    object2 = ((short[])object).clone();
                } else if (clazz2 == Integer.TYPE) {
                    object2 = ((int[])object).clone();
                } else if (clazz2 == Long.TYPE) {
                    object2 = ((long[])object).clone();
                } else if (clazz2 == Float.TYPE) {
                    object2 = ((float[])object).clone();
                } else if (clazz2 == Double.TYPE) {
                    object2 = ((double[])object).clone();
                }
            }
        } else if (GenericObject.class.isAssignableFrom(clazz)) {
            object2 = ((GenericObject)object).clone();
        } else if (GenericObjectList.class.isAssignableFrom(clazz)) {
            object2 = ((GenericObjectList)object).clone();
        } else if (Cloneable.class.isAssignableFrom(clazz)) {
            try {
                Method method = clazz.getMethod("clone", null);
                object2 = method.invoke(object, null);
            }
            catch (SecurityException securityException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                InternalErrorHandler.handleException(illegalArgumentException);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return object2;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("Internal error");
        }
    }

    public void merge(Object object) {
        if (object == null) {
            return;
        }
        if (!object.getClass().equals(this.getClass())) {
            throw new IllegalArgumentException("Bad override object");
        }
        Class<?> clazz = this.getClass();
        do {
            Field[] fieldArray = clazz.getDeclaredFields();
            int n2 = 0;
            while (n2 < fieldArray.length) {
                Field field = fieldArray[n2];
                int n3 = field.getModifiers();
                if (!(Modifier.isPrivate(n3) || Modifier.isStatic(n3) || Modifier.isInterface(n3))) {
                    Class<?> clazz2 = field.getType();
                    String string = clazz2.toString();
                    try {
                        if (clazz2.isPrimitive()) {
                            if (string.compareTo("int") == 0) {
                                int n4 = field.getInt(object);
                                field.setInt(this, n4);
                            } else if (string.compareTo("short") == 0) {
                                short s2 = field.getShort(object);
                                field.setShort(this, s2);
                            } else if (string.compareTo("char") == 0) {
                                char c2 = field.getChar(object);
                                field.setChar(this, c2);
                            } else if (string.compareTo("long") == 0) {
                                long l2 = field.getLong(object);
                                field.setLong(this, l2);
                            } else if (string.compareTo("boolean") == 0) {
                                boolean bl = field.getBoolean(object);
                                field.setBoolean(this, bl);
                            } else if (string.compareTo("double") == 0) {
                                double d2 = field.getDouble(object);
                                field.setDouble(this, d2);
                            } else if (string.compareTo("float") == 0) {
                                float f2 = field.getFloat(object);
                                field.setFloat(this, f2);
                            }
                        } else {
                            Object object2 = field.get(this);
                            Object object3 = field.get(object);
                            if (object3 != null) {
                                if (object2 == null) {
                                    field.set(this, object3);
                                } else if (object2 instanceof GenericObject) {
                                    GenericObject genericObject = (GenericObject)object2;
                                    genericObject.merge(object3);
                                } else {
                                    field.set(this, object3);
                                }
                            }
                        }
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        illegalAccessException.printStackTrace();
                    }
                }
                ++n2;
            }
        } while (!(clazz = clazz.getSuperclass()).equals(GenericObject.class));
    }

    protected GenericObject() {
    }

    protected String getIndentation() {
        char[] cArray = new char[this.indentation];
        Arrays.fill(cArray, ' ');
        return new String(cArray);
    }

    protected void sprint(String string) {
        if (string == null) {
            this.stringRepresentation = String.valueOf(this.stringRepresentation) + this.getIndentation();
            this.stringRepresentation = String.valueOf(this.stringRepresentation) + "<null>\n";
            return;
        }
        if (string.compareTo("}") == 0 || string.compareTo("]") == 0) {
            --this.indentation;
        }
        this.stringRepresentation = String.valueOf(this.stringRepresentation) + this.getIndentation();
        this.stringRepresentation = String.valueOf(this.stringRepresentation) + string;
        this.stringRepresentation = String.valueOf(this.stringRepresentation) + RETURN;
        if (string.compareTo("{") == 0 || string.compareTo("[") == 0) {
            ++this.indentation;
        }
    }

    protected void sprint(Object object) {
        this.sprint(object.toString());
    }

    protected void sprint(int n2) {
        this.sprint(String.valueOf(n2));
    }

    protected void sprint(short s2) {
        this.sprint(String.valueOf(s2));
    }

    protected void sprint(char c2) {
        this.sprint(String.valueOf(c2));
    }

    protected void sprint(long l2) {
        this.sprint(String.valueOf(l2));
    }

    protected void sprint(boolean bl) {
        this.sprint(String.valueOf(bl));
    }

    protected void sprint(double d2) {
        this.sprint(String.valueOf(d2));
    }

    protected void sprint(float f2) {
        this.sprint(String.valueOf(f2));
    }

    protected void dbgPrint() {
    }

    protected void dbgPrint(String string) {
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!this.getClass().equals(object.getClass())) {
            return false;
        }
        Class<?> clazz = this.getClass();
        Class<?> clazz2 = object.getClass();
        while (true) {
            Field[] fieldArray = clazz.getDeclaredFields();
            Field[] fieldArray2 = clazz2.getDeclaredFields();
            int n2 = 0;
            while (n2 < fieldArray.length) {
                Field field = fieldArray[n2];
                Field field2 = fieldArray2[n2];
                int n3 = field.getModifiers();
                if ((n3 & 2) != 2) {
                    Class<?> clazz3 = field.getType();
                    String string = field.getName();
                    if (string.compareTo("stringRepresentation") != 0 && string.compareTo("indentation") != 0) {
                        block37: {
                            block36: {
                                block35: {
                                    block34: {
                                        block27: {
                                            String string2;
                                            block33: {
                                                block32: {
                                                    block31: {
                                                        block30: {
                                                            block29: {
                                                                block28: {
                                                                    if (!clazz3.isPrimitive()) break block27;
                                                                    string2 = clazz3.toString();
                                                                    if (string2.compareTo("int") != 0) break block28;
                                                                    if (field.getInt(this) != field2.getInt(object)) {
                                                                        return false;
                                                                    }
                                                                }
                                                                if (string2.compareTo("short") != 0) break block29;
                                                                if (field.getShort(this) != field2.getShort(object)) {
                                                                    return false;
                                                                }
                                                            }
                                                            if (string2.compareTo("char") != 0) break block30;
                                                            if (field.getChar(this) != field2.getChar(object)) {
                                                                return false;
                                                            }
                                                        }
                                                        if (string2.compareTo("long") != 0) break block31;
                                                        if (field.getLong(this) != field2.getLong(object)) {
                                                            return false;
                                                        }
                                                    }
                                                    if (string2.compareTo("boolean") != 0) break block32;
                                                    if (field.getBoolean(this) != field2.getBoolean(object)) {
                                                        return false;
                                                    }
                                                }
                                                if (string2.compareTo("double") != 0) break block33;
                                                if (field.getDouble(this) != field2.getDouble(object)) {
                                                    return false;
                                                }
                                            }
                                            if (string2.compareTo("float") == 0 && field.getFloat(this) != field2.getFloat(object)) {
                                                return false;
                                            }
                                        }
                                        if (field2.get(object) != field.get(this)) break block34;
                                        return true;
                                    }
                                    if (field.get(this) != null) break block35;
                                    return false;
                                }
                                if (field2.get(object) != null) break block36;
                                return false;
                            }
                            if (field2.get(object) != null || field.get(this) == null) break block37;
                            return false;
                        }
                        try {
                            if (!field.get(this).equals(field2.get(object))) {
                                return false;
                            }
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            InternalErrorHandler.handleException(illegalAccessException);
                        }
                    }
                }
                ++n2;
            }
            if (clazz.equals(GenericObject.class)) break;
            clazz = clazz.getSuperclass();
            clazz2 = clazz2.getSuperclass();
        }
        return true;
    }

    public boolean match(Object object) {
        if (object == null) {
            return true;
        }
        if (!this.getClass().equals(object.getClass())) {
            return false;
        }
        GenericObject genericObject = (GenericObject)object;
        Class<?> clazz = this.getClass();
        Field[] fieldArray = clazz.getDeclaredFields();
        Class<?> clazz2 = object.getClass();
        Field[] fieldArray2 = clazz2.getDeclaredFields();
        int n2 = 0;
        while (n2 < fieldArray.length) {
            block34: {
                Field field = fieldArray[n2];
                Field field2 = fieldArray2[n2];
                int n3 = field.getModifiers();
                if ((n3 & 2) != 2) {
                    Class<?> clazz3 = field.getType();
                    String string = field.getName();
                    if (string.compareTo("stringRepresentation") != 0 && string.compareTo("indentation") != 0) {
                        Object object2;
                        Object object3;
                        block36: {
                            block35: {
                                block33: {
                                    block26: {
                                        block32: {
                                            block31: {
                                                block30: {
                                                    block29: {
                                                        block28: {
                                                            block27: {
                                                                if (!clazz3.isPrimitive()) break block26;
                                                                object3 = clazz3.toString();
                                                                if (((String)object3).compareTo("int") != 0) break block27;
                                                                if (field.getInt(this) != field2.getInt(genericObject)) {
                                                                    return false;
                                                                }
                                                            }
                                                            if (((String)object3).compareTo("short") != 0) break block28;
                                                            if (field.getShort(this) != field2.getShort(genericObject)) {
                                                                return false;
                                                            }
                                                        }
                                                        if (((String)object3).compareTo("char") != 0) break block29;
                                                        if (field.getChar(this) != field2.getChar(genericObject)) {
                                                            return false;
                                                        }
                                                    }
                                                    if (((String)object3).compareTo("long") != 0) break block30;
                                                    if (field.getLong(this) != field2.getLong(genericObject)) {
                                                        return false;
                                                    }
                                                }
                                                if (((String)object3).compareTo("boolean") != 0) break block31;
                                                if (field.getBoolean(this) != field2.getBoolean(genericObject)) {
                                                    return false;
                                                }
                                            }
                                            if (((String)object3).compareTo("double") != 0) break block32;
                                            if (field.getDouble(this) != field2.getDouble(genericObject)) {
                                                return false;
                                            }
                                        }
                                        if (((String)object3).compareTo("float") == 0 && field.getFloat(this) != field2.getFloat(genericObject)) {
                                            return false;
                                        }
                                    }
                                    object3 = field.get(this);
                                    object2 = field2.get(genericObject);
                                    if (object2 == null || object3 != null) break block33;
                                    return false;
                                }
                                if (object2 == null && object3 != null || object2 == null && object3 == null) break block34;
                                if (!(object2 instanceof String) || !(object3 instanceof String)) break block35;
                                if (!((String)object2).trim().equals("") && ((String)object3).compareToIgnoreCase((String)object2) != 0) {
                                    return false;
                                }
                            }
                            if (!GenericObject.isMySubclass(object3.getClass()) || ((GenericObject)object3).match(object2)) break block36;
                            return false;
                        }
                        try {
                            if (GenericObjectList.isMySubclass(object3.getClass()) && !((GenericObjectList)object3).match(object2)) {
                                return false;
                            }
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            InternalErrorHandler.handleException(illegalAccessException);
                        }
                    }
                }
            }
            ++n2;
        }
        return true;
    }

    public String debugDump() {
        this.stringRepresentation = "";
        Class<?> clazz = this.getClass();
        this.sprint(clazz.getName());
        this.sprint("{");
        Field[] fieldArray = clazz.getDeclaredFields();
        int n2 = 0;
        while (n2 < fieldArray.length) {
            Field field = fieldArray[n2];
            int n3 = field.getModifiers();
            if ((n3 & 2) != 2) {
                Class<?> clazz2 = field.getType();
                String string = field.getName();
                if (string.compareTo("stringRepresentation") != 0 && string.compareTo("indentation") != 0) {
                    this.sprint(String.valueOf(string) + COLON);
                    try {
                        if (clazz2.isPrimitive()) {
                            String string2 = clazz2.toString();
                            this.sprint(String.valueOf(string2) + COLON);
                            if (string2.compareTo("int") == 0) {
                                int n4 = field.getInt(this);
                                this.sprint(n4);
                            } else if (string2.compareTo("short") == 0) {
                                short s2 = field.getShort(this);
                                this.sprint(s2);
                            } else if (string2.compareTo("char") == 0) {
                                char c2 = field.getChar(this);
                                this.sprint(c2);
                            } else if (string2.compareTo("long") == 0) {
                                long l2 = field.getLong(this);
                                this.sprint(l2);
                            } else if (string2.compareTo("boolean") == 0) {
                                boolean bl = field.getBoolean(this);
                                this.sprint(bl);
                            } else if (string2.compareTo("double") == 0) {
                                double d2 = field.getDouble(this);
                                this.sprint(d2);
                            } else if (string2.compareTo("float") == 0) {
                                float f2 = field.getFloat(this);
                                this.sprint(f2);
                            }
                        } else if (GenericObject.class.isAssignableFrom(clazz2)) {
                            if (field.get(this) != null) {
                                this.sprint(((GenericObject)field.get(this)).debugDump(this.indentation + 1));
                            } else {
                                this.sprint("<null>");
                            }
                        } else if (GenericObjectList.class.isAssignableFrom(clazz2)) {
                            if (field.get(this) != null) {
                                this.sprint(((GenericObjectList)field.get(this)).debugDump(this.indentation + 1));
                            } else {
                                this.sprint("<null>");
                            }
                        } else {
                            if (field.get(this) != null) {
                                this.sprint(String.valueOf(field.get(this).getClass().getName()) + COLON);
                            } else {
                                this.sprint(String.valueOf(clazz2.getName()) + COLON);
                            }
                            this.sprint("{");
                            if (field.get(this) != null) {
                                this.sprint(field.get(this).toString());
                            } else {
                                this.sprint("<null>");
                            }
                            this.sprint("}");
                        }
                    }
                    catch (IllegalAccessException illegalAccessException) {
                    }
                    catch (Exception exception) {
                        InternalErrorHandler.handleException(exception);
                    }
                }
            }
            ++n2;
        }
        this.sprint("}");
        return this.stringRepresentation;
    }

    public String debugDump(int n2) {
        this.indentation = n2;
        String string = this.debugDump();
        this.indentation = 0;
        return string;
    }

    public abstract String encode();

    public StringBuilder encode(StringBuilder stringBuilder) {
        return stringBuilder.append(this.encode());
    }
}

