/*
 * Decompiled with CFR 0.152.
 */
package com.xonami.javaBells;

import com.easemob.util.EMLog;
import com.xonami.javaBells.DefaultJingleSession;
import com.xonami.javaBells.JingleSession;
import java.util.HashMap;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.JingleIQ;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.Packet;

public class JinglePacketHandler
implements PacketListener,
PacketFilter {
    protected final HashMap<String, JingleSession> jingleSessions = new HashMap();
    protected final HashMap<String, JingleSession> deadSessions = new HashMap();
    protected final XMPPConnection connection;

    public JinglePacketHandler(XMPPConnection xMPPConnection) {
        this.connection = xMPPConnection;
        xMPPConnection.addPacketListener(this, this);
    }

    @Override
    public void processPacket(Packet packet) {
        String string;
        JingleSession jingleSession;
        JingleIQ jingleIQ = (JingleIQ)packet;
        try {
            if (jingleIQ.getReason() != null) {
                EMLog.d("JinglePacketHandler", "received jiq, action: " + (Object)((Object)jingleIQ.getAction()) + ", reason: " + (Object)((Object)jingleIQ.getReason().getReason()));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if ((jingleSession = this.deadSessions.get(string = jingleIQ.getSID())) != null) {
            EMLog.d("JinglePacketHandler", "deadSessions.get(sid) != null");
            return;
        }
        jingleSession = this.jingleSessions.get(string);
        if (jingleSession == null) {
            jingleSession = this.createJingleSession(string, jingleIQ);
            if (jingleSession == null) {
                return;
            }
            this.jingleSessions.put(string, jingleSession);
        }
        switch (jingleIQ.getAction()) {
            case CONTENT_ACCEPT: {
                jingleSession.handleContentAcept(jingleIQ);
                break;
            }
            case CONTENT_ADD: {
                jingleSession.handleContentAdd(jingleIQ);
                break;
            }
            case CONTENT_MODIFY: {
                jingleSession.handleContentModify(jingleIQ);
                break;
            }
            case CONTENT_REJECT: {
                jingleSession.handleContentReject(jingleIQ);
                break;
            }
            case CONTENT_REMOVE: {
                jingleSession.handleContentRemove(jingleIQ);
                break;
            }
            case DESCRIPTION_INFO: {
                jingleSession.handleDescriptionInfo(jingleIQ);
                break;
            }
            case SECURITY_INFO: {
                jingleSession.handleSecurityInfo(jingleIQ);
                break;
            }
            case SESSION_ACCEPT: {
                jingleSession.handleSessionAccept(jingleIQ);
                break;
            }
            case SESSION_INFO: {
                jingleSession.handleSessionInfo(jingleIQ);
                break;
            }
            case SESSION_INITIATE: {
                jingleSession.handleSessionInitiate(jingleIQ);
                break;
            }
            case SESSION_TERMINATE: {
                jingleSession.handleSessionTerminate(jingleIQ);
                break;
            }
            case TRANSPORT_ACCEPT: {
                jingleSession.handleTransportAccept(jingleIQ);
                break;
            }
            case TRANSPORT_INFO: {
                jingleSession.handleTransportInfo(jingleIQ);
                break;
            }
            case TRANSPORT_REJECT: {
                jingleSession.handleTransportReject(jingleIQ);
                break;
            }
            case TRANSPORT_REPLACE: {
                jingleSession.handleSessionReplace(jingleIQ);
            }
        }
    }

    public JingleSession removeJingleSession(JingleSession jingleSession) {
        JingleSession jingleSession2 = this.jingleSessions.remove(jingleSession.getSessionId());
        this.deadSessions.put(jingleSession.getSessionId(), jingleSession);
        return jingleSession2;
    }

    public JingleSession createInitateJingleSession(String string) {
        JingleSession jingleSession = this.createJingleSession(string, null);
        this.jingleSessions.put(string, jingleSession);
        return jingleSession;
    }

    public JingleSession createJingleSession(String string, JingleIQ jingleIQ) {
        return new DefaultJingleSession(this, string, this.connection);
    }

    @Override
    public boolean accept(Packet packet) {
        return packet.getClass() == JingleIQ.class;
    }

    public void clear() {
        this.jingleSessions.clear();
        this.deadSessions.clear();
    }
}

