/*
 * Decompiled with CFR 0.152.
 */
package com.xonami.javaBells;

import com.easemob.util.EMLog;
import com.xonami.javaBells.JinglePacketHandler;
import com.xonami.javaBells.JingleSession;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.JingleIQ;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.JinglePacketFactory;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.Reason;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.PacketExtension;

public class DefaultJingleSession
implements JingleSession {
    private static final String TAG = "DefaultJingleSession";
    protected final JinglePacketHandler jinglePacketHandler;
    protected final String myJid;
    protected final String sessionId;
    protected final XMPPConnection connection;
    protected SessionState state;
    protected String peerJid;

    public DefaultJingleSession(JinglePacketHandler jinglePacketHandler, String string, XMPPConnection xMPPConnection) {
        this.jinglePacketHandler = jinglePacketHandler;
        this.myJid = xMPPConnection.getUser();
        this.sessionId = string;
        this.connection = xMPPConnection;
        this.state = SessionState.NEW;
    }

    protected boolean checkAndAck(JingleIQ jingleIQ) {
        if (this.peerJid == null) {
            return false;
        }
        if (this.state == SessionState.CLOSED) {
            return false;
        }
        if (this.peerJid.equals(jingleIQ.getFrom())) {
            this.ack(jingleIQ);
            return true;
        }
        this.closeSession(Reason.CONNECTIVITY_ERROR);
        return false;
    }

    protected boolean check(JingleIQ jingleIQ) {
        if (this.peerJid == null) {
            throw new RuntimeException("Don't call this before setting peerJid!");
        }
        if (this.state == SessionState.CLOSED) {
            return false;
        }
        if (this.peerJid.equals(jingleIQ.getFrom())) {
            return true;
        }
        this.closeSession(Reason.CONNECTIVITY_ERROR);
        return false;
    }

    protected void closeSession(final Reason reason) {
        if (this.state == SessionState.CLOSED) {
            return;
        }
        if (reason != null) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        DefaultJingleSession.this.connection.sendPacket(JinglePacketFactory.createSessionTerminate(DefaultJingleSession.this.myJid, DefaultJingleSession.this.peerJid, DefaultJingleSession.this.sessionId, reason, null));
                    }
                    catch (IllegalStateException illegalStateException) {
                        illegalStateException.printStackTrace();
                        EMLog.e(DefaultJingleSession.TAG, "no connection!");
                    }
                }
            }).start();
        }
        EMLog.d(TAG, "close sesstion, state: " + (Object)((Object)this.state));
        this.state = SessionState.CLOSED;
        this.jinglePacketHandler.removeJingleSession(this);
    }

    public void ack(IQ iQ) {
        IQ iQ2 = IQ.createResultIQ(iQ);
        this.connection.sendPacket(iQ2);
    }

    public void unsupportedInfo(IQ iQ) {
        IQ iQ2 = IQ.createResultIQ(iQ);
        iQ2.setType(IQ.Type.ERROR);
        iQ2.addExtension(new PacketExtension(){

            @Override
            public String getElementName() {
                return "error";
            }

            @Override
            public String getNamespace() {
                return null;
            }

            @Override
            public String toXML() {
                return "<error type='modify'><feature-not-implemented xmlns='urn:ietf:params:xml:ns:xmpp-stanzas'/><unsupported-info xmlns='urn:xmpp:jingle:errors:1'/></error>";
            }
        });
        this.connection.sendPacket(iQ2);
    }

    @Override
    public void handleContentAcept(JingleIQ jingleIQ) {
        this.checkAndAck(jingleIQ);
    }

    @Override
    public void handleContentAdd(JingleIQ jingleIQ) {
        this.checkAndAck(jingleIQ);
    }

    @Override
    public void handleContentModify(JingleIQ jingleIQ) {
        this.checkAndAck(jingleIQ);
    }

    @Override
    public void handleContentReject(JingleIQ jingleIQ) {
        this.checkAndAck(jingleIQ);
    }

    @Override
    public void handleContentRemove(JingleIQ jingleIQ) {
        this.checkAndAck(jingleIQ);
    }

    @Override
    public void handleDescriptionInfo(JingleIQ jingleIQ) {
        this.checkAndAck(jingleIQ);
    }

    @Override
    public void handleSecurityInfo(JingleIQ jingleIQ) {
        this.checkAndAck(jingleIQ);
    }

    @Override
    public void handleSessionAccept(JingleIQ jingleIQ) {
        this.checkAndAck(jingleIQ);
    }

    @Override
    public void handleSessionInfo(JingleIQ jingleIQ) {
        this.checkAndAck(jingleIQ);
    }

    @Override
    public void handleSessionInitiate(JingleIQ jingleIQ) {
        if (this.state == SessionState.CLOSED) {
            return;
        }
        this.ack(jingleIQ);
        this.peerJid = jingleIQ.getFrom();
        JingleIQ jingleIQ2 = JinglePacketFactory.createCancel(this.myJid, this.peerJid, this.sessionId);
        this.connection.sendPacket(jingleIQ2);
        this.closeSession(Reason.DECLINE);
    }

    @Override
    public void handleSessionTerminate(JingleIQ jingleIQ) {
        if (!this.checkAndAck(jingleIQ)) {
            return;
        }
        this.closeSession(null);
    }

    @Override
    public void handleTransportAccept(JingleIQ jingleIQ) {
        this.checkAndAck(jingleIQ);
    }

    @Override
    public void handleTransportInfo(JingleIQ jingleIQ) {
        this.checkAndAck(jingleIQ);
    }

    @Override
    public void handleTransportReject(JingleIQ jingleIQ) {
        if (!this.checkAndAck(jingleIQ)) {
            return;
        }
        this.closeSession(Reason.GENERAL_ERROR);
    }

    @Override
    public void handleSessionReplace(JingleIQ jingleIQ) {
        this.checkAndAck(jingleIQ);
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    public static enum SessionState {
        NEW,
        NEGOTIATING_TRANSPORT,
        OPEN,
        CLOSED;

    }
}

