/*
 * Decompiled with CFR 0.152.
 */
package com.novell.sasl.client;

import com.novell.sasl.client.ParsedDirective;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.harmony.javax.security.sasl.SaslException;

class DirectiveList {
    private static final int STATE_LOOKING_FOR_FIRST_DIRECTIVE = 1;
    private static final int STATE_LOOKING_FOR_DIRECTIVE = 2;
    private static final int STATE_SCANNING_NAME = 3;
    private static final int STATE_LOOKING_FOR_EQUALS = 4;
    private static final int STATE_LOOKING_FOR_VALUE = 5;
    private static final int STATE_LOOKING_FOR_COMMA = 6;
    private static final int STATE_SCANNING_QUOTED_STRING_VALUE = 7;
    private static final int STATE_SCANNING_TOKEN_VALUE = 8;
    private static final int STATE_NO_UTF8_SUPPORT = 9;
    private int m_curPos = 0;
    private int m_errorPos = -1;
    private String m_directives;
    private int m_state = 1;
    private ArrayList m_directiveList = new ArrayList(10);
    private String m_curName;
    private int m_scanStart = 0;

    DirectiveList(byte[] byArray) {
        try {
            this.m_directives = new String(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.m_state = 9;
        }
    }

    void parseDirectives() throws SaslException {
        boolean bl = false;
        boolean bl2 = false;
        String string = "<no name>";
        if (this.m_state == 9) {
            throw new SaslException("No UTF-8 support on platform");
        }
        char c2 = '\u0000';
        while (this.m_curPos < this.m_directives.length()) {
            char c3 = this.m_directives.charAt(this.m_curPos);
            switch (this.m_state) {
                case 1: 
                case 2: {
                    if (this.isWhiteSpace(c3)) break;
                    if (this.isValidTokenChar(c3)) {
                        this.m_scanStart = this.m_curPos;
                        this.m_state = 3;
                        break;
                    }
                    this.m_errorPos = this.m_curPos;
                    throw new SaslException("Parse error: Invalid name character");
                }
                case 3: {
                    if (this.isValidTokenChar(c3)) break;
                    if (this.isWhiteSpace(c3)) {
                        string = this.m_directives.substring(this.m_scanStart, this.m_curPos);
                        this.m_state = 4;
                        break;
                    }
                    if ('=' == c3) {
                        string = this.m_directives.substring(this.m_scanStart, this.m_curPos);
                        this.m_state = 5;
                        break;
                    }
                    this.m_errorPos = this.m_curPos;
                    throw new SaslException("Parse error: Invalid name character");
                }
                case 4: {
                    if (this.isWhiteSpace(c3)) break;
                    if ('=' == c3) {
                        this.m_state = 5;
                        break;
                    }
                    this.m_errorPos = this.m_curPos;
                    throw new SaslException("Parse error: Expected equals sign '='.");
                }
                case 5: {
                    if (this.isWhiteSpace(c3)) break;
                    if ('\"' == c3) {
                        this.m_scanStart = this.m_curPos + 1;
                        this.m_state = 7;
                        break;
                    }
                    if (this.isValidTokenChar(c3)) {
                        this.m_scanStart = this.m_curPos;
                        this.m_state = 8;
                        break;
                    }
                    this.m_errorPos = this.m_curPos;
                    throw new SaslException("Parse error: Unexpected character");
                }
                case 8: {
                    if (this.isValidTokenChar(c3)) break;
                    if (this.isWhiteSpace(c3)) {
                        this.addDirective(string, false);
                        this.m_state = 6;
                        break;
                    }
                    if (',' == c3) {
                        this.addDirective(string, false);
                        this.m_state = 2;
                        break;
                    }
                    this.m_errorPos = this.m_curPos;
                    throw new SaslException("Parse error: Invalid value character");
                }
                case 7: {
                    if ('\\' == c3) {
                        bl2 = true;
                    }
                    if ('\"' != c3 || '\\' == c2) break;
                    this.addDirective(string, bl2);
                    bl2 = false;
                    this.m_state = 6;
                    break;
                }
                case 6: {
                    if (this.isWhiteSpace(c3)) break;
                    if (c3 == ',') {
                        this.m_state = 2;
                        break;
                    }
                    this.m_errorPos = this.m_curPos;
                    throw new SaslException("Parse error: Expected a comma.");
                }
            }
            if (bl) break;
            c2 = c3;
            ++this.m_curPos;
        }
        if (!bl) {
            switch (this.m_state) {
                case 8: {
                    this.addDirective(string, false);
                    break;
                }
                case 1: 
                case 6: {
                    break;
                }
                case 2: {
                    throw new SaslException("Parse error: Trailing comma.");
                }
                case 3: 
                case 4: 
                case 5: {
                    throw new SaslException("Parse error: Missing value.");
                }
                case 7: {
                    throw new SaslException("Parse error: Missing closing quote.");
                }
            }
        }
    }

    boolean isValidTokenChar(char c2) {
        return !(c2 >= '\u0000' && c2 <= ' ' || c2 >= ':' && c2 <= '@' || c2 >= '[' && c2 <= ']' || ',' == c2 || '%' == c2 || '(' == c2 || ')' == c2 || '{' == c2 || '}' == c2) && '\u007f' != c2;
    }

    boolean isWhiteSpace(char c2) {
        return '\t' == c2 || '\n' == c2 || '\r' == c2 || ' ' == c2;
    }

    void addDirective(String string, boolean bl) {
        String string2;
        if (!bl) {
            string2 = this.m_directives.substring(this.m_scanStart, this.m_curPos);
        } else {
            StringBuffer stringBuffer = new StringBuffer(this.m_curPos - this.m_scanStart);
            int n2 = 0;
            int n3 = this.m_scanStart;
            while (n3 < this.m_curPos) {
                char c2 = this.m_directives.charAt(n3);
                if ('\\' == c2) {
                    ++n3;
                }
                stringBuffer.setCharAt(n2, this.m_directives.charAt(n3));
                ++n2;
                ++n3;
            }
            string2 = new String(stringBuffer);
        }
        int n4 = this.m_state == 7 ? 1 : 2;
        this.m_directiveList.add(new ParsedDirective(string, string2, n4));
    }

    Iterator getIterator() {
        return this.m_directiveList.iterator();
    }
}

