/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.util;

import android.content.Context;
import android.media.MediaRecorder;
import android.os.Handler;
import android.os.Message;
import android.os.SystemClock;
import android.text.format.Time;
import com.easemob.util.EMLog;
import com.easemob.util.PathUtil;
import java.io.File;
import java.io.IOException;
import java.util.Date;

public class VoiceRecorder {
    MediaRecorder recorder;
    static final String PREFIX = "voice";
    static final String EXTENSION = ".amr";
    private boolean isRecording = false;
    private long startTime;
    private String voiceFilePath = null;
    private String voiceFileName = null;
    private File file;
    private Handler handler;

    public VoiceRecorder(Handler handler) {
        this.handler = handler;
    }

    public String startRecording(String string, String string2, Context context) {
        this.file = null;
        try {
            if (this.recorder != null) {
                this.recorder.release();
                this.recorder = null;
            }
            this.recorder = new MediaRecorder();
            this.recorder.setAudioSource(1);
            this.recorder.setOutputFormat(3);
            this.recorder.setAudioEncoder(1);
            this.recorder.setAudioChannels(1);
            this.recorder.setAudioSamplingRate(8000);
            this.recorder.setAudioEncodingBitRate(64);
            this.voiceFileName = this.getVoiceFileName(string2);
            this.voiceFilePath = this.getVoiceFilePath();
            this.file = new File(this.voiceFilePath);
            this.recorder.setOutputFile(this.file.getAbsolutePath());
            this.recorder.prepare();
            this.isRecording = true;
            this.recorder.start();
        }
        catch (IOException iOException) {
            EMLog.e(PREFIX, "prepare() failed");
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    while (VoiceRecorder.this.isRecording) {
                        Message message = new Message();
                        message.what = VoiceRecorder.this.recorder.getMaxAmplitude() * 13 / Short.MAX_VALUE;
                        VoiceRecorder.this.handler.sendMessage(message);
                        SystemClock.sleep((long)100L);
                    }
                }
                catch (Exception exception) {
                    EMLog.e(VoiceRecorder.PREFIX, exception.toString());
                }
            }
        }).start();
        this.startTime = new Date().getTime();
        EMLog.d(PREFIX, "start voice recording to file:" + this.file.getAbsolutePath());
        return this.file == null ? null : this.file.getAbsolutePath();
    }

    public void discardRecording() {
        if (this.recorder != null) {
            try {
                this.recorder.stop();
                this.recorder.release();
                this.recorder = null;
                if (this.file != null && this.file.exists() && !this.file.isDirectory()) {
                    this.file.delete();
                }
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            this.isRecording = false;
        }
    }

    public int stopRecoding() {
        if (this.recorder != null) {
            this.isRecording = false;
            this.recorder.stop();
            this.recorder.release();
            this.recorder = null;
            if (this.file == null || !this.file.exists() || !this.file.isFile()) {
                return -1011;
            }
            if (this.file.length() == 0L) {
                this.file.delete();
                return -1011;
            }
            int n2 = (int)(new Date().getTime() - this.startTime) / 1000;
            EMLog.d(PREFIX, "voice recording finished. seconds:" + n2 + " file length:" + this.file.length());
            return n2;
        }
        return 0;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.recorder != null) {
            this.recorder.release();
        }
    }

    public String getVoiceFileName(String string) {
        Time time = new Time();
        time.setToNow();
        return String.valueOf(string) + time.toString().substring(0, 15) + EXTENSION;
    }

    public boolean isRecording() {
        return this.isRecording;
    }

    public String getVoiceFilePath() {
        return PathUtil.getInstance().getVoicePath() + "/" + this.voiceFileName;
    }
}

