/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.util;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.telephony.TelephonyManager;
import com.easemob.util.EMLog;

public class NetUtils {
    private static final String TAG = "net";
    private static final int LOW_SPEED_UPLOAD_BUF_SIZE = 1024;
    private static final int HIGH_SPEED_UPLOAD_BUF_SIZE = 10240;
    private static final int MAX_SPEED_UPLOAD_BUF_SIZE = 102400;
    private static final int LOW_SPEED_DOWNLOAD_BUF_SIZE = 2024;
    private static final int HIGH_SPEED_DOWNLOAD_BUF_SIZE = 30720;
    private static final int MAX_SPEED_DOWNLOAD_BUF_SIZE = 102400;

    public static boolean hasNetwork(Context context) {
        if (context != null) {
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            if (networkInfo != null) {
                return networkInfo.isAvailable();
            }
            return false;
        }
        return false;
    }

    public static boolean hasDataConnection(Context context) {
        block5: {
            NetworkInfo networkInfo;
            ConnectivityManager connectivityManager;
            block4: {
                try {
                    connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
                    networkInfo = connectivityManager.getNetworkInfo(1);
                    if (networkInfo == null || !networkInfo.isAvailable() || !networkInfo.isConnected()) break block4;
                    EMLog.d(TAG, "has wifi connection");
                    return true;
                }
                catch (Exception exception) {
                    return false;
                }
            }
            networkInfo = connectivityManager.getNetworkInfo(0);
            if (networkInfo == null || !networkInfo.isAvailable() || !networkInfo.isConnected()) break block5;
            EMLog.d(TAG, "has mobile connection");
            return true;
        }
        EMLog.d(TAG, "no data connection");
        return false;
    }

    public static boolean aaa(Context context) {
        block5: {
            NetworkInfo networkInfo;
            ConnectivityManager connectivityManager;
            block4: {
                try {
                    connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
                    networkInfo = connectivityManager.getNetworkInfo(1);
                    if (networkInfo == null || !networkInfo.isAvailable() || !networkInfo.isConnected()) break block4;
                    EMLog.d(TAG, "has wifi connection");
                    return true;
                }
                catch (Exception exception) {
                    return false;
                }
            }
            networkInfo = connectivityManager.getNetworkInfo(0);
            if (networkInfo == null || !networkInfo.isAvailable() || !networkInfo.isConnected()) break block5;
            EMLog.d(TAG, "has mobile connection");
            return true;
        }
        EMLog.d(TAG, "no data connection");
        return false;
    }

    public static boolean isWifiConnection(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getNetworkInfo(1);
        if (networkInfo != null && networkInfo.isConnected()) {
            EMLog.d(TAG, "wifi is connected");
            return true;
        }
        return false;
    }

    public static int getUploadBufSize(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo != null && networkInfo.getType() == 1) {
            return 102400;
        }
        if (networkInfo == null && NetUtils.isConnectionFast(networkInfo.getType(), networkInfo.getSubtype())) {
            return 10240;
        }
        return 1024;
    }

    public static int getDownloadBufSize(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo != null && networkInfo.getType() == 1) {
            return 102400;
        }
        if (networkInfo == null && NetUtils.isConnectionFast(networkInfo.getType(), networkInfo.getSubtype())) {
            return 30720;
        }
        return 2024;
    }

    private static boolean isConnectionFast(int n2, int n3) {
        if (n2 == 1) {
            return true;
        }
        if (n2 == 0) {
            switch (n3) {
                case 7: {
                    return false;
                }
                case 4: {
                    return false;
                }
                case 2: {
                    return false;
                }
                case 5: {
                    return true;
                }
                case 6: {
                    return true;
                }
                case 1: {
                    return false;
                }
                case 8: {
                    return true;
                }
                case 10: {
                    return true;
                }
                case 9: {
                    return true;
                }
                case 3: {
                    return true;
                }
            }
            if (Build.VERSION.SDK_INT >= 11 && (n3 == 14 || n3 == 13)) {
                return true;
            }
            if (Build.VERSION.SDK_INT >= 9 && n3 == 12) {
                return true;
            }
            if (Build.VERSION.SDK_INT >= 8 && n3 == 11) {
                return false;
            }
        }
        return false;
    }

    public static String getNetworkType(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo != null && networkInfo.isAvailable()) {
            int n2 = networkInfo.getType();
            if (n2 == 1) {
                return "WIFI";
            }
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            switch (telephonyManager.getNetworkType()) {
                case 1: 
                case 2: 
                case 4: 
                case 7: 
                case 11: {
                    return "2G";
                }
                case 3: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 12: 
                case 14: 
                case 15: {
                    return "3G";
                }
                case 13: {
                    return "4G";
                }
            }
            return "unkonw network";
        }
        return "no network";
    }
}

