/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.util;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.media.ExifInterface;
import android.media.ThumbnailUtils;
import com.easemob.util.EMLog;
import com.easemob.util.PathUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;

public class ImageUtils {
    public static final int SCALE_IMAGE_WIDTH = 640;
    public static final int SCALE_IMAGE_HEIGHT = 960;

    public static Bitmap getRoundedCornerBitmap(Bitmap bitmap) {
        return ImageUtils.getRoundedCornerBitmap(bitmap, 6.0f);
    }

    public static Bitmap getRoundedCornerBitmap(Bitmap bitmap, float f2) {
        Bitmap bitmap2 = Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap2);
        int n2 = -12434878;
        Paint paint = new Paint();
        Rect rect = new Rect(0, 0, bitmap.getWidth(), bitmap.getHeight());
        RectF rectF = new RectF(rect);
        float f3 = f2;
        paint.setAntiAlias(true);
        canvas.drawARGB(0, 0, 0, 0);
        paint.setColor(-12434878);
        canvas.drawRoundRect(rectF, f3, f3, paint);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(bitmap, rect, rect, paint);
        return bitmap2;
    }

    public static Bitmap getVideoThumbnail(String string, int n2, int n3, int n4) {
        Bitmap bitmap = null;
        bitmap = ThumbnailUtils.createVideoThumbnail((String)string, (int)n4);
        EMLog.d("getVideoThumbnail", "video thumb width:" + bitmap.getWidth());
        EMLog.d("getVideoThumbnail", "video thumb height:" + bitmap.getHeight());
        bitmap = ThumbnailUtils.extractThumbnail((Bitmap)bitmap, (int)n2, (int)n3, (int)2);
        return bitmap;
    }

    public static String saveVideoThumb(File file, int n2, int n3, int n4) {
        Bitmap bitmap = ImageUtils.getVideoThumbnail(file.getAbsolutePath(), n2, n3, n4);
        File file2 = new File(PathUtil.getInstance().getVideoPath(), "th" + file.getName());
        try {
            file2.createNewFile();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)fileOutputStream);
        try {
            fileOutputStream.flush();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        try {
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return file2.getAbsolutePath();
    }

    public static Bitmap decodeScaleImage(String string, int n2, int n3) {
        BitmapFactory.Options options = ImageUtils.getBitmapOptions(string);
        int n4 = ImageUtils.calculateInSampleSize(options, n2, n3);
        EMLog.d("img", "original wid" + options.outWidth + " original height:" + options.outHeight + " sample:" + n4);
        options.inSampleSize = n4;
        options.inJustDecodeBounds = false;
        Bitmap bitmap = BitmapFactory.decodeFile((String)string, (BitmapFactory.Options)options);
        int n5 = ImageUtils.readPictureDegree(string);
        Bitmap bitmap2 = null;
        if (bitmap != null && n5 != 0) {
            bitmap2 = ImageUtils.rotaingImageView(n5, bitmap);
            bitmap.recycle();
            bitmap = null;
            return bitmap2;
        }
        return bitmap;
    }

    public static Bitmap decodeScaleImage(Context context, int n2, int n3, int n4) {
        int n5;
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeResource((Resources)context.getResources(), (int)n2, (BitmapFactory.Options)options);
        options.inSampleSize = n5 = ImageUtils.calculateInSampleSize(options, n3, n4);
        options.inJustDecodeBounds = false;
        Bitmap bitmap = BitmapFactory.decodeResource((Resources)context.getResources(), (int)n2, (BitmapFactory.Options)options);
        return bitmap;
    }

    public static int calculateInSampleSize(BitmapFactory.Options options, int n2, int n3) {
        int n4 = options.outHeight;
        int n5 = options.outWidth;
        int n6 = 1;
        if (n4 > n3 || n5 > n2) {
            int n7;
            int n8 = Math.round((float)n4 / (float)n3);
            n6 = n8 > (n7 = Math.round((float)n5 / (float)n2)) ? n8 : n7;
        }
        return n6;
    }

    public static String getThumbnailImage(String string, int n2) {
        Bitmap bitmap = ImageUtils.decodeScaleImage(string, n2, n2);
        try {
            File file = File.createTempFile("image", ".jpg");
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            bitmap.compress(Bitmap.CompressFormat.JPEG, 60, (OutputStream)fileOutputStream);
            fileOutputStream.close();
            EMLog.d("img", "generate thumbnail image at:" + file.getAbsolutePath() + " size:" + file.length());
            return file.getAbsolutePath();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return string;
        }
    }

    public static String getScaledImage(Context context, String string) {
        File file = new File(string);
        if (!file.exists()) {
            return string;
        }
        long l2 = file.length();
        EMLog.d("img", "original img size:" + l2);
        if (l2 <= 102400L) {
            EMLog.d("img", "use original small image");
            return string;
        }
        Bitmap bitmap = ImageUtils.decodeScaleImage(string, 640, 960);
        try {
            File file2 = File.createTempFile("image", ".jpg", context.getFilesDir());
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            bitmap.compress(Bitmap.CompressFormat.JPEG, 70, (OutputStream)fileOutputStream);
            fileOutputStream.close();
            EMLog.d("img", "compared to small fle" + file2.getAbsolutePath() + " size:" + file2.length());
            return file2.getAbsolutePath();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return string;
        }
    }

    public static String getScaledImage(Context context, String string, int n2) {
        File file = new File(string);
        if (file.exists()) {
            long l2 = file.length();
            EMLog.d("img", "original img size:" + l2);
            if (l2 > 102400L) {
                Bitmap bitmap = ImageUtils.decodeScaleImage(string, 640, 960);
                try {
                    File file2 = new File(context.getExternalCacheDir(), "eaemobTemp" + n2 + ".jpg");
                    FileOutputStream fileOutputStream = new FileOutputStream(file2);
                    bitmap.compress(Bitmap.CompressFormat.JPEG, 60, (OutputStream)fileOutputStream);
                    fileOutputStream.close();
                    EMLog.d("img", "compared to small fle" + file2.getAbsolutePath() + " size:" + file2.length());
                    return file2.getAbsolutePath();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return string;
    }

    public static Bitmap mergeImages(int n2, int n3, List<Bitmap> list) {
        Bitmap bitmap = Bitmap.createBitmap((int)n2, (int)n3, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        canvas.drawColor(-3355444);
        EMLog.d("img", "merge images to size:" + n2 + "*" + n3 + " with images:" + list.size());
        int n4 = list.size() <= 4 ? 2 : 3;
        int n5 = 0;
        int n6 = (n2 - 4) / n4;
        int n7 = 0;
        while (n7 < n4) {
            int n8 = 0;
            while (n8 < n4) {
                Bitmap bitmap2 = list.get(n5);
                Bitmap bitmap3 = Bitmap.createScaledBitmap((Bitmap)bitmap2, (int)n6, (int)n6, (boolean)true);
                Bitmap bitmap4 = ImageUtils.getRoundedCornerBitmap(bitmap3, 2.0f);
                bitmap3.recycle();
                canvas.drawBitmap(bitmap4, (float)(n8 * n6 + (n8 + 2)), (float)(n7 * n6 + (n7 + 2)), null);
                bitmap4.recycle();
                if (++n5 == list.size()) {
                    return bitmap;
                }
                ++n8;
            }
            ++n7;
        }
        return bitmap;
    }

    public static int readPictureDegree(String string) {
        int n2 = 0;
        try {
            ExifInterface exifInterface = new ExifInterface(string);
            int n3 = exifInterface.getAttributeInt("Orientation", 1);
            switch (n3) {
                case 6: {
                    n2 = 90;
                    break;
                }
                case 3: {
                    n2 = 180;
                    break;
                }
                case 8: {
                    n2 = 270;
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return n2;
    }

    public static Bitmap rotaingImageView(int n2, Bitmap bitmap) {
        Matrix matrix = new Matrix();
        matrix.postRotate((float)n2);
        Bitmap bitmap2 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
        return bitmap2;
    }

    public static BitmapFactory.Options getBitmapOptions(String string) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)string, (BitmapFactory.Options)options);
        return options;
    }
}

