/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.util;

import android.content.Context;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import android.util.Log;
import com.easemob.chat.EMChat;
import com.easemob.chat.EMChatConfig;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

class FileLogger {
    private static final String TAG = "FileLogger";
    private static final long MB = 0x100000L;
    private static final long LOG_LIMIT = 0x800000L;
    private static final long FREE_SPACE_LIMIT = 0x1400000L;
    private static final long FREE_SPACE_TIMER = 1200000L;
    private static final String INFO_COLOR = "green";
    private static final String ERROR_COLOR = "red";
    private static final String WARN_COLOR = "orange";
    private static final String DEBUG_COLOR = "blue";
    private ExecutorService singleThreadService = Executors.newSingleThreadExecutor();
    private File logRoot = null;
    private Timer timer = null;
    private boolean spaceAvailable = true;

    FileLogger() {
    }

    void d(String string, String string2) {
        this.startThreadService(DEBUG_COLOR, "[" + string + "]" + string2);
    }

    void e(String string, String string2) {
        this.startThreadService(ERROR_COLOR, "[" + string + "]" + "[ERROR]" + string2);
    }

    void i(String string, String string2) {
        this.startThreadService(INFO_COLOR, "[" + string + "]" + string2);
    }

    void w(String string, String string2) {
        this.startThreadService(WARN_COLOR, "[" + string + "]" + "[WARN]" + string2);
    }

    void v(String string, String string2) {
        this.startThreadService(INFO_COLOR, "[" + string + "]" + string2);
    }

    private void startThreadService(String string, String string2) {
        File file = this.getLogRoot();
        if (file == null || !file.exists()) {
            return;
        }
        this.singleThreadService.execute(this.getWriterRunnable(string, string2));
    }

    private Runnable getWriterRunnable(final String string, final String string2) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    File file = FileLogger.this.getLogRoot();
                    if (file == null || !file.exists()) {
                        return;
                    }
                    if (FileLogger.this.timer == null && !FileLogger.this.freeSpace()) {
                        return;
                    }
                    FileLogger.this.startCleanUpTimer();
                    File file2 = FileLogger.this.getAvailableFile();
                    if (file2 == null) {
                        return;
                    }
                    boolean bl = false;
                    if (!file2.exists()) {
                        try {
                            file2.createNewFile();
                            bl = true;
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    }
                    if (!file2.exists()) {
                        return;
                    }
                    FileOutputStream fileOutputStream = null;
                    try {
                        try {
                            Object object;
                            fileOutputStream = new FileOutputStream(file2, true);
                            if (bl) {
                                object = "<header>";
                                object = String.valueOf(object) + "<meta http-equiv=" + "\"" + "Content-Type" + "\"" + " content=" + "\"" + "text/html; charset=UTF-8" + "\">";
                                object = String.valueOf(object) + "</header>";
                                fileOutputStream.write(((String)object).getBytes());
                            }
                            object = new Date();
                            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
                            String string4 = simpleDateFormat.format((Date)object);
                            String string22 = string2.replaceAll(">", "&gt;");
                            string22 = string22.replaceAll("<", "&lt;");
                            String string3 = "<p><font color =\"" + string + "\">" + string4 + " " + string22 + "</p>";
                            byte[] byArray = string3.getBytes();
                            fileOutputStream.write(byArray);
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            fileNotFoundException.printStackTrace();
                            try {
                                if (fileOutputStream != null) {
                                    fileOutputStream.close();
                                }
                            }
                            catch (IOException iOException) {
                                iOException.printStackTrace();
                            }
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                            try {
                                if (fileOutputStream != null) {
                                    fileOutputStream.close();
                                }
                            }
                            catch (IOException iOException2) {
                                iOException2.printStackTrace();
                            }
                        }
                    }
                    finally {
                        try {
                            if (fileOutputStream != null) {
                                fileOutputStream.close();
                            }
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    }
                }
                catch (NullPointerException nullPointerException) {
                    nullPointerException.printStackTrace();
                    Log.e((String)FileLogger.TAG, (String)nullPointerException.getMessage());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    Log.e((String)FileLogger.TAG, (String)exception.getMessage());
                }
                catch (Throwable throwable) {
                    Log.e((String)FileLogger.TAG, (String)"trrowable exception");
                }
            }
        };
    }

    private File getAvailableFile() {
        String string;
        File file = this.getLogRoot();
        if (file == null || !file.exists()) {
            return null;
        }
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
        String string2 = simpleDateFormat.format(date);
        this.removeOldFolders();
        File file2 = this.getLogFolder();
        int n2 = 0;
        List<File> list = null;
        File[] fileArray = file2.listFiles();
        if (fileArray != null && fileArray.length > 0) {
            list = Arrays.asList(fileArray);
            if (list.size() > 1) {
                FileLogger.getSortedFileListByName(list);
                fileArray = (File[])list.toArray();
            }
            string = fileArray[0].getName();
            string = string.substring(0, string.indexOf("."));
            try {
                n2 = Integer.parseInt(string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Log.e((String)TAG, (String)("Wrong cntName! : " + string));
            }
            if (fileArray[0].length() >= 0x100000L) {
                ++n2;
            }
        }
        string = FileLogger.getLogFileName(n2);
        return new File(file2, string);
    }

    private static String getLogFileName(int n2) {
        String string = String.valueOf(n2);
        String string2 = "000";
        String string3 = string2.substring(string.length());
        string3 = String.valueOf(string3) + string + ".html";
        return string3;
    }

    private File getLogFolder() {
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
        String string = simpleDateFormat.format(date);
        File file = this.getLogRoot();
        File file2 = new File(file, string);
        if (!file2.exists()) {
            file2.mkdirs();
        }
        return file2;
    }

    private void removeFolderBeforeDay(String string, int n2) {
        String string2 = FileLogger.getSpecifiedDayBefore(string, n2);
        File file = this.getLogRoot();
        File file2 = new File(file, string2);
        if (file2.exists()) {
            FileLogger.deleteFile(file2);
        }
    }

    private void removeOldFolders() {
        File file = this.getLogRoot();
        if (file == null || !file.exists()) {
            return;
        }
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
        String string = simpleDateFormat.format(date);
        String string2 = FileLogger.getSpecifiedDayBefore(string, 1);
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        File[] fileArray2 = fileArray;
        int n2 = fileArray.length;
        int n3 = 0;
        while (n3 < n2) {
            File file2 = fileArray2[n3];
            if (file2.isDirectory() && !file2.getName().contains(string) && !file2.getName().contains(string2)) {
                FileLogger.deleteFile(file2);
            } else {
                file2.delete();
            }
            ++n3;
        }
    }

    private static void deleteFile(File file) {
        if (file == null) {
            return;
        }
        if (file.exists()) {
            if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                if (fileArray != null) {
                    File[] fileArray2 = fileArray;
                    int n2 = fileArray.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        File file2 = fileArray2[n3];
                        FileLogger.deleteFile(file2);
                        ++n3;
                    }
                }
                file.delete();
            } else {
                file.delete();
            }
        }
    }

    private static long getDirSize(File file) {
        if (file == null) {
            return 0L;
        }
        if (file.isDirectory()) {
            long l2 = 0L;
            File[] fileArray = file.listFiles();
            if (fileArray != null) {
                File[] fileArray2 = fileArray;
                int n2 = fileArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    File file2 = fileArray2[n3];
                    l2 += FileLogger.getDirSize(file2);
                    ++n3;
                }
            }
            return l2;
        }
        return file.length();
    }

    private static String getSpecifiedDayBefore(String string, int n2) {
        Calendar calendar = Calendar.getInstance();
        Date date = null;
        try {
            date = new SimpleDateFormat("yyyyMMdd").parse(string);
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
        calendar.setTime(date);
        int n3 = calendar.get(5);
        calendar.set(5, n3 - n2);
        String string2 = new SimpleDateFormat("yyyyMMdd").format(calendar.getTime());
        return string2;
    }

    private static File getStorageDir() {
        if (Environment.getExternalStorageState().equals("mounted")) {
            return Environment.getExternalStorageDirectory();
        }
        return Environment.getDataDirectory();
    }

    private static void getSortedFileListByName(List<File> list) {
        Collections.sort(list, new Comparator<File>(){

            @Override
            public int compare(File file, File file2) {
                return file2.getName().compareTo(file.getName());
            }
        });
    }

    private boolean spaceIsAlearting() {
        long l2 = FileLogger.getCurrentAvailabeSpace();
        return l2 < 0x1400000L;
    }

    private boolean logSizeAlearting() {
        long l2 = FileLogger.getDirSize(this.getLogRoot());
        return l2 > 0x800000L;
    }

    boolean freeSpace() {
        File file = this.getLogRoot();
        if (file == null || !file.exists()) {
            return false;
        }
        if (this.spaceIsAlearting()) {
            Log.w((String)TAG, (String)"there is no availabe free space and try to free space");
            this.freeLogFolder();
            return !this.spaceIsAlearting();
        }
        this.checkAndFreeLogFiles();
        return true;
    }

    private void freeLogFolder() {
        FileLogger.deleteFile(this.getLogRoot());
    }

    private void freeOldFolders() {
        File[] fileArray;
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
        String string = simpleDateFormat.format(date);
        File[] fileArray2 = fileArray = this.getLogRoot().listFiles();
        int n2 = fileArray.length;
        int n3 = 0;
        while (n3 < n2) {
            File file = fileArray2[n3];
            if (file.isDirectory() && !file.getName().contains(string)) {
                FileLogger.deleteFile(file);
            } else {
                file.delete();
            }
            ++n3;
        }
    }

    private void freeOldFiles() {
        File[] fileArray = this.getLogFolder().listFiles();
        if (fileArray != null) {
            List<File> list = Arrays.asList(fileArray);
            FileLogger.getSortedFileListByName(list);
            if (list.size() > 5) {
                int n2 = list.size();
                int n3 = 5;
                while (n3 < n2) {
                    Log.w((String)TAG, (String)("try to delete file : " + list.get(n3).getAbsoluteFile()));
                    list.get(n3).delete();
                    ++n3;
                }
            }
        }
    }

    private static long getCurrentAvailabeSpace() {
        StatFs statFs = new StatFs(FileLogger.getStorageDir().getPath());
        if (Build.VERSION.SDK_INT >= 18) {
            return statFs.getAvailableBytes();
        }
        long l2 = statFs.getAvailableBlocks();
        long l3 = statFs.getBlockSize();
        return l2 * l3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    File getLogRoot() {
        String string = EMChatConfig.getInstance().APPKEY;
        Context context = EMChat.getInstance().getAppContext();
        String string2 = "/Android/data/";
        if (context != null) {
            string2 = String.valueOf(string2) + context.getPackageName();
        }
        if (string == null) {
            return null;
        }
        string2 = String.valueOf(string2) + "/" + string + "/log/";
        try {
            File file = new File(FileLogger.getStorageDir(), string2);
            FileLogger fileLogger = this;
            synchronized (fileLogger) {
                if (!file.exists()) {
                    file.mkdirs();
                }
            }
            return file;
        }
        catch (Exception exception) {}
        finally {
            return null;
        }
    }

    void checkAndFreeLogFiles() {
        if (this.logSizeAlearting()) {
            Log.w((String)TAG, (String)"the log size is > 8M, try to free log files");
            this.freeOldFolders();
            Log.w((String)TAG, (String)"old folders are deleted");
            if (this.logSizeAlearting()) {
                Log.w((String)TAG, (String)"try to delete old log files");
                this.freeOldFiles();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startCleanUpTimer() {
        FileLogger fileLogger = this;
        synchronized (fileLogger) {
            if (this.timer == null) {
                this.timer = new Timer();
                TimerTask timerTask = new TimerTask(){

                    @Override
                    public void run() {
                        FileLogger.this.singleThreadService.execute(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    File file = FileLogger.this.getLogRoot();
                                    if (file == null || !FileLogger.this.getLogRoot().exists()) {
                                        return;
                                    }
                                    FileLogger.this.spaceAvailable = FileLogger.this.freeSpace();
                                }
                                catch (NullPointerException nullPointerException) {
                                    nullPointerException.printStackTrace();
                                    Log.e((String)FileLogger.TAG, (String)nullPointerException.getMessage());
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                    Log.e((String)FileLogger.TAG, (String)exception.getMessage());
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                            }
                        });
                    }
                };
                this.timer.schedule(timerTask, 1200000L, 1200000L);
            }
        }
    }
}

