/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.util;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Environment;
import com.easemob.util.EMLog;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;

public class EasyUtils {
    private static Hashtable<String, String> resourceTable = new Hashtable();

    public static boolean isAppRunningForeground(Context context) {
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        List list = activityManager.getRunningTasks(1);
        return context.getPackageName().equalsIgnoreCase(((ActivityManager.RunningTaskInfo)list.get((int)0)).baseActivity.getPackageName());
    }

    public static String getTopActivityName(Context context) {
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        List list = activityManager.getRunningTasks(1);
        return ((ActivityManager.RunningTaskInfo)list.get((int)0)).topActivity.getClassName();
    }

    public static List<String> getRunningApps(Context context) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        List list = activityManager.getRunningAppProcesses();
        for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
            String string = runningAppProcessInfo.processName;
            if (string.contains(":")) {
                string = string.substring(0, string.indexOf(":"));
            }
            if (arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public static String getTimeStamp() {
        Date date = new Date(System.currentTimeMillis());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        return simpleDateFormat.format(date);
    }

    public static boolean writeToZipFile(byte[] byArray, String string) {
        FileOutputStream fileOutputStream = null;
        DeflaterOutputStream deflaterOutputStream = null;
        try {
            try {
                fileOutputStream = new FileOutputStream(string);
                deflaterOutputStream = new GZIPOutputStream(new BufferedOutputStream(fileOutputStream));
                deflaterOutputStream.write(byArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (deflaterOutputStream != null) {
                    try {
                        deflaterOutputStream.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                if (fileOutputStream != null) {
                    try {
                        ((OutputStream)fileOutputStream).close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                return false;
            }
        }
        finally {
            if (deflaterOutputStream != null) {
                try {
                    deflaterOutputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            if (fileOutputStream != null) {
                try {
                    ((OutputStream)fileOutputStream).close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        if (EMLog.debugMode) {
            File file = new File(string);
            DecimalFormat decimalFormat = new DecimalFormat("#.##");
            double d2 = (double)file.length() / (double)byArray.length * 100.0;
            double d3 = Double.valueOf(decimalFormat.format(d2));
            EMLog.d("zip", "data size:" + byArray.length + " zip file size:" + file.length() + "zip file ratio%: " + d3);
        }
        return true;
    }

    public static String getAppResourceString(Context context, String string) {
        String string2 = resourceTable.get(string);
        if (string2 != null) {
            return string2;
        }
        int n2 = context.getResources().getIdentifier(string, "string", context.getPackageName());
        string2 = context.getString(n2);
        if (string2 != null) {
            resourceTable.put(string, string2);
        }
        return string2;
    }

    public static String convertByteArrayToString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        byte[] byArray2 = byArray;
        int n2 = byArray.length;
        int n3 = 0;
        while (n3 < n2) {
            byte by = byArray2[n3];
            stringBuffer.append(String.format("0x%02X", by));
            ++n3;
        }
        return stringBuffer.toString();
    }

    public static boolean isSdcardExist() {
        return Environment.getExternalStorageState().equals("mounted");
    }
}

