/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.util;

import com.easemob.util.TimeInfo;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;

public class DateUtils {
    private static final long INTERVAL_IN_MILLISECONDS = 30000L;

    public static String getTimestampString(Date date) {
        String string = null;
        long l2 = date.getTime();
        if (DateUtils.isSameDay(l2)) {
            Calendar calendar = GregorianCalendar.getInstance();
            calendar.setTime(date);
            int n2 = calendar.get(11);
            string = n2 > 17 ? "\u665a\u4e0a hh:mm" : (n2 >= 0 && n2 <= 6 ? "\u51cc\u6668 hh:mm" : (n2 > 11 && n2 <= 17 ? "\u4e0b\u5348 hh:mm" : "\u4e0a\u5348 hh:mm"));
        } else {
            string = DateUtils.isYesterday(l2) ? "\u6628\u5929 HH:mm" : "M\u6708d\u65e5 HH:mm";
        }
        return new SimpleDateFormat(string, Locale.CHINA).format(date);
    }

    public static boolean isCloseEnough(long l2, long l3) {
        long l4 = l2 - l3;
        if (l4 < 0L) {
            l4 = -l4;
        }
        return l4 < 30000L;
    }

    private static boolean isSameDay(long l2) {
        TimeInfo timeInfo = DateUtils.getTodayStartAndEndTime();
        return l2 > timeInfo.getStartTime() && l2 < timeInfo.getEndTime();
    }

    private static boolean isYesterday(long l2) {
        TimeInfo timeInfo = DateUtils.getYesterdayStartAndEndTime();
        return l2 > timeInfo.getStartTime() && l2 < timeInfo.getEndTime();
    }

    public static Date StringToDate(String string, String string2) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2);
        Date date = null;
        try {
            date = simpleDateFormat.parse(string);
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
        return date;
    }

    public static String toTime(int n2) {
        int n3 = (n2 /= 1000) / 60;
        int n4 = 0;
        if (n3 >= 60) {
            n4 = n3 / 60;
            n3 %= 60;
        }
        int n5 = n2 % 60;
        return String.format("%02d:%02d", n3, n5);
    }

    public static String toTimeBySecond(int n2) {
        int n3 = n2 / 60;
        int n4 = 0;
        if (n3 >= 60) {
            n4 = n3 / 60;
            n3 %= 60;
        }
        int n5 = n2 % 60;
        return String.format("%02d:%02d", n3, n5);
    }

    public static TimeInfo getYesterdayStartAndEndTime() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date date = calendar.getTime();
        long l2 = date.getTime();
        Calendar calendar2 = Calendar.getInstance();
        calendar2.add(5, -1);
        calendar2.set(11, 23);
        calendar2.set(12, 59);
        calendar2.set(13, 59);
        calendar2.set(14, 999);
        Date date2 = calendar2.getTime();
        long l3 = date2.getTime();
        TimeInfo timeInfo = new TimeInfo();
        timeInfo.setStartTime(l2);
        timeInfo.setEndTime(l3);
        return timeInfo;
    }

    public static TimeInfo getTodayStartAndEndTime() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date date = calendar.getTime();
        long l2 = date.getTime();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss S");
        Calendar calendar2 = Calendar.getInstance();
        calendar2.set(11, 23);
        calendar2.set(12, 59);
        calendar2.set(13, 59);
        calendar2.set(14, 999);
        Date date2 = calendar2.getTime();
        long l3 = date2.getTime();
        TimeInfo timeInfo = new TimeInfo();
        timeInfo.setStartTime(l2);
        timeInfo.setEndTime(l3);
        return timeInfo;
    }

    public static TimeInfo getBeforeYesterdayStartAndEndTime() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -2);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date date = calendar.getTime();
        long l2 = date.getTime();
        Calendar calendar2 = Calendar.getInstance();
        calendar2.add(5, -2);
        calendar2.set(11, 23);
        calendar2.set(12, 59);
        calendar2.set(13, 59);
        calendar2.set(14, 999);
        Date date2 = calendar2.getTime();
        long l3 = date2.getTime();
        TimeInfo timeInfo = new TimeInfo();
        timeInfo.setStartTime(l2);
        timeInfo.setEndTime(l3);
        return timeInfo;
    }

    public static TimeInfo getCurrentMonthStartAndEndTime() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date date = calendar.getTime();
        long l2 = date.getTime();
        Calendar calendar2 = Calendar.getInstance();
        Date date2 = calendar2.getTime();
        long l3 = date2.getTime();
        TimeInfo timeInfo = new TimeInfo();
        timeInfo.setStartTime(l2);
        timeInfo.setEndTime(l3);
        return timeInfo;
    }

    public static TimeInfo getLastMonthStartAndEndTime() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -1);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date date = calendar.getTime();
        long l2 = date.getTime();
        Calendar calendar2 = Calendar.getInstance();
        calendar2.add(2, -1);
        calendar2.set(5, 1);
        calendar2.set(11, 23);
        calendar2.set(12, 59);
        calendar2.set(13, 59);
        calendar2.set(14, 999);
        calendar2.roll(5, -1);
        Date date2 = calendar2.getTime();
        long l3 = date2.getTime();
        TimeInfo timeInfo = new TimeInfo();
        timeInfo.setStartTime(l2);
        timeInfo.setEndTime(l3);
        return timeInfo;
    }

    public static String getTimestampStr() {
        return Long.toString(System.currentTimeMillis());
    }
}

