/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.media;

import android.content.Context;
import android.media.AudioManager;
import android.media.AudioTrack;
import android.os.Build;
import android.os.Process;
import android.util.Log;
import java.nio.ByteBuffer;
import java.util.concurrent.locks.ReentrantLock;

class WebRtcAudioTrack {
    private AudioTrack _audioTrack = null;
    private Context _context;
    private AudioManager _audioManager;
    private ByteBuffer _playBuffer;
    private byte[] _tempBufPlay;
    private final ReentrantLock _playLock = new ReentrantLock();
    private boolean _doPlayInit = true;
    private boolean _doRecInit = true;
    private boolean _isRecording = false;
    private boolean _isPlaying = false;
    private int _bufferedPlaySamples = 0;
    private int _playPosition = 0;
    final String logTag = "WebRTC AD java";

    WebRtcAudioTrack() {
        try {
            this._playBuffer = ByteBuffer.allocateDirect(960);
        }
        catch (Exception exception) {
            this.DoLog(exception.getMessage());
        }
        this._tempBufPlay = new byte[960];
    }

    private int InitPlayback(int n2) {
        int n3 = AudioTrack.getMinBufferSize((int)n2, (int)4, (int)2);
        int n4 = n3;
        if (n4 < 6000) {
            n4 *= 2;
        }
        this._bufferedPlaySamples = 0;
        if (this._audioTrack != null) {
            this._audioTrack.release();
            this._audioTrack = null;
        }
        try {
            this._audioTrack = new AudioTrack(0, n2, 4, 2, n4, 1);
        }
        catch (Exception exception) {
            this.DoLog(exception.getMessage());
            return -1;
        }
        if (this._audioTrack.getState() != 1) {
            return -1;
        }
        if (this._audioManager == null && this._context != null) {
            this._audioManager = (AudioManager)this._context.getSystemService("audio");
        }
        if (this._audioManager == null) {
            return 0;
        }
        return this._audioManager.getStreamMaxVolume(0);
    }

    private int StartPlayback() {
        try {
            this._audioTrack.play();
        }
        catch (IllegalStateException illegalStateException) {
            illegalStateException.printStackTrace();
            return -1;
        }
        this._isPlaying = true;
        return 0;
    }

    private int StopPlayback() {
        this._playLock.lock();
        try {
            if (this._audioTrack.getPlayState() == 3) {
                try {
                    this._audioTrack.stop();
                }
                catch (IllegalStateException illegalStateException) {
                    illegalStateException.printStackTrace();
                    this._doPlayInit = true;
                    this._playLock.unlock();
                    return -1;
                }
                this._audioTrack.flush();
            }
            this._audioTrack.release();
            this._audioTrack = null;
        }
        finally {
            this._doPlayInit = true;
            this._playLock.unlock();
        }
        this._isPlaying = false;
        return 0;
    }

    private int PlayAudio(int n2) {
        this._playLock.lock();
        try {
            if (this._audioTrack == null) {
                return -2;
            }
            if (this._doPlayInit) {
                try {
                    Process.setThreadPriority((int)-19);
                }
                catch (Exception exception) {
                    this.DoLog("Set play thread priority failed: " + exception.getMessage());
                }
                this._doPlayInit = false;
            }
            int n3 = 0;
            this._playBuffer.get(this._tempBufPlay);
            n3 = this._audioTrack.write(this._tempBufPlay, 0, n2);
            this._playBuffer.rewind();
            this._bufferedPlaySamples += n3 >> 1;
            int n4 = this._audioTrack.getPlaybackHeadPosition();
            if (n4 < this._playPosition) {
                this._playPosition = 0;
            }
            this._bufferedPlaySamples -= n4 - this._playPosition;
            this._playPosition = n4;
            if (n3 != n2) {
                return -1;
            }
        }
        finally {
            this._playLock.unlock();
        }
        return this._bufferedPlaySamples;
    }

    private int SetPlayoutSpeaker(boolean bl) {
        if (this._audioManager == null && this._context != null) {
            this._audioManager = (AudioManager)this._context.getSystemService("audio");
        }
        if (this._audioManager == null) {
            this.DoLogErr("Could not change audio routing - no audio manager");
            return -1;
        }
        int n2 = Build.VERSION.SDK_INT;
        if (3 == n2 || 4 == n2) {
            if (bl) {
                this._audioManager.setMode(0);
            } else {
                this._audioManager.setMode(2);
            }
        } else if ((Build.BRAND.equals("Samsung") || Build.BRAND.equals("samsung")) && (5 == n2 || 6 == n2 || 7 == n2)) {
            if (bl) {
                this._audioManager.setMode(2);
                this._audioManager.setSpeakerphoneOn(bl);
            } else {
                this._audioManager.setSpeakerphoneOn(bl);
                this._audioManager.setMode(0);
            }
        } else {
            this._audioManager.setSpeakerphoneOn(bl);
        }
        return 0;
    }

    private int SetPlayoutVolume(int n2) {
        if (this._audioManager == null && this._context != null) {
            this._audioManager = (AudioManager)this._context.getSystemService("audio");
        }
        int n3 = -1;
        if (this._audioManager != null) {
            this._audioManager.setStreamVolume(0, n2, 0);
            n3 = 0;
        }
        return n3;
    }

    private int GetPlayoutVolume() {
        if (this._audioManager == null && this._context != null) {
            this._audioManager = (AudioManager)this._context.getSystemService("audio");
        }
        int n2 = -1;
        if (this._audioManager != null) {
            n2 = this._audioManager.getStreamVolume(0);
        }
        return n2;
    }

    private void DoLog(String string) {
        Log.d((String)"WebRTC AD java", (String)string);
    }

    private void DoLogErr(String string) {
        Log.e((String)"WebRTC AD java", (String)string);
    }
}

