/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.media;

import android.content.Context;
import android.media.AudioRecord;
import android.os.Process;
import android.util.Log;
import java.nio.ByteBuffer;
import java.util.concurrent.locks.ReentrantLock;

class WebRtcAudioRecord {
    private AudioRecord _audioRecord = null;
    private Context _context;
    private ByteBuffer _recBuffer;
    private byte[] _tempBufRec;
    private final ReentrantLock _recLock = new ReentrantLock();
    private boolean _doRecInit = true;
    private boolean _isRecording = false;
    private int _bufferedRecSamples = 0;
    final String logTag = "WebRTC AD java";

    WebRtcAudioRecord() {
        try {
            this._recBuffer = ByteBuffer.allocateDirect(960);
        }
        catch (Exception exception) {
            this.DoLog(exception.getMessage());
        }
        this._tempBufRec = new byte[960];
    }

    private int InitRecording(int n2, int n3) {
        n2 = 7;
        int n4 = AudioRecord.getMinBufferSize((int)n3, (int)16, (int)2);
        int n5 = n4 * 2;
        this._bufferedRecSamples = n3 / 200;
        if (this._audioRecord != null) {
            this._audioRecord.release();
            this._audioRecord = null;
        }
        try {
            this._audioRecord = new AudioRecord(n2, n3, 16, 2, n5);
        }
        catch (Exception exception) {
            this.DoLog(exception.getMessage());
            return -1;
        }
        if (this._audioRecord.getState() != 1) {
            return -1;
        }
        return this._bufferedRecSamples;
    }

    private int StartRecording() {
        try {
            this._audioRecord.startRecording();
        }
        catch (IllegalStateException illegalStateException) {
            illegalStateException.printStackTrace();
            return -1;
        }
        this._isRecording = true;
        return 0;
    }

    private int StopRecording() {
        this._recLock.lock();
        try {
            if (this._audioRecord.getRecordingState() == 3) {
                try {
                    this._audioRecord.stop();
                }
                catch (IllegalStateException illegalStateException) {
                    illegalStateException.printStackTrace();
                    this._doRecInit = true;
                    this._recLock.unlock();
                    return -1;
                }
            }
            this._audioRecord.release();
            this._audioRecord = null;
        }
        finally {
            this._doRecInit = true;
            this._recLock.unlock();
        }
        this._isRecording = false;
        return 0;
    }

    private int RecordAudio(int n2) {
        this._recLock.lock();
        try {
            if (this._audioRecord == null) {
                return -2;
            }
            if (this._doRecInit) {
                try {
                    Process.setThreadPriority((int)-19);
                }
                catch (Exception exception) {
                    this.DoLog("Set rec thread priority failed: " + exception.getMessage());
                }
                this._doRecInit = false;
            }
            int n3 = 0;
            this._recBuffer.rewind();
            n3 = this._audioRecord.read(this._tempBufRec, 0, n2);
            this._recBuffer.put(this._tempBufRec);
            if (n3 != n2) {
                return -1;
            }
        }
        catch (Exception exception) {
            this.DoLogErr("RecordAudio try failed: " + exception.getMessage());
        }
        finally {
            this._recLock.unlock();
        }
        return this._bufferedRecSamples;
    }

    private void DoLog(String string) {
        Log.d((String)"WebRTC AD java", (String)string);
    }

    private void DoLogErr(String string) {
        Log.e((String)"WebRTC AD java", (String)string);
    }
}

