/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.media;

import android.util.Log;

public class EIce {
    protected static final String TAG = "EIce_Java";
    protected long nativeHandle = 0L;
    protected String localContent = null;
    protected String negoResult = null;
    protected Thread queryThread = null;
    protected boolean stopReq = false;
    private static LogListener sLogListener;

    static {
        System.loadLibrary("easemob_jni");
        EIce.nativeInitEIce();
        sLogListener = null;
    }

    protected static native void nativeInitEIce();

    protected native long nativeNewCaller(String var1);

    protected native long nativeNewCallee(String var1, String var2);

    protected native String nativeGetLocalContent(long var1);

    protected native void nativeCallerNego(long var1, String var3);

    protected native void nativeFreeCall(long var1);

    protected native String nativeGetNegoResult(long var1);

    private EIce() {
    }

    public static EIce newCaller(String string) {
        EIce eIce = new EIce();
        eIce.nativeHandle = eIce.nativeNewCaller(string);
        eIce.localContent = eIce.nativeGetLocalContent(eIce.nativeHandle);
        return eIce;
    }

    public static EIce newCallee(String string, String string2) {
        EIce eIce = new EIce();
        eIce.nativeHandle = eIce.nativeNewCallee(string, string2);
        eIce.localContent = eIce.nativeGetLocalContent(eIce.nativeHandle);
        return eIce;
    }

    public String getLocalContent() {
        return this.localContent;
    }

    protected void startQueryResult(final EIceListener eIceListener) {
        this.queryThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block8: {
                    do {
                        String string;
                        if ((string = EIce.this.nativeGetNegoResult(EIce.this.nativeHandle)) != null) {
                            EIce eIce = EIce.this;
                            synchronized (eIce) {
                                EIce.this.negoResult = string;
                                EIce.this.notifyAll();
                            }
                            Log.i((String)EIce.TAG, (String)("got nego result: " + string));
                            if (eIceListener != null) {
                                eIceListener.onNegoResult(string);
                            }
                            break block8;
                        }
                        try {
                            Thread.sleep(200L);
                        }
                        catch (InterruptedException interruptedException) {
                            Log.i((String)EIce.TAG, (String)("queryThread got InterruptedException " + interruptedException.getLocalizedMessage()));
                            break block8;
                        }
                    } while (!EIce.this.stopReq);
                    Log.i((String)EIce.TAG, (String)"queryThread got stop req");
                }
                Log.i((String)EIce.TAG, (String)"queryThread exit");
            }
        });
        this.stopReq = false;
        this.queryThread.start();
    }

    public void callerNego(String string, EIceListener eIceListener) {
        this.nativeCallerNego(this.nativeHandle, string);
        this.startQueryResult(eIceListener);
    }

    public void calleeNego(EIceListener eIceListener) {
        this.startQueryResult(eIceListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String waitforNegoResult() {
        String string = null;
        while (true) {
            EIce eIce = this;
            synchronized (eIce) {
                block7: {
                    if (this.getNegoResult() == null) {
                        try {
                            this.wait();
                            break block7;
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                            break;
                        }
                    }
                    string = this.getNegoResult();
                    break;
                }
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNegoResult() {
        EIce eIce = this;
        synchronized (eIce) {
            return this.negoResult;
        }
    }

    public void freeCall() {
        this.nativeFreeCall(this.nativeHandle);
        this.nativeHandle = 0L;
        if (this.queryThread != null) {
            this.stopReq = true;
            try {
                this.queryThread.join();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            this.queryThread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerLogListener(LogListener logListener) {
        Class<EIce> clazz = EIce.class;
        synchronized (EIce.class) {
            sLogListener = logListener;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void callbackLog(int n2, String string) {
        Class<EIce> clazz = EIce.class;
        synchronized (EIce.class) {
            sLogListener.onLog(n2, string);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static interface EIceListener {
        public void onNegoResult(String var1);
    }

    public static interface LogListener {
        public void onLog(int var1, String var2);
    }
}

