/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.exceptions;

import com.easemob.exceptions.EMAuthenticationException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import org.jivesoftware.smack.XMPPException;

public class EMExceptionUtils {
    public static int fromExceptionToErrorCode(Exception exception) {
        int n2 = -999;
        if (exception instanceof UnknownHostException) {
            n2 = -1002;
        } else if (exception instanceof NoRouteToHostException) {
            n2 = -1003;
        } else if (exception instanceof ConnectException) {
            n2 = -1003;
        } else if (exception instanceof SocketException) {
            n2 = -1003;
        } else if (exception instanceof SocketTimeoutException) {
            n2 = -1004;
        } else if (exception instanceof EMAuthenticationException) {
            n2 = -1005;
        } else if (exception instanceof KeyStoreException) {
            n2 = -1006;
        } else if (exception instanceof IOException) {
            n2 = -1007;
        } else if (exception instanceof CertificateException) {
            n2 = -1008;
        } else if (exception instanceof NoSuchAlgorithmException) {
            n2 = -1009;
        } else if (exception instanceof UnrecoverableKeyException) {
            n2 = -1009;
        } else if (exception instanceof KeyManagementException) {
            n2 = -1009;
        } else if (exception.getMessage().contains("User removed")) {
            n2 = -1023;
        } else if (exception.getMessage().contains("conflict")) {
            n2 = -1014;
        } else if (exception instanceof XMPPException) {
            if (exception.getMessage().contains("Not connected to server")) {
                n2 = -1003;
            }
        } else if (exception instanceof XMPPException && exception.getMessage().contains("No response")) {
            n2 = -1003;
        }
        return n2;
    }
}

