/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.debug;

import android.content.Context;
import android.os.Build;
import android.util.Log;
import android.util.Pair;
import com.easemob.EMCallBack;
import com.easemob.chat.EMChatConfig;
import com.easemob.chat.EMChatManager;
import com.easemob.chat.EMCloudOperationCallback;
import com.easemob.cloud.EMHttpClient;
import com.easemob.exceptions.EaseMobException;
import com.easemob.util.EMLog;
import com.easemob.util.ZipUtils;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class DebugHelper {
    static final String UUID = "uuid";
    static final String TOKEN_ENTITY = "entities";
    private static final String TAG = "DebugHelper";

    public static void uploadLog(Context context, final String string, final EMCallBack eMCallBack) {
        new Thread(){

            @Override
            public void run() {
                try {
                    File file = EMLog.getLogRoot();
                    if (file == null || !file.exists()) {
                        EMLog.w(DebugHelper.TAG, "log root did not exist");
                        eMCallBack.onSuccess();
                        return;
                    }
                    EMLog.freeLogFiles();
                    File file2 = file.getParentFile();
                    File file3 = new File(file2, "easemoblog.zip");
                    if (file3.exists()) {
                        file3.delete();
                        EMLog.d("EMChat", "zipFile was deleted!");
                    }
                    ZipUtils.zip(file, file3);
                    String string2 = "http://" + string + "/" + "easemob#logger".replaceFirst("#", "/") + "/chatfiles/";
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    EMHttpClient.getInstance().uploadFile(file3.getAbsolutePath(), string2, hashMap, new EMCloudOperationCallback(){

                        @Override
                        public void onSuccess(String string6) {
                            Log.i((String)DebugHelper.TAG, (String)string6);
                            try {
                                JSONObject jSONObject = new JSONObject(string6);
                                JSONObject jSONObject2 = jSONObject.getJSONArray(DebugHelper.TOKEN_ENTITY).getJSONObject(0);
                                String string2 = jSONObject2.getString(DebugHelper.UUID);
                                if (string2 == null) {
                                    eMCallBack.onError(5, "authentificate failed");
                                    return;
                                }
                                Date date = new Date();
                                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                                String string3 = simpleDateFormat.format(date);
                                JSONObject jSONObject3 = new JSONObject();
                                jSONObject3.put("sdk_version", (Object)Build.VERSION.RELEASE);
                                jSONObject3.put("os_version", (Object)Build.VERSION.RELEASE);
                                jSONObject3.put("model", (Object)(String.valueOf(Build.MODEL) + ":" + Build.DEVICE + ":" + Build.PRODUCT));
                                jSONObject3.put("uploadDate", (Object)string3);
                                jSONObject3.put("login_username", (Object)EMChatManager.getInstance().getCurrentUser());
                                jSONObject3.put("appkey", (Object)EMChatConfig.getInstance().APPKEY);
                                jSONObject3.put("logfile_uuid", (Object)string2);
                                EMLog.i(DebugHelper.TAG, "post body :" + jSONObject3.toString());
                                String string4 = "http://" + string + "/" + "easemob#logger".replaceFirst("#", "/") + "/devicelogs/";
                                EMLog.i(DebugHelper.TAG, "start post uri : " + string4);
                                Pair<Integer, String> pair = EMHttpClient.getInstance().sendRequest(string4, null, jSONObject3.toString(), EMHttpClient.POST);
                                String string5 = (String)pair.second;
                                if (string5 != null) {
                                    EMLog.i(DebugHelper.TAG, string5);
                                    eMCallBack.onSuccess();
                                } else {
                                    eMCallBack.onError(5, "send post by uuid failed");
                                    EMLog.e(DebugHelper.TAG, "send post by uuid failed");
                                }
                            }
                            catch (JSONException jSONException) {
                                jSONException.printStackTrace();
                                eMCallBack.onError(5, jSONException.getMessage());
                            }
                            catch (EaseMobException easeMobException) {
                                easeMobException.printStackTrace();
                                eMCallBack.onError(5, easeMobException.getMessage());
                            }
                            catch (IOException iOException) {
                                iOException.printStackTrace();
                                eMCallBack.onError(5, iOException.getMessage());
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                                eMCallBack.onError(-998, exception.getMessage());
                            }
                        }

                        @Override
                        public void onError(String string2) {
                            eMCallBack.onError(5, string2);
                        }

                        @Override
                        public void onProgress(int n2) {
                            eMCallBack.onProgress(n2, null);
                        }
                    });
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    eMCallBack.onError(5, iOException.getMessage());
                }
            }
        }.start();
    }
}

