/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.cloud;

import android.text.TextUtils;
import android.util.Pair;
import com.easemob.chat.EMChat;
import com.easemob.chat.core.j;
import com.easemob.chat.core.p;
import com.easemob.cloud.HttpClientConfig;
import com.easemob.exceptions.EMNetworkUnconnectedException;
import com.easemob.exceptions.EaseMobException;
import com.easemob.util.EMLog;
import com.easemob.util.NetUtils;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;

public class HttpClientManager {
    private static final String TAG = "HttpClientManager";
    public static String Method_GET = "GET";
    public static String Method_POST = "POST";
    public static String Method_PUT = "PUT";
    public static String Method_DELETE = "DELETE";
    public static final int max_retries_times_on_connection_refused = 20;
    private static volatile long retrivedTokenTime = 0L;
    private static final int retriveInterval = 120000;
    private static volatile boolean isRetring = false;

    public static String sendHttpRequest(String string, Map<String, String> map, String string2, String string3) throws EaseMobException, IOException {
        String string4 = null;
        IOException iOException = null;
        EaseMobException easeMobException = null;
        String string5 = string;
        Object var8_8 = null;
        int n2 = 0;
        while (n2 < 20) {
            EMLog.d(TAG, "try send request, request url: " + string + " with number: " + n2);
            iOException = null;
            easeMobException = null;
            Exception exception = null;
            try {
                string4 = HttpClientManager.sendHttpRequestWithCountDown(string5, map, string2, string3);
            }
            catch (IOException iOException2) {
                iOException = iOException2;
                exception = iOException2;
            }
            catch (EaseMobException easeMobException2) {
                easeMobException = easeMobException2;
                exception = easeMobException2;
            }
            String string6 = "";
            if (exception != null && exception.getMessage() != null) {
                string6 = exception.getMessage();
            }
            if (!p.c().f() || !j.a().h() || !string6.toLowerCase().contains("refused") || !NetUtils.hasNetwork(EMChat.getInstance().getAppContext())) break;
            j.c c2 = j.a().g();
            if (var8_8 != null && !TextUtils.isEmpty((CharSequence)var8_8.a) && var8_8.a.equals(c2.a)) break;
            string5 = HttpClientManager.getNewHost(string, c2);
            ++n2;
        }
        if (iOException != null) {
            throw iOException;
        }
        if (easeMobException != null) {
            throw easeMobException;
        }
        return string4;
    }

    public static Pair<Integer, String> sendRequestWithToken(String string, Map<String, String> map, String string2, String string3) throws EaseMobException {
        if (map == null) {
            map = new HashMap<String, String>();
        }
        map.put("Authorization", "Bearer " + p.c().x());
        try {
            return HttpClientManager.sendHttpRequestWithRetryToken(string, map, string2, string3);
        }
        catch (IOException iOException) {
            String string4 = " send request : " + string + " failed!";
            if (iOException != null && iOException.toString() != null) {
                string4 = iOException.toString();
            }
            EMLog.d(TAG, string4);
            throw new EaseMobException(-998, string4);
        }
    }

    static Pair<Integer, String> sendHttpRequestWithRetryToken(String string, Map<String, String> map, String string2, String string3) throws EaseMobException, IOException {
        Pair<Integer, String> pair = HttpClientManager.sendRequest(string, map, string2, string3);
        if (pair != null && (Integer)pair.first == 401) {
            String string4 = null;
            long l2 = System.currentTimeMillis();
            if (l2 - retrivedTokenTime > 120000L && !isRetring) {
                isRetring = true;
                string4 = p.c().y();
                isRetring = false;
                retrivedTokenTime = System.currentTimeMillis();
                if (string4 != null) {
                    map.put("Authorization", "Bearer " + string4);
                    pair = HttpClientManager.sendRequest(string, map, string2, string3);
                }
            }
        }
        return pair;
    }

    public static Pair<Integer, String> sendRequest(String string, Map<String, String> map, String string2, String string3) throws IOException, EaseMobException {
        Pair pair = null;
        IOException iOException = null;
        EaseMobException easeMobException = null;
        String string4 = string;
        int n2 = 0;
        while (n2 < 20) {
            Object object;
            Object object2;
            EMLog.d(TAG, "try send request, request url: " + string + " with number: " + n2);
            iOException = null;
            easeMobException = null;
            Exception exception = null;
            try {
                object2 = HttpClientManager.sendRequestWithCountDown(string4, map, string2, string3);
                object = object2.getEntity();
                if (object != null) {
                    String string5 = EntityUtils.toString((HttpEntity)object, (String)"UTF-8");
                    pair = new Pair((Object)object2.getStatusLine().getStatusCode(), (Object)string5);
                }
            }
            catch (IOException iOException2) {
                iOException = iOException2;
                exception = iOException2;
            }
            catch (EaseMobException easeMobException2) {
                easeMobException = easeMobException2;
                exception = easeMobException2;
            }
            object2 = "failed to send request, request url: " + string;
            if (exception != null) {
                if (exception.getMessage() != null) {
                    object2 = exception.getMessage();
                } else if (exception.toString() != null) {
                    object2 = exception.toString();
                }
            }
            if (!p.c().f() || !((String)object2).toLowerCase().contains("refused") || !NetUtils.hasNetwork(EMChat.getInstance().getAppContext())) break;
            object = j.a().g();
            string4 = HttpClientManager.getNewHost(string, (j.c)object);
            ++n2;
        }
        if (iOException != null) {
            throw iOException;
        }
        if (easeMobException != null) {
            throw easeMobException;
        }
        return pair;
    }

    private static HttpResponse sendRequestWithCountDown(String string, Map<String, String> map, String string2, String string3) throws EaseMobException, IOException {
        HttpResponse httpResponse = null;
        try {
            httpResponse = HttpClientManager.getHttpResponse(string, map, string2, string3);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            if (exception != null) {
                exception.printStackTrace();
            }
            String string4 = "http request failed : " + string;
            if (exception != null && exception.toString() != null) {
                string4 = exception.toString();
            }
            if (string4.contains("Unable to resolve host")) {
                throw new EMNetworkUnconnectedException(-1001, "EMNetworkUnconnectedException:Unable to resolve host");
            }
            throw new EaseMobException(-1003, string4);
        }
        return httpResponse;
    }

    private static String sendHttpRequestWithCountDown(String string, Map<String, String> map, String string2, String string3) throws EaseMobException, IOException {
        String string4 = null;
        try {
            HttpResponse httpResponse = HttpClientManager.getHttpResponse(string, map, string2, string3);
            HttpEntity httpEntity = httpResponse.getEntity();
            if (httpEntity != null) {
                string4 = EntityUtils.toString((HttpEntity)httpEntity, (String)"UTF-8");
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            if (exception != null) {
                exception.printStackTrace();
            }
            String string5 = "http request failed : " + string;
            if (exception != null && exception.toString() != null) {
                string5 = exception.toString();
            }
            if (string5.contains("Unable to resolve host")) {
                throw new EMNetworkUnconnectedException(-1001, "EMNetworkUnconnectedException:Unable to resolve host");
            }
            throw new EaseMobException(-1003, string5);
        }
        return string4;
    }

    static String getNewHost(String string, j.c c2) {
        String string2 = c2.a;
        int n2 = c2.b;
        String string3 = c2.c;
        String string4 = String.valueOf(string3) + "://" + string2 + ":" + n2;
        String string5 = string.substring(string.indexOf("/", 8));
        String string6 = String.valueOf(string4) + string5;
        return string6;
    }

    static Map<String, String> addDomainToHeaders(Map<String, String> map) {
        j.c c2;
        if (p.c().f() && (c2 = j.a().c()) != null && c2.d != null && c2.c != null && c2.c.contains("https") && c2.d.a != null && !c2.d.a.trim().equals("")) {
            if (map == null) {
                map = new HashMap<String, String>();
            }
            map.put("Host", c2.d.a);
        }
        return map;
    }

    static void checkAndProcessSSL(String string, DefaultHttpClient defaultHttpClient) throws NoSuchAlgorithmException, CertificateException, IOException, KeyStoreException, KeyManagementException, UnrecoverableKeyException {
    }

    public static HttpResponse getHttpResponse(String string, Map<String, String> map, String string2, String string3) throws KeyStoreException, KeyManagementException, UnrecoverableKeyException, NoSuchAlgorithmException, CertificateException, IOException {
        map = HttpClientManager.addDomainToHeaders(map);
        return HttpClientManager.httpExecute(string, map, string2, string3);
    }

    public static HttpResponse httpExecute(String string, Map<String, String> map, String string2, String string3) throws ClientProtocolException, IOException, KeyStoreException, KeyManagementException, UnrecoverableKeyException, NoSuchAlgorithmException, CertificateException {
        HttpResponse httpResponse = null;
        int n2 = HttpClientConfig.getTimeout(map);
        DefaultHttpClient defaultHttpClient = HttpClientConfig.getDefaultHttpClient(n2);
        HttpGet httpGet = null;
        if (string3.equals(Method_POST)) {
            HttpPost object2 = new HttpPost(string);
            object2.setEntity((HttpEntity)new StringEntity(string2, "UTF-8"));
            httpGet = object2;
        } else if (string3.equals(Method_PUT)) {
            HttpPut httpPut = new HttpPut(string);
            httpPut.setEntity((HttpEntity)new StringEntity(string2, "UTF-8"));
            httpGet = httpPut;
        } else if (string3.equals(Method_GET)) {
            httpGet = new HttpGet(string);
        } else if (string3.equals(Method_DELETE)) {
            httpGet = new HttpDelete(string);
        }
        if (httpGet != null) {
            if (map != null) {
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    httpGet.setHeader(entry.getKey(), entry.getValue());
                }
            }
            httpResponse = defaultHttpClient.execute((HttpUriRequest)httpGet);
        }
        return httpResponse;
    }
}

