/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.cloud;

import android.text.TextUtils;
import com.easemob.chat.EMChat;
import com.easemob.chat.EMChatConfig;
import com.easemob.chat.core.j;
import java.util.Map;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;

public class HttpClientConfig {
    private static final String EASEMOB_USERSERVER_DOMAIN_ID = "easemob.com";
    private static final String EASEMOB_PLATFORM = "Android";
    public static String EM_TIME_OUT_KEY = "em_timeout";
    public static int EM_DEFAULT_TIMEOUT = 30000;

    public static String getEaseMobUserServerDomainId() {
        return EASEMOB_USERSERVER_DOMAIN_ID;
    }

    private static String getDefaultUserAgent() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Easemob-SDK(");
        stringBuffer.append(EASEMOB_PLATFORM);
        stringBuffer.append(") ");
        stringBuffer.append(EMChat.getInstance().getVersion());
        return stringBuffer.toString();
    }

    public static DefaultHttpClient getDefaultHttpClient() {
        return HttpClientConfig.getDefaultHttpClient(EM_DEFAULT_TIMEOUT);
    }

    public static DefaultHttpClient getDefaultHttpClient(int n2) {
        BasicHttpParams basicHttpParams = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)basicHttpParams, (int)n2);
        HttpConnectionParams.setSoTimeout((HttpParams)basicHttpParams, (int)20000);
        HttpConnectionParams.setTcpNoDelay((HttpParams)basicHttpParams, (boolean)true);
        HttpProtocolParams.setUserAgent((HttpParams)basicHttpParams, (String)HttpClientConfig.getDefaultUserAgent());
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        PlainSocketFactory plainSocketFactory = PlainSocketFactory.getSocketFactory();
        schemeRegistry.register(new Scheme("http", (SocketFactory)plainSocketFactory, 80));
        schemeRegistry.register(new Scheme("https", (SocketFactory)SSLSocketFactory.getSocketFactory(), 443));
        ThreadSafeClientConnManager threadSafeClientConnManager = new ThreadSafeClientConnManager((HttpParams)basicHttpParams, schemeRegistry);
        DefaultHttpClient defaultHttpClient = new DefaultHttpClient((ClientConnectionManager)threadSafeClientConnManager, (HttpParams)basicHttpParams);
        defaultHttpClient.setKeepAliveStrategy((ConnectionKeepAliveStrategy)new DefaultConnectionKeepAliveStrategy());
        defaultHttpClient.setReuseStrategy((ConnectionReuseStrategy)new DefaultConnectionReuseStrategy());
        return defaultHttpClient;
    }

    public static String getFileRemoteUrl(String string) {
        if (string.startsWith("http")) {
            return string;
        }
        String string2 = HttpClientConfig.getFileDirRemoteUrl();
        string2 = String.valueOf(string2) + string;
        return string2;
    }

    public static String getFileDirRemoteUrl() {
        String string = HttpClientConfig.getBaseUrlByAppKey();
        string = String.valueOf(string) + "/chatfiles/";
        return string;
    }

    public static String getBaseUrlByAppKey() {
        j.c c2 = j.a().c();
        String string = "http://";
        if (c2.c != null && !c2.c.equals("") && c2.c.equals("https")) {
            string = "https://";
        }
        if (!(string = TextUtils.isDigitsOnly((CharSequence)c2.a.substring(0, c2.a.indexOf(46))) ? String.valueOf(string) + c2.a + ":" + c2.b : String.valueOf(string) + c2.a).endsWith("/")) {
            string = String.valueOf(string) + "/";
        }
        string = String.valueOf(string) + EMChatConfig.getInstance().APPKEY.replaceFirst("#", "/");
        return string;
    }

    public static int getTimeout(Map<String, String> map) {
        int n2 = EM_DEFAULT_TIMEOUT;
        if (map != null && map.get(EM_TIME_OUT_KEY) != null) {
            n2 = Integer.valueOf(map.get(EM_TIME_OUT_KEY));
            map.remove(EM_TIME_OUT_KEY);
        }
        return n2;
    }
}

