/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.cloud;

import internal.org.apache.http.entity.mime.HttpMultipartMode;
import internal.org.apache.http.entity.mime.MultipartEntity;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;

class CustomMultiPartEntity
extends MultipartEntity {
    private final ProgressListener a;

    public CustomMultiPartEntity(ProgressListener progressListener) {
        this.a = progressListener;
    }

    public CustomMultiPartEntity(HttpMultipartMode httpMultipartMode, ProgressListener progressListener) {
        super(httpMultipartMode);
        this.a = progressListener;
    }

    public CustomMultiPartEntity(HttpMultipartMode httpMultipartMode, String string, Charset charset, ProgressListener progressListener) {
        super(httpMultipartMode, string, charset);
        this.a = progressListener;
    }

    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        super.writeTo(new CountingOutputStream(outputStream, this.a));
    }

    public static class CountingOutputStream
    extends FilterOutputStream {
        private final ProgressListener listener;
        private long transferred;

        public CountingOutputStream(OutputStream outputStream, ProgressListener progressListener) {
            super(outputStream);
            this.listener = progressListener;
            this.transferred = 0L;
        }

        @Override
        public void write(byte[] byArray, int n2, int n3) throws IOException {
            this.out.write(byArray, n2, n3);
            this.transferred += (long)n3;
            this.listener.transferred(this.transferred);
        }

        @Override
        public void write(int n2) throws IOException {
            this.out.write(n2);
            ++this.transferred;
            this.listener.transferred(this.transferred);
        }
    }

    public static interface ProgressListener {
        public void transferred(long var1);
    }
}

