/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.chat.core;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.PowerManager;
import com.easemob.analytics.EMLoginCollector;
import com.easemob.analytics.EMTimeTag;
import com.easemob.chat.EMChat;
import com.easemob.chat.EMChatConfig;
import com.easemob.chat.EMChatManager;
import com.easemob.chat.EMContactManager;
import com.easemob.chat.a.a.a;
import com.easemob.chat.core.aa;
import com.easemob.chat.core.ab;
import com.easemob.chat.core.b;
import com.easemob.chat.core.j;
import com.easemob.chat.core.p;
import com.easemob.chat.core.q;
import com.easemob.chat.core.u;
import com.easemob.chat.core.y;
import com.easemob.exceptions.EMAuthenticationException;
import com.easemob.exceptions.EMNetworkUnconnectedException;
import com.easemob.exceptions.EaseMobException;
import com.easemob.util.EMLog;
import com.easemob.util.NetUtils;
import com.xonami.javaBells.JingleManager;
import java.io.File;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Random;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.PrivacyListManager;
import org.jivesoftware.smack.Roster;
import org.jivesoftware.smack.SASLAuthentication;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.provider.PrivacyProvider;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smackx.GroupChatInvitation;
import org.jivesoftware.smackx.ServiceDiscoveryManager;
import org.jivesoftware.smackx.entitycaps.EntityCapsManager;
import org.jivesoftware.smackx.packet.ChatStateExtension;
import org.jivesoftware.smackx.packet.DiscoverInfo;
import org.jivesoftware.smackx.packet.OfflineMessageInfo;
import org.jivesoftware.smackx.packet.OfflineMessageRequest;
import org.jivesoftware.smackx.provider.DataFormProvider;
import org.jivesoftware.smackx.provider.DelayInfoProvider;
import org.jivesoftware.smackx.provider.DiscoverInfoProvider;
import org.jivesoftware.smackx.provider.DiscoverItemsProvider;
import org.jivesoftware.smackx.provider.MUCAdminProvider;
import org.jivesoftware.smackx.provider.MUCOwnerProvider;
import org.jivesoftware.smackx.provider.MUCUserProvider;

public class EMConnectionManager {
    private static final String TAG = EMConnectionManager.class.getSimpleName();
    private static final String PERF = "perf";
    private static final String RESOURCE = "mobile";
    private static String xmppResource = null;
    private String bareJid;
    private String password;
    private Context context;
    private final PingListener pingListener = new PingListener();
    private XMPPConnection connection;
    private ConnectionConfiguration connectionConfig;
    private final XmppConnectionListener connectionListener = new XmppConnectionListener();
    private q chatConnectionListener = null;
    private static EMConnectionManager instance = null;
    private int randomBase = -1;
    private int attempts = 0;
    private Thread reconnectionThread = null;
    j.c currentHost = null;
    boolean enableWakeLock = true;
    PowerManager.WakeLock wakeLock = null;
    private static final String LOCK = "easemoblock";
    boolean isDone = false;
    boolean isConnectivityRegistered = false;
    private EMTimeTag chatTag;
    private EMTimeTag imTag;
    boolean connectDisabled = false;
    private BroadcastReceiver connectivityBroadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            boolean bl;
            String string = intent.getAction();
            if (!string.equals("android.net.conn.CONNECTIVITY_CHANGE")) {
                EMLog.d(TAG, "skip no connectivity action");
                return;
            }
            EMLog.d(TAG, "connectivity receiver onReceiver");
            boolean bl2 = bl = !NetUtils.hasDataConnection(context);
            if (bl) {
                if ((EMConnectionManager.this.reconnectionThread == null || !EMConnectionManager.this.reconnectionThread.isAlive()) && EMConnectionManager.this.isConnected()) {
                    new Thread(){

                        @Override
                        public void run() {
                            EMConnectionManager.this.reConnect();
                        }
                    }.start();
                }
            } else {
                if (context == null) {
                    return;
                }
                if (!NetUtils.hasDataConnection(context)) {
                    EMLog.d(TAG, "in connectivity broadcast, skip since no data connection");
                    return;
                }
                if (!EMConnectionManager.this.isConnected()) {
                    EMConnectionManager.this.resetAttempts();
                    if (EMConnectionManager.this.reconnectionThread != null) {
                        EMConnectionManager.this.reconnectionThread.interrupt();
                        new Thread(){

                            @Override
                            public void run() {
                                EMConnectionManager.this.startReconnectionThread();
                            }
                        }.start();
                    }
                }
            }
        }
    };
    private PowerManager powerManager;

    public void onInit() {
        this.context = EMChat.getInstance().getAppContext();
        this.powerManager = (PowerManager)this.context.getSystemService("power");
        this.initConnectionConfig();
        this.connection = new XMPPConnection(this.connectionConfig);
        EntityCapsManager.getInstanceFor(this.connection).disableEntityCaps();
        this.isDone = false;
    }

    public void onInit(String string, String string2) {
        this.onInit();
        this.bareJid = string;
        this.password = string2;
    }

    public void setChatTag(EMTimeTag eMTimeTag) {
        this.chatTag = eMTimeTag;
    }

    public String getCurrentUser() {
        return EMContactManager.getUserNameFromEid(this.bareJid);
    }

    public String getCurrentPwd() {
        return this.password;
    }

    private void initConnectionConfig() {
        this.configure(ProviderManager.getInstance());
        Roster.setDefaultSubscriptionMode(Roster.SubscriptionMode.manual);
        SASLAuthentication.supportSASLMechanism("PLAIN");
        XMPPConnection.DEBUG_ENABLED = p.c().j();
        SmackConfiguration.setPacketReplyTimeout(40000);
        this.currentHost = j.a().b();
        this.connectionConfig = new ConnectionConfiguration(this.currentHost.a, this.currentHost.b, EMChatConfig.getInstance().getDomain());
        this.connectionConfig.setRosterLoadedAtLogin(false);
        this.connectionConfig.setSendPresence(false);
        this.connectionConfig.setReconnectionAllowed(false);
        this.connectionConfig.setCompressionEnabled(true);
        if (Build.VERSION.SDK_INT >= 14) {
            this.connectionConfig.setTruststoreType("AndroidCAStore");
            this.connectionConfig.setTruststorePassword(null);
            this.connectionConfig.setTruststorePath(null);
        } else {
            this.connectionConfig.setTruststoreType("BKS");
            String string = System.getProperty("javax.net.ssl.trustStore");
            if (string == null) {
                string = String.valueOf(System.getProperty("java.home")) + File.separator + "etc" + File.separator + "security" + File.separator + "cacerts.bks";
            }
            this.connectionConfig.setTruststorePath(string);
        }
    }

    public void setChatConnectionListener(q q2) {
        this.chatConnectionListener = q2;
    }

    public void connect() throws EMNetworkUnconnectedException {
        EMLog.d(TAG, "connection manager:connect");
        if (this.connection == null) {
            EMLog.e(TAG, "fail to setup connection");
            throw new EMNetworkUnconnectedException("fail to setup connection");
        }
        if (this.connection.isConnected()) {
            EMLog.d(TAG, "connection is connected, skip reconnect");
            return;
        }
        try {
            EMLog.d(TAG, "before connect");
            this.connection.connect();
            EMLog.d(TAG, "after connect");
        }
        catch (UnknownHostException unknownHostException) {
            EMLog.e(TAG, "unknow host exception:" + unknownHostException.toString());
            if (!NetUtils.hasNetwork(this.context)) {
                throw new EMNetworkUnconnectedException("no network available");
            }
            throw new EMNetworkUnconnectedException(unknownHostException.getMessage());
        }
        catch (NoRouteToHostException noRouteToHostException) {
            EMLog.e(TAG, "NoRouteToHostException:" + noRouteToHostException.toString());
            throw new EMNetworkUnconnectedException(noRouteToHostException.getMessage());
        }
        catch (ConnectException connectException) {
            String string = connectException.toString();
            EMLog.e(TAG, "ConnectException:" + string);
            if (p.c().e() && string != null && j.a().h() && string.toLowerCase().contains("refused")) {
                j.c c2 = j.a().f();
                if (c2 != null) {
                    this.currentHost = c2;
                }
                this.connection.getConfiguration().initHostAddresses(this.currentHost.a, this.currentHost.b);
            }
            throw new EMNetworkUnconnectedException(string);
        }
        catch (SocketException socketException) {
            EMLog.e(TAG, "SocketException:" + socketException.toString());
            throw new EMNetworkUnconnectedException(socketException.getMessage());
        }
        catch (SocketTimeoutException socketTimeoutException) {
            EMLog.e(TAG, "SocketTimeoutException:" + socketTimeoutException.toString());
            throw new EMNetworkUnconnectedException(socketTimeoutException.getMessage());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            String string = null;
            string = !"".equals(exception.getMessage()) ? exception.getMessage() : exception.toString();
            if (p.c().e() && string != null && j.a().h() && string.toLowerCase().contains("refused") && NetUtils.hasNetwork(this.context)) {
                j.c c3 = j.a().f();
                if (c3 != null) {
                    this.currentHost = c3;
                }
                this.connection.getConfiguration().initHostAddresses(this.currentHost.a, this.currentHost.b);
            }
            EMLog.e(TAG, "connection.connect() failed: " + string);
            throw new EMNetworkUnconnectedException(string);
        }
    }

    private void initConnection() throws EMNetworkUnconnectedException {
        EMLog.d(TAG, "enter initConnection()");
        if (!this.connection.isConnected()) {
            EMLog.e(TAG, "Connection is not connected as expected");
            throw new EMNetworkUnconnectedException("Connection is not connected as expected");
        }
        this.connection.addConnectionListener(this.connectionListener);
        this.initFeatures();
        PacketTypeFilter packetTypeFilter = new PacketTypeFilter(a.class);
        this.connection.addPacketListener(this.pingListener, packetTypeFilter);
    }

    private synchronized void login() throws EaseMobException {
        long l2 = System.currentTimeMillis();
        try {
            if (this.connection.isAuthenticated()) {
                EMLog.d(TAG, "already login. skip");
                return;
            }
            if (!this.connection.isConnected()) {
                EMLog.e(TAG, "Connection is not connected as expected");
                throw new EMNetworkUnconnectedException("Connection is not connected as expected");
            }
            EMLog.d(TAG, "try to login with barejid" + this.bareJid);
            this.connection.login(this.bareJid, this.password, EMConnectionManager.getXmppResource(this.context));
            EMLog.d(TAG, "login successfully");
        }
        catch (IllegalStateException illegalStateException) {
            EMLog.d(TAG, "illegalState in connection.login:" + illegalStateException.toString());
            if (illegalStateException.toString().indexOf(" Already logged in to server") < 0) {
                throw new EaseMobException(illegalStateException.toString());
            }
        }
        catch (Exception exception) {
            EMLog.e(TAG, "Failed to login to xmpp server. Caused by: " + exception.getMessage());
            String string = "401";
            String string2 = "not-authorized";
            String string3 = "SASL authentication failed using mechanism PLAIN";
            String string4 = exception.getMessage();
            if (string4 != null && string4.contains(string)) {
                throw new EMAuthenticationException(string);
            }
            if (string4 != null && string4.contains(string2)) {
                throw new EMAuthenticationException(string2);
            }
            if (string4 != null && string4.contains(string3)) {
                throw new EMAuthenticationException(string3);
            }
            throw new EaseMobException(string4);
        }
        try {
            this.sendVersionIQ();
            Presence presence = new Presence(Presence.Type.available);
            if (this.imTag != null) {
                presence.setImLoginTime(this.imTag.stop());
                this.imTag = null;
            }
            if (this.chatTag != null) {
                presence.setChatLoginTime(this.chatTag.stop());
                this.chatTag = null;
            }
            this.connection.sendPacket(presence);
            EMLog.d(PERF, "[perf] login time(ms)" + (System.currentTimeMillis() - l2));
            if (EMChatConfig.isDebugTrafficMode()) {
                com.easemob.b.a.d();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void sendVersionIQ() {
        EMLog.d(TAG, "send version iq");
        ab ab2 = new ab(EMChat.getInstance().getVersion());
        ab2.setTo(EMChatConfig.getInstance().getDomain());
        String string = String.valueOf(EMChatConfig.getInstance().APPKEY) + "_" + EMChatManager.getInstance().getCurrentUser() + "@" + EMChatConfig.getInstance().getDomain();
        ab2.setFrom(string);
        this.connection.sendPacket(ab2);
    }

    public void reuse() {
        this.isDone = false;
        this.connection.addConnectionListener(this.connectionListener);
    }

    public synchronized void connectSync(boolean bl) throws EaseMobException {
        if (this.connectDisabled) {
            return;
        }
        if (this.isDone) {
            return;
        }
        EMLog.d(TAG, "enter connectSync");
        if (this.connection.isConnected() && this.connection.isAuthenticated()) {
            return;
        }
        try {
            if (this.wakeLock == null && this.enableWakeLock) {
                this.wakeLock = this.powerManager.newWakeLock(1, LOCK);
                this.wakeLock.acquire();
                EMLog.d(TAG, "acquire lock");
            }
            EMTimeTag eMTimeTag = new EMTimeTag();
            eMTimeTag.start();
            this.imTag = eMTimeTag;
            this.connect();
            this.initConnection();
            this.login();
            this.releaseWakelock();
            EMLoginCollector.collectIMLoginTime(eMTimeTag.stop());
            if (this.chatConnectionListener != null) {
                this.chatConnectionListener.onConnectionSuccessful();
            }
            this.resetAttempts();
        }
        catch (EaseMobException easeMobException) {
            String string = easeMobException.getMessage();
            this.releaseWakelock();
            EMLog.e(TAG, "connectSync with error = " + string);
            if (!bl && !(easeMobException instanceof EMAuthenticationException)) {
                this.reConnect();
            } else {
                j.a().j();
                this.disconnect();
            }
            EMLoginCollector.collectConnectionError(easeMobException.getMessage());
            throw easeMobException;
        }
    }

    void releaseWakelock() {
        if (this.wakeLock != null && this.wakeLock.isHeld()) {
            this.wakeLock.release();
        }
    }

    public PowerManager.WakeLock getWakeLock() {
        return this.wakeLock;
    }

    void onDnsConfigChanged() {
        this.connection.disconnect();
        j.c c2 = j.a().f();
        if (c2 != null) {
            this.currentHost = c2;
        }
        this.connection.getConfiguration().initHostAddresses(this.currentHost.a, this.currentHost.b);
        this.reConnect();
    }

    private synchronized void reConnect() {
        if (this.connectDisabled) {
            return;
        }
        EMLog.d(TAG, "enter reConnect");
        this.connection.disconnect();
        if (!this.isDone) {
            this.registerConnectivityReceiver();
            this.startReconnectionThread();
        }
    }

    public void forceReconnect() {
        this.reConnect();
    }

    public void reconnectSync() throws EaseMobException {
        if (this.isDone) {
            return;
        }
        EMLog.d(TAG, "try to reconnectSync");
        this.connectSync(false);
    }

    public void reconnectASync() {
        if (this.isDone) {
            return;
        }
        EMLog.d(TAG, "try to reconnectASync");
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    EMConnectionManager.this.reconnectSync();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        };
        thread.start();
    }

    public boolean disconnect() {
        try {
            this.releaseWakelock();
            EMLog.d(TAG, String.valueOf(this.hashCode()) + " : enter disconnect()");
            this.isDone = true;
            if (this.reconnectionThread != null) {
                this.reconnectionThread.interrupt();
            }
            this.unregisterConnectivityReceiver();
            if (this.connection != null) {
                if (this.connectionListener != null) {
                    this.connection.removeConnectionListener(this.connectionListener);
                }
                EMLog.d(TAG, "trying to disconnect connection \uff08" + this.connection.hashCode() + ")");
                this.connection.disconnect();
            }
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public XMPPConnection getConnection() {
        return this.connection;
    }

    public boolean isAuthentificated() {
        if (this.connection == null) {
            return false;
        }
        return this.connection.isAuthenticated();
    }

    public boolean isConnected() {
        if (this.connection == null) {
            return false;
        }
        return this.connection.isConnected();
    }

    private void initFeatures() {
        ServiceDiscoveryManager serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(this.connection);
        if (serviceDiscoveryManager == null) {
            serviceDiscoveryManager = new ServiceDiscoveryManager(this.connection);
        }
        serviceDiscoveryManager.setIdentityName("EaseMob");
        serviceDiscoveryManager.setIdentityType("phone");
        serviceDiscoveryManager.addFeature("http://jabber.org/protocol/disco#info");
        serviceDiscoveryManager.addFeature("jabber:iq:privacy");
        serviceDiscoveryManager.addFeature("urn:xmpp:avatar:metadata");
        serviceDiscoveryManager.addFeature("urn:xmpp:avatar:metadata+notify");
        serviceDiscoveryManager.addFeature("urn:xmpp:avatar:data");
        serviceDiscoveryManager.addFeature("http://jabber.org/protocol/nick");
        serviceDiscoveryManager.addFeature("http://jabber.org/protocol/nick+notify");
        serviceDiscoveryManager.addFeature("http://jabber.org/protocol/muc");
        serviceDiscoveryManager.addFeature("http://jabber.org/protocol/muc#rooms");
        serviceDiscoveryManager.addFeature("urn:xmpp:ping");
        serviceDiscoveryManager.addFeature("easemob:x:roomtype");
        serviceDiscoveryManager.addFeature("http://jabber.org/protocol/disco#info");
        serviceDiscoveryManager.addFeature("urn:xmpp:jingle:1");
        serviceDiscoveryManager.addFeature("urn:xmpp:jingle:transports:ice-udp:1");
        serviceDiscoveryManager.addFeature("urn:xmpp:jingle:apps:rtp:1");
        serviceDiscoveryManager.addFeature("urn:xmpp:jingle:apps:rtp:audio");
        serviceDiscoveryManager.addFeature("urn:xmpp:jingle:apps:rtp:video");
    }

    private void discoverServerFeatures() {
        try {
            ServiceDiscoveryManager serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(this.connection);
            DiscoverInfo discoverInfo = serviceDiscoveryManager.discoverInfo(this.connection.getServiceName());
        }
        catch (XMPPException xMPPException) {
            EMLog.w(TAG, "Unable to discover server features", xMPPException);
        }
    }

    private void configure(ProviderManager providerManager) {
        EMLog.d(TAG, "configure");
        try {
            if (Class.forName("com.xonami.javaBells.JingleManager") != null) {
                JingleManager.enableJingle();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        providerManager.addIQProvider("query", "http://jabber.org/protocol/disco#items", new DiscoverItemsProvider());
        providerManager.addIQProvider("query", "http://jabber.org/protocol/disco#info", new DiscoverInfoProvider());
        providerManager.addIQProvider("query", "jabber:iq:privacy", new PrivacyProvider());
        providerManager.addExtensionProvider("delay", "urn:xmpp:delay", new DelayInfoProvider());
        providerManager.addExtensionProvider("ts", "urn:xmpp:timestamp", new aa());
        providerManager.addIQProvider("query", "http://jabber.org/protocol/disco#items", new DiscoverItemsProvider());
        providerManager.addIQProvider("query", "http://jabber.org/protocol/disco#info", new DiscoverInfoProvider());
        ChatStateExtension.Provider provider = new ChatStateExtension.Provider();
        providerManager.addExtensionProvider("active", "http://jabber.org/protocol/chatstates", provider);
        providerManager.addExtensionProvider("composing", "http://jabber.org/protocol/chatstates", provider);
        providerManager.addExtensionProvider("paused", "http://jabber.org/protocol/chatstates", provider);
        providerManager.addExtensionProvider("inactive", "http://jabber.org/protocol/chatstates", provider);
        providerManager.addExtensionProvider("gone", "http://jabber.org/protocol/chatstates", provider);
        providerManager.addIQProvider("ping", "urn:xmpp:ping", a.class);
        providerManager.addExtensionProvider("x", "http://jabber.org/protocol/muc#user", new MUCUserProvider());
        providerManager.addIQProvider("query", "http://jabber.org/protocol/muc#admin", new MUCAdminProvider());
        providerManager.addIQProvider("query", "http://jabber.org/protocol/muc#owner", new MUCOwnerProvider());
        providerManager.addExtensionProvider("x", "jabber:x:conference", new GroupChatInvitation.Provider());
        providerManager.addExtensionProvider("roomtype", "easemob:x:roomtype", new y());
        providerManager.addIQProvider("offline", "http://jabber.org/protocol/offline", new OfflineMessageRequest.Provider());
        providerManager.addExtensionProvider("offline", "http://jabber.org/protocol/offline", new OfflineMessageInfo.Provider());
        providerManager.addExtensionProvider("x", "jabber:x:data", new DataFormProvider());
        providerManager.addExtensionProvider("received", "urn:xmpp:receipts", new b());
        providerManager.addIQProvider("query", "urn:xmpp:media-conference", new u());
    }

    private void resetAttempts() {
        this.attempts = 0;
        this.randomBase = -1;
    }

    private int timeDelay() {
        if (this.randomBase == -1) {
            this.randomBase = new Random().nextInt(5) + 5;
        }
        ++this.attempts;
        if (this.attempts > 3 && this.attempts <= 9) {
            return this.randomBase + new Random().nextInt(5);
        }
        if (this.attempts > 9) {
            if (this.randomBase * 3 > 30) {
                return 25 + new Random().nextInt(5);
            }
            return this.randomBase * 3;
        }
        return this.randomBase;
    }

    private synchronized void startReconnectionThread() {
        if (this.isDone) {
            return;
        }
        EMLog.d(TAG, String.valueOf(this.hashCode()) + " : enter startReconnectionThread()");
        if (this.reconnectionThread != null && this.reconnectionThread.isAlive()) {
            return;
        }
        EMLog.d(TAG, "start reconnectionThread()");
        this.resetAttempts();
        this.reconnectionThread = new Thread(){

            /*
             * Unable to fully structure code
             */
            @Override
            public void run() {
                EMLog.d(EMConnectionManager.access$0(), "run in reconnectionThread");
                try {
                    3.sleep(new Random().nextInt(2000));
                    ** GOTO lbl28
                }
                catch (InterruptedException var1_1) {
                    var1_1.printStackTrace();
                    if (!EMConnectionManager.this.isDone) ** GOTO lbl28
                    return;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        EMLog.d(EMConnectionManager.access$0(), "run in reconnectionThread with connection " + EMConnectionManager.access$5(EMConnectionManager.this).hashCode());
                        if (NetUtils.hasDataConnection(EMConnectionManager.access$10(EMConnectionManager.this))) {
                            EMConnectionManager.this.reconnectSync();
                        } else {
                            EMLog.d(EMConnectionManager.access$0(), "skip the reconnection since there is no data connection!");
                        }
                    }
                    catch (EaseMobException var1_2) {
                        var1_2.printStackTrace();
                    }
                    var1_4 = EMConnectionManager.access$11(EMConnectionManager.this);
                    while (!EMConnectionManager.this.isConnected() && !EMConnectionManager.this.isDone && var1_4 > 0) {
                        try {
                            3.sleep(1000L);
                            EMConnectionManager.access$12(EMConnectionManager.this).reconnectingIn(--var1_4);
                        }
                        catch (InterruptedException var2_5) {
                            var2_5.printStackTrace();
                            if (!EMConnectionManager.this.isDone) continue block6;
                            return;
                        }
                    }
lbl28:
                    // 4 sources

                    ** while (!EMConnectionManager.this.isConnected() && !EMConnectionManager.this.isDone)
                }
lbl29:
                // 1 sources

            }
        };
        this.reconnectionThread.setName("EASEMOB Reconnection Thread");
        this.reconnectionThread.setDaemon(true);
        this.reconnectionThread.start();
    }

    private void onDisconnected() {
        EMLog.d(TAG, "on disconnected");
        if (this.wakeLock != null && this.wakeLock.isHeld()) {
            this.wakeLock.release();
            EMLog.d(TAG, "lock release");
        }
    }

    public static String getXmppResource(Context context) {
        if (xmppResource == null) {
            xmppResource = RESOURCE;
        }
        return xmppResource;
    }

    public boolean isFinished() {
        return this.isDone;
    }

    void setBlackListActive() throws XMPPException {
        PrivacyListManager privacyListManager = PrivacyListManager.getInstanceFor(this.connection);
        privacyListManager.setActiveListName("special");
    }

    void enableConnect(boolean bl) {
        this.connectDisabled = bl;
    }

    private void registerConnectivityReceiver() {
        if (this.context == null) {
            EMLog.e(TAG, "context is null!......");
            return;
        }
        if (this.isConnectivityRegistered) {
            return;
        }
        try {
            IntentFilter intentFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
            EMLog.d(TAG, "register connectivity receiver.");
            this.context.registerReceiver(this.connectivityBroadcastReceiver, intentFilter);
            this.isConnectivityRegistered = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void unregisterConnectivityReceiver() {
        if (this.context == null) {
            EMLog.e(TAG, "context is null!......");
            return;
        }
        EMLog.d(TAG, "unregisterConnectivityReceiver()");
        try {
            this.isConnectivityRegistered = false;
            this.context.unregisterReceiver(this.connectivityBroadcastReceiver);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static /* synthetic */ Context access$10(EMConnectionManager eMConnectionManager) {
        return eMConnectionManager.context;
    }

    static /* synthetic */ int access$11(EMConnectionManager eMConnectionManager) {
        return eMConnectionManager.timeDelay();
    }

    static /* synthetic */ XmppConnectionListener access$12(EMConnectionManager eMConnectionManager) {
        return eMConnectionManager.connectionListener;
    }

    private class PingListener
    implements PacketListener {
        private PingListener() {
        }

        @Override
        public void processPacket(Packet packet) {
            EMLog.d(TAG, "received ping packet from :" + packet.getFrom());
            if (!(packet instanceof a)) {
                return;
            }
            a a2 = (a)packet;
            if (a2.getType() == IQ.Type.GET) {
                a a3 = new a();
                a3.setType(IQ.Type.RESULT);
                a3.setTo(a2.getFrom());
                a3.setPacketID(a2.getPacketID());
                EMConnectionManager.this.connection.sendPacket(a3);
            }
        }
    }

    private class XmppConnectionListener
    implements ConnectionListener {
        private XmppConnectionListener() {
        }

        @Override
        public void connectionClosed() {
            EMLog.e(TAG, "connectionClosed");
            EMConnectionManager.this.onDisconnected();
        }

        @Override
        public void connectionClosedOnError(Exception exception) {
            EMLog.e(TAG, "connectionClosedOnError in " + exception);
            if (exception != null && exception.getMessage() != null && exception.getMessage().contains("conflict")) {
                EMLog.e(TAG, "connection closed caused by conflict. set autoreconnect to false");
            } else {
                EMConnectionManager.this.registerConnectivityReceiver();
                EMConnectionManager.this.startReconnectionThread();
            }
            EMConnectionManager.this.onDisconnected();
            if (EMConnectionManager.this.chatConnectionListener != null) {
                EMConnectionManager.this.chatConnectionListener.connectionClosedOnError(exception);
            }
        }

        @Override
        public void reconnectingIn(int n2) {
            if (EMConnectionManager.this.chatConnectionListener != null) {
                EMConnectionManager.this.chatConnectionListener.reconnectingIn(n2);
            }
        }

        @Override
        public void reconnectionFailed(Exception exception) {
            EMLog.e(TAG, "xmpp con mgr reconnectionFailed:" + exception);
            EMConnectionManager.this.onDisconnected();
            if (EMConnectionManager.this.chatConnectionListener != null) {
                EMConnectionManager.this.chatConnectionListener.reconnectionFailed(exception);
            }
        }

        @Override
        public void reconnectionSuccessful() {
            EMLog.d(TAG, "reconnectionSuccessful");
            EMConnectionManager.this.sendVersionIQ();
            EMLog.d(TAG, "send available presence after reconnected");
            Presence presence = new Presence(Presence.Type.available);
            EMConnectionManager.this.connection.sendPacket(presence);
            if (EMConnectionManager.this.chatConnectionListener != null) {
                EMConnectionManager.this.chatConnectionListener.reconnectionSuccessful();
            }
        }
    }
}

