/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.chat;

import com.easemob.chat.CmdMessageBody;
import com.easemob.chat.EMContact;
import com.easemob.chat.EMContactManager;
import com.easemob.chat.EMEncryptUtils;
import com.easemob.chat.EMMessage;
import com.easemob.chat.FileMessageBody;
import com.easemob.chat.ImageMessageBody;
import com.easemob.chat.LocationMessageBody;
import com.easemob.chat.MessageBody;
import com.easemob.chat.NormalFileMessageBody;
import com.easemob.chat.TextMessageBody;
import com.easemob.chat.VideoMessageBody;
import com.easemob.chat.VoiceMessageBody;
import com.easemob.chat.core.x;
import com.easemob.chat.core.z;
import com.easemob.util.EMLog;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smackx.packet.DelayInfo;
import org.json.JSONArray;
import org.json.JSONObject;

public class MessageEncoder {
    private static final String TAG = "encoder";
    public static final String ATTR_TYPE = "type";
    public static final String ATTR_TO = "to";
    public static final String ATTR_FROM = "from";
    public static final String ATTR_MSG = "msg";
    public static final String ATTR_URL = "url";
    public static final String ATTR_LOCALURL = "localurl";
    public static final String ATTR_THUMB_LOCALURL = "thumblocalurl";
    public static final String ATTR_FILENAME = "filename";
    public static final String ATTR_THUMBNAIL = "thumb";
    public static final String ATTR_SECRET = "secret";
    public static final String ATTR_SIZE = "size";
    public static final String ATTR_IMG_WIDTH = "width";
    public static final String ATTR_IMG_HEIGHT = "height";
    public static final String ATTR_THUMBNAIL_SECRET = "thumb_secret";
    public static final String ATTR_LENGTH = "length";
    public static final String ATTR_ADDRESS = "addr";
    public static final String ATTR_LATITUDE = "lat";
    public static final String ATTR_LONGITUDE = "lng";
    public static final String ATTR_ACTION = "action";
    public static final String ATTR_PARAM = "param";
    public static final String ATTR_FILE_LENGTH = "file_length";
    public static final String ATTR_EXT = "ext";
    private static final String ATTR_TYPE_TXT = "txt";
    private static final String ATTR_TYPE_IMG = "img";
    private static final String ATTR_TYPE_VOICE = "audio";
    private static final String ATTR_TYPE_VIDEO = "video";
    private static final String ATTR_TYPE_LOCATION = "loc";
    private static final String ATTR_TYPE_CMD = "cmd";
    private static final String ATTR_TYPE_file = "file";

    public static String getJSONMsg(EMMessage eMMessage, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        stringBuffer.append("\"from\":\"" + eMMessage.from.username + "\",");
        stringBuffer.append("\"to\":\"" + eMMessage.to.username + "\",");
        stringBuffer.append("\"bodies\":[{");
        if (eMMessage.type == EMMessage.Type.TXT) {
            MessageEncoder.addTxtBody(stringBuffer, eMMessage);
        } else if (eMMessage.type == EMMessage.Type.IMAGE) {
            MessageEncoder.addImageBody(stringBuffer, eMMessage, bl);
        } else if (eMMessage.type == EMMessage.Type.VOICE) {
            MessageEncoder.addVoiceBody(stringBuffer, eMMessage, bl);
        } else if (eMMessage.type == EMMessage.Type.LOCATION) {
            MessageEncoder.addLocationBody(stringBuffer, eMMessage);
        } else if (eMMessage.type == EMMessage.Type.CMD) {
            MessageEncoder.addCmdBody(stringBuffer, eMMessage);
        } else if (eMMessage.type == EMMessage.Type.VIDEO) {
            MessageEncoder.addVideoBody(stringBuffer, eMMessage, bl);
        } else if (eMMessage.type == EMMessage.Type.FILE) {
            MessageEncoder.addFileBody(stringBuffer, eMMessage, bl);
        }
        stringBuffer.append("}]");
        if (eMMessage.attributes != null) {
            MessageEncoder.addExtAttr(stringBuffer, eMMessage);
        }
        stringBuffer.append("}");
        stringBuffer.toString();
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addExtAttr(StringBuffer stringBuffer, EMMessage eMMessage) {
        stringBuffer.append(",");
        stringBuffer.append("\"ext\":{");
        int n2 = 1;
        Hashtable<String, Object> hashtable = eMMessage.attributes;
        synchronized (hashtable) {
            for (String string : eMMessage.attributes.keySet()) {
                Object object;
                stringBuffer.append("\"" + string + "\":");
                Object object2 = eMMessage.attributes.get(string);
                if (object2 instanceof JSONObject) {
                    stringBuffer.append(object2.toString());
                } else if (object2 instanceof JSONArray) {
                    stringBuffer.append(object2.toString());
                } else if (object2 instanceof String) {
                    object = (String)object2;
                    if (((String)object).startsWith("{") && ((String)object).endsWith("}") && ((String)object).contains(":") || ((String)object).startsWith("[{") && ((String)object).endsWith("}]") && ((String)object).contains(":")) {
                        stringBuffer.append(object2);
                    } else {
                        stringBuffer.append("\"" + object2 + "\"");
                    }
                } else if (object2 instanceof Boolean) {
                    object = (Boolean)object2;
                    if (((Boolean)object).booleanValue()) {
                        stringBuffer.append("true");
                    } else {
                        stringBuffer.append("false");
                    }
                } else {
                    object = (Integer)object2;
                    stringBuffer.append(((Integer)object).toString());
                }
                if (n2 < eMMessage.attributes.size()) {
                    stringBuffer.append(",");
                }
                ++n2;
            }
        }
        stringBuffer.append("}");
    }

    private static void addImageBody(StringBuffer stringBuffer, EMMessage eMMessage, boolean bl) {
        stringBuffer.append("\"type\":\"img\",");
        ImageMessageBody imageMessageBody = (ImageMessageBody)eMMessage.body;
        stringBuffer.append("\"url\":\"" + imageMessageBody.remoteUrl + "\",");
        if (bl) {
            stringBuffer.append("\"localurl\":\"" + imageMessageBody.localUrl + "\",");
        }
        stringBuffer.append("\"filename\":\"" + imageMessageBody.fileName + "\",");
        if (imageMessageBody.thumbnailUrl != null) {
            stringBuffer.append("\"thumb\":\"" + imageMessageBody.thumbnailUrl + "\",");
        }
        stringBuffer.append("\"secret\":\"" + imageMessageBody.secret + "\",");
        stringBuffer.append("\"size\":{\"width\":" + imageMessageBody.width + ",\"" + ATTR_IMG_HEIGHT + "\":" + imageMessageBody.height + "}");
        if (imageMessageBody.thumbnailSecret != null) {
            stringBuffer.append(",\"thumb_secret\":\"" + imageMessageBody.thumbnailSecret + "\"");
        }
    }

    private static void addVideoBody(StringBuffer stringBuffer, EMMessage eMMessage, boolean bl) {
        stringBuffer.append("\"type\":\"video\",");
        VideoMessageBody videoMessageBody = (VideoMessageBody)eMMessage.body;
        stringBuffer.append("\"url\":\"" + videoMessageBody.remoteUrl + "\",");
        if (bl) {
            stringBuffer.append("\"localurl\":\"" + videoMessageBody.localUrl + "\",");
            stringBuffer.append("\"thumblocalurl\":\"" + videoMessageBody.localThumb + "\",");
        }
        stringBuffer.append("\"filename\":\"" + videoMessageBody.fileName + "\",");
        stringBuffer.append("\"thumb\":\"" + videoMessageBody.thumbnailUrl + "\",");
        stringBuffer.append("\"length\":" + videoMessageBody.length + ",");
        stringBuffer.append("\"file_length\":" + videoMessageBody.file_length + ",");
        stringBuffer.append("\"secret\":\"" + videoMessageBody.secret + "\"");
        if (videoMessageBody.thumbnailSecret != null) {
            stringBuffer.append(",\"thumb_secret\":\"" + videoMessageBody.thumbnailSecret + "\"");
        }
    }

    private static void addTxtBody(StringBuffer stringBuffer, EMMessage eMMessage) {
        stringBuffer.append("\"type\":\"txt\",");
        TextMessageBody textMessageBody = (TextMessageBody)eMMessage.body;
        String string = textMessageBody.message;
        string = JSONObject.quote((String)string);
        if (string.startsWith("{") && string.endsWith("}") || string.startsWith("[") && string.endsWith("]")) {
            string = string.replaceAll("\"", "%22");
            stringBuffer.append("\"msg\":\"" + string + "\"");
        }
        stringBuffer.append("\"msg\":" + string);
    }

    private static void addCmdBody(StringBuffer stringBuffer, EMMessage eMMessage) {
        stringBuffer.append("\"type\":\"cmd\",");
        CmdMessageBody cmdMessageBody = (CmdMessageBody)eMMessage.body;
        stringBuffer.append("\"action\":\"" + cmdMessageBody.action + "\",");
        stringBuffer.append("\"param\":[");
        if (cmdMessageBody.params != null && cmdMessageBody.params.size() != 0) {
            for (Map.Entry<String, String> entry : cmdMessageBody.params.entrySet()) {
                stringBuffer.append("{\"");
                stringBuffer.append((Object)entry.getKey());
                stringBuffer.append("\":\"");
                stringBuffer.append((Object)entry.getValue());
                stringBuffer.append("\"},");
            }
            stringBuffer.deleteCharAt(stringBuffer.lastIndexOf(","));
        }
        stringBuffer.append("]");
    }

    private static void addVoiceBody(StringBuffer stringBuffer, EMMessage eMMessage, boolean bl) {
        stringBuffer.append("\"type\":\"audio\",");
        VoiceMessageBody voiceMessageBody = (VoiceMessageBody)eMMessage.body;
        stringBuffer.append("\"url\":\"" + voiceMessageBody.remoteUrl + "\",");
        if (bl) {
            stringBuffer.append("\"localurl\":\"" + voiceMessageBody.localUrl + "\",");
        }
        stringBuffer.append("\"filename\":\"" + voiceMessageBody.fileName + "\",");
        stringBuffer.append("\"length\":" + voiceMessageBody.length + ",");
        stringBuffer.append("\"secret\":\"" + voiceMessageBody.secret + "\"");
    }

    private static void addFileBody(StringBuffer stringBuffer, EMMessage eMMessage, boolean bl) {
        stringBuffer.append("\"type\":\"file\",");
        NormalFileMessageBody normalFileMessageBody = (NormalFileMessageBody)eMMessage.body;
        stringBuffer.append("\"url\":\"" + normalFileMessageBody.remoteUrl + "\",");
        if (bl) {
            stringBuffer.append("\"localurl\":\"" + normalFileMessageBody.localUrl + "\",");
        }
        stringBuffer.append("\"filename\":\"" + normalFileMessageBody.fileName + "\",");
        stringBuffer.append("\"file_length\":" + normalFileMessageBody.fileSize + ",");
        stringBuffer.append("\"secret\":\"" + normalFileMessageBody.secret + "\"");
    }

    private static void addLocationBody(StringBuffer stringBuffer, EMMessage eMMessage) {
        stringBuffer.append("\"type\":\"loc\",");
        LocationMessageBody locationMessageBody = (LocationMessageBody)eMMessage.body;
        stringBuffer.append("\"addr\":\"" + locationMessageBody.address + "\",");
        stringBuffer.append("\"lat\":" + locationMessageBody.latitude + ",");
        stringBuffer.append("\"lng\":" + locationMessageBody.longitude);
    }

    static EMMessage parseXmppMsg(Message message) {
        Object object;
        Object object2;
        String string;
        if (message.getExtension("encrypt", "jabber:client") != null) {
            EMLog.d(TAG, "it is encrypted message, decripting");
            try {
                string = message.getBody();
                object2 = EMContactManager.getUserNameFromEid(message.getFrom());
                object = EMEncryptUtils.decryptMessage(string, (String)object2);
                for (Message.Body object3 : message.getBodies()) {
                    message.removeBody(object3);
                }
                message.setBody((String)object);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (!(string = message.getBody()).startsWith("{") || !string.endsWith("}")) {
            EMLog.d(TAG, "msg not in json format, ignore");
            return null;
        }
        object2 = MessageEncoder.getMsgFromJson(string);
        if (object2 == null) {
            EMLog.e(TAG, "wrong message format:" + message.toXML());
            return null;
        }
        try {
            object = (DelayInfo)message.getExtension("delay", "urn:xmpp:delay");
            if (object != null) {
                ((EMMessage)object2).msgTime = ((DelayInfo)object).getStamp().getTime();
                ((EMMessage)object2).offline = true;
            } else {
                z z2 = (z)message.getExtension("ts", "urn:xmpp:timestamp");
                if (z2 != null) {
                    ((EMMessage)object2).msgTime = z2.a().getTime();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = new x();
        object = (x)message.getExtension(((x)object).getElementName(), ((x)object).getNamespace());
        if (object != null && ((x)object).a() == x.a.a) {
            ((EMMessage)object2).setChatType(EMMessage.ChatType.ChatRoom);
        }
        ((EMMessage)object2).direct = EMMessage.Direct.RECEIVE;
        ((EMMessage)object2).msgId = message.getPacketID();
        ((EMMessage)object2).status = EMMessage.Status.CREATE;
        ((EMMessage)object2).unread = true;
        return object2;
    }

    public static EMMessage getMsgFromJson(String string) {
        JSONArray jSONArray;
        EMContact eMContact;
        EMContact eMContact2;
        JSONObject jSONObject;
        block40: {
            jSONObject = new JSONObject(string);
            eMContact2 = new EMContact(jSONObject.getString(ATTR_FROM));
            eMContact = new EMContact(jSONObject.getString(ATTR_TO));
            jSONArray = jSONObject.getJSONArray("bodies");
            if (jSONArray.length() >= 1) break block40;
            EMLog.d(TAG, "wrong msg without body");
            return null;
        }
        try {
            Object object;
            Object object2;
            Object object3;
            JSONObject jSONObject2 = jSONArray.getJSONObject(0);
            String string2 = jSONObject2.getString(ATTR_TYPE);
            EMMessage eMMessage = null;
            if (string2.equals(ATTR_TYPE_TXT)) {
                eMMessage = new EMMessage(EMMessage.Type.TXT);
                object3 = jSONObject2.getString(ATTR_MSG);
                String string3 = ((String)object3).replaceAll("%22", "\"");
                TextMessageBody textMessageBody = new TextMessageBody(string3);
                eMMessage.addBody(textMessageBody);
            } else if (string2.equals(ATTR_TYPE_IMG)) {
                eMMessage = new EMMessage(EMMessage.Type.IMAGE);
                object3 = jSONObject2.getString(ATTR_URL);
                String string4 = jSONObject2.getString(ATTR_FILENAME);
                String string5 = object3;
                if (jSONObject2.has(ATTR_THUMBNAIL)) {
                    string5 = jSONObject2.getString(ATTR_THUMBNAIL);
                }
                ImageMessageBody imageMessageBody = new ImageMessageBody(string4, (String)object3, string5);
                if (jSONObject2.has(ATTR_LOCALURL)) {
                    imageMessageBody.localUrl = jSONObject2.getString(ATTR_LOCALURL);
                }
                if (jSONObject2.has(ATTR_SECRET)) {
                    imageMessageBody.setSecret(jSONObject2.getString(ATTR_SECRET));
                }
                if (jSONObject2.has(ATTR_THUMBNAIL_SECRET)) {
                    imageMessageBody.setThumbnailSecret(jSONObject2.getString(ATTR_THUMBNAIL_SECRET));
                }
                if (jSONObject2.has(ATTR_SIZE)) {
                    object2 = jSONObject2.getJSONObject(ATTR_SIZE);
                    imageMessageBody.width = object2.getInt(ATTR_IMG_WIDTH);
                    imageMessageBody.height = object2.getInt(ATTR_IMG_HEIGHT);
                }
                eMMessage.addBody(imageMessageBody);
            } else if (string2.equals(ATTR_TYPE_file)) {
                eMMessage = new EMMessage(EMMessage.Type.FILE);
                object3 = jSONObject2.getString(ATTR_URL);
                String string6 = jSONObject2.getString(ATTR_FILENAME);
                NormalFileMessageBody normalFileMessageBody = new NormalFileMessageBody(string6, (String)object3);
                normalFileMessageBody.fileSize = Integer.parseInt(jSONObject2.getString(ATTR_FILE_LENGTH));
                if (jSONObject2.has(ATTR_LOCALURL)) {
                    normalFileMessageBody.localUrl = jSONObject2.getString(ATTR_LOCALURL);
                }
                if (jSONObject2.has(ATTR_SECRET)) {
                    normalFileMessageBody.setSecret(jSONObject2.getString(ATTR_SECRET));
                }
                eMMessage.addBody(normalFileMessageBody);
            } else if (string2.equals(ATTR_TYPE_VIDEO)) {
                eMMessage = new EMMessage(EMMessage.Type.VIDEO);
                object3 = jSONObject2.getString(ATTR_URL);
                String string7 = jSONObject2.getString(ATTR_FILENAME);
                String string8 = jSONObject2.getString(ATTR_THUMBNAIL);
                int n2 = jSONObject2.getInt(ATTR_LENGTH);
                object2 = new VideoMessageBody(string7, (String)object3, string8, n2);
                if (jSONObject2.has(ATTR_LOCALURL)) {
                    ((VideoMessageBody)object2).localUrl = jSONObject2.getString(ATTR_LOCALURL);
                }
                if (jSONObject2.has(ATTR_FILE_LENGTH)) {
                    ((VideoMessageBody)object2).file_length = jSONObject2.getLong(ATTR_FILE_LENGTH);
                }
                if (jSONObject2.has(ATTR_THUMB_LOCALURL)) {
                    ((VideoMessageBody)object2).localThumb = jSONObject2.getString(ATTR_THUMB_LOCALURL);
                }
                if (jSONObject2.has(ATTR_SECRET)) {
                    ((FileMessageBody)object2).setSecret(jSONObject2.getString(ATTR_SECRET));
                }
                if (jSONObject2.has(ATTR_THUMBNAIL_SECRET)) {
                    ((VideoMessageBody)object2).setThumbnailSecret(jSONObject2.getString(ATTR_THUMBNAIL_SECRET));
                }
                eMMessage.addBody((MessageBody)object2);
            } else if (string2.equals(ATTR_TYPE_VOICE)) {
                eMMessage = new EMMessage(EMMessage.Type.VOICE);
                object3 = jSONObject2.getString(ATTR_URL);
                String string9 = jSONObject2.getString(ATTR_FILENAME);
                int n3 = jSONObject2.getInt(ATTR_LENGTH);
                VoiceMessageBody voiceMessageBody = new VoiceMessageBody(string9, (String)object3, n3);
                if (jSONObject2.has(ATTR_LOCALURL)) {
                    voiceMessageBody.localUrl = jSONObject2.getString(ATTR_LOCALURL);
                }
                if (jSONObject2.has(ATTR_SECRET)) {
                    voiceMessageBody.setSecret(jSONObject2.getString(ATTR_SECRET));
                }
                eMMessage.addBody(voiceMessageBody);
            } else if (string2.equals(ATTR_TYPE_LOCATION)) {
                eMMessage = new EMMessage(EMMessage.Type.LOCATION);
                object3 = jSONObject2.getString(ATTR_ADDRESS);
                double d2 = jSONObject2.getDouble(ATTR_LATITUDE);
                double d3 = jSONObject2.getDouble(ATTR_LONGITUDE);
                object = new LocationMessageBody((String)object3, d2, d3);
                eMMessage.addBody((MessageBody)object);
            } else if (string2.equals(ATTR_TYPE_CMD)) {
                Object object4;
                eMMessage = new EMMessage(EMMessage.Type.CMD);
                object3 = new HashMap();
                if (jSONObject2.has(ATTR_PARAM)) {
                    object4 = jSONObject2.getJSONArray(ATTR_PARAM);
                    int n4 = 0;
                    while (n4 < object4.length()) {
                        JSONObject jSONObject3 = object4.getJSONObject(n4);
                        object2 = (String)jSONObject3.keys().next();
                        object = (String)jSONObject3.get((String)object2);
                        ((HashMap)object3).put(object2, object);
                        ++n4;
                    }
                }
                object4 = new CmdMessageBody(jSONObject2.getString(ATTR_ACTION), (HashMap<String, String>)object3);
                eMMessage.addBody((MessageBody)object4);
            }
            if (eMMessage != null) {
                eMMessage.from = eMContact2;
                eMMessage.to = eMContact;
            }
            if (jSONObject.has(ATTR_EXT)) {
                object3 = jSONObject.getJSONObject(ATTR_EXT);
                Iterator iterator = object3.keys();
                while (iterator.hasNext()) {
                    String string10 = (String)iterator.next();
                    Object object5 = object3.get(string10);
                    if (object5 instanceof String) {
                        eMMessage.setAttribute(string10, (String)object5);
                        continue;
                    }
                    if (object5 instanceof Integer) {
                        eMMessage.setAttribute(string10, (Integer)object5);
                        continue;
                    }
                    if (object5 instanceof Boolean) {
                        eMMessage.setAttribute(string10, (Boolean)object5);
                        continue;
                    }
                    if (object5 instanceof JSONObject) {
                        eMMessage.setAttribute(string10, (JSONObject)object5);
                        continue;
                    }
                    if (object5 instanceof JSONArray) {
                        eMMessage.setAttribute(string10, (JSONArray)object5);
                        continue;
                    }
                    EMLog.e(ATTR_MSG, "unknow additonal msg attr:" + object5.getClass().getName());
                }
            }
            return eMMessage;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }
}

