/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.chat;

import com.easemob.chat.EMCallDirection;
import com.easemob.chat.EMCallStateChangeListener;
import com.easemob.chat.EMChat;
import com.easemob.chat.EMJingleStreamManager;
import com.easemob.chat.EMSessionHandler;
import com.easemob.chat.EMStreamParams;
import com.easemob.chat.EMVoiceCallManager;
import com.easemob.util.EMLog;
import com.easemob.util.NetUtils;
import com.xonami.javaBells.DefaultJingleSession;
import java.util.List;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.CandidatePacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.ContentPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.IceUdpTransportPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.JingleIQ;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.JinglePacketFactory;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.Reason;
import org.jivesoftware.smack.XMPPConnection;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class EMVoiceCallSession
extends DefaultJingleSession {
    private static final String TAG = EMVoiceCallSession.class.getSimpleName();
    protected EMJingleStreamManager jingleStreamManager;
    protected EMCallStateChangeListener stateChangeListener = null;
    protected JingleIQ jingleIQ = null;
    protected EMCallStateChangeListener.CallState callState = EMCallStateChangeListener.CallState.IDLE;
    protected EMStreamParams streamParams = null;
    protected boolean isLocalHostCandiate = true;
    protected boolean noNeedToCloseSesson = false;
    EMCallDirection callDirection = null;
    protected String callConfig;
    protected boolean isRelayCall = false;

    String getPeerJid() {
        return this.peerJid;
    }

    EMVoiceCallSession build(EMJingleStreamManager eMJingleStreamManager) {
        this.jingleStreamManager = eMJingleStreamManager;
        return this;
    }

    EMVoiceCallSession buildCallConfig(String string) {
        this.callConfig = string;
        return this;
    }

    EMVoiceCallSession registerCallStateListener(EMCallStateChangeListener eMCallStateChangeListener) {
        this.stateChangeListener = eMCallStateChangeListener;
        return this;
    }

    protected EMVoiceCallSession(EMSessionHandler eMSessionHandler, String string, XMPPConnection xMPPConnection) {
        super(eMSessionHandler, string, xMPPConnection);
        if (!EMVoiceCallManager.getInstance().isActiveCallOngoing()) {
            eMSessionHandler.setActiveSession(this);
        }
    }

    protected void freeIce() {
    }

    protected String contentListToJson(List<ContentPacketExtension> list) {
        try {
            JSONObject jSONObject = new JSONObject();
            JSONArray jSONArray = new JSONArray();
            for (ContentPacketExtension contentPacketExtension : list) {
                String string = contentPacketExtension.getName();
                List<IceUdpTransportPacketExtension> list2 = contentPacketExtension.getChildExtensionsOfType(IceUdpTransportPacketExtension.class);
                IceUdpTransportPacketExtension iceUdpTransportPacketExtension = list2.get(0);
                List<CandidatePacketExtension> list3 = iceUdpTransportPacketExtension.getCandidateList();
                for (CandidatePacketExtension candidatePacketExtension : list3) {
                    JSONObject jSONObject2 = new JSONObject();
                    if (string.equals(EMVoiceCallManager.CallType.video.toString())) {
                        jSONObject2.put("component", candidatePacketExtension.getComponent() + 2);
                    } else {
                        jSONObject2.put("component", candidatePacketExtension.getComponent());
                    }
                    jSONObject2.put("foundation", (Object)candidatePacketExtension.getFoundation());
                    jSONObject2.put("generation", candidatePacketExtension.getGeneration());
                    jSONObject2.put("id", (Object)candidatePacketExtension.getID());
                    jSONObject2.put("ip", (Object)candidatePacketExtension.getIP());
                    jSONObject2.put("network", candidatePacketExtension.getNetwork());
                    jSONObject2.put("port", candidatePacketExtension.getPort());
                    jSONObject2.put("priority", candidatePacketExtension.getPriority());
                    jSONObject2.put("protocol", (Object)candidatePacketExtension.getProtocol());
                    jSONObject2.put("type", (Object)candidatePacketExtension.getType());
                    jSONArray.put((Object)jSONObject2);
                }
                if (!jSONObject.has("pwd")) {
                    jSONObject.put("pwd", (Object)iceUdpTransportPacketExtension.getPassword());
                }
                if (jSONObject.has("ufrag")) continue;
                jSONObject.put("ufrag", (Object)iceUdpTransportPacketExtension.getUfrag());
            }
            jSONObject.put("candidates", (Object)jSONArray);
            return jSONObject.toString();
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            return null;
        }
    }

    EMCallDirection getCallDirection() {
        return this.callDirection;
    }

    EMCallStateChangeListener.CallState getCallState() {
        return this.callState;
    }

    public void handleCallAccept(JingleIQ jingleIQ) {
    }

    public void handleCallerRelay(JingleIQ jingleIQ) {
    }

    public void onBusy() {
        this.connection.sendPacket(JinglePacketFactory.createSessionTerminate(this.myJid, this.peerJid, this.sessionId, Reason.BUSY, null));
        this.state = DefaultJingleSession.SessionState.CLOSED;
        this.jinglePacketHandler.removeJingleSession(this);
    }

    void endCall() {
        if (this.callState != EMCallStateChangeListener.CallState.CONNECTED && this.callState != EMCallStateChangeListener.CallState.ACCEPTED) {
            this.closeSession(Reason.DECLINE);
            this.changeState(EMCallStateChangeListener.CallState.DISCONNNECTED, EMCallStateChangeListener.CallError.ERROR_NONE);
        } else {
            this.closeSession(Reason.SUCCESS);
            this.changeState(EMCallStateChangeListener.CallState.DISCONNNECTED, EMCallStateChangeListener.CallError.ERROR_NONE);
        }
    }

    public boolean isVideoCall() {
        return this.jingleStreamManager != null ? this.jingleStreamManager.isVideoCall() : false;
    }

    protected void handleNegoResult(String string) {
        try {
            JSONObject jSONObject = new JSONObject(string);
            EMLog.d(TAG, "negotiation complete, result: " + string);
            int n2 = jSONObject.getInt("result");
            if (n2 != 0) {
                this.onNegotiationFailed();
            } else {
                this.onNegotiationSuccessed(jSONObject);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.onNegotiationFailed();
        }
    }

    protected void onNegotiationFailed() {
        EMLog.e(TAG, "negotiation fails");
        String string = this.getConferenceId();
        if (string != null) {
            EMVoiceCallManager.getInstance().removeP2PConference(string);
        }
        this.closeSession(Reason.CONNECTIVITY_ERROR);
        this.changeState(EMCallStateChangeListener.CallState.DISCONNNECTED, EMCallStateChangeListener.CallError.ERROR_TRANSPORT);
    }

    protected String getConferenceId() {
        String string = null;
        if (this.callConfig != null && !"{}".equals(this.callConfig)) {
            try {
                JSONObject jSONObject = new JSONObject(this.callConfig);
                string = jSONObject.getJSONObject("relayMS").getJSONObject("caller").getString("conferenceId");
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return string;
    }

    protected void onNegotiationSuccessed(JSONObject jSONObject) {
        EMLog.e(TAG, "negotiation success");
        JingleIQ jingleIQ = JinglePacketFactory.createCallerRelay(this.myJid, this.peerJid, this.sessionId, "disabled");
        this.connection.sendPacket(jingleIQ);
        if (this.streamParams == null) {
            this.streamParams = new EMStreamParams();
        }
        try {
            String string = null;
            this.isRelayCall = false;
            if (jSONObject.has("pairs")) {
                string = jSONObject.getString("pairs");
            } else {
                string = jSONObject.getString("relay_pairs");
                this.isRelayCall = true;
            }
            this.streamParams.isRelayCall = this.isRelayCall;
            JSONArray jSONArray = new JSONArray(string);
            int n2 = 0;
            while (n2 < jSONArray.length()) {
                JSONObject jSONObject2 = jSONArray.getJSONObject(n2);
                int n3 = jSONObject2.getInt("comp_id");
                JSONObject jSONObject3 = null;
                JSONObject jSONObject4 = null;
                if (this.isVoiceCallCandidate(n3)) {
                    jSONObject3 = jSONObject2.getJSONObject("local");
                    this.streamParams.localPort = jSONObject3.getInt("port");
                    this.streamParams.localAddress = jSONObject3.getString("ip");
                    jSONObject4 = jSONObject2.getJSONObject("remote");
                    this.streamParams.remotePort = jSONObject4.getInt("port");
                    this.streamParams.remoteAddress = jSONObject4.getString("ip");
                } else if (this.isVideoCallCandidate(n3, this.isRelayCall)) {
                    jSONObject3 = jSONObject2.getJSONObject("local");
                    this.streamParams.videoLocalPort = jSONObject3.getInt("port");
                    jSONObject4 = jSONObject2.getJSONObject("remote");
                    this.streamParams.videoRemotePort = jSONObject4.getInt("port");
                    this.streamParams.videoRemoteAddress = jSONObject4.getString("ip");
                }
                if (this.isRelayCall) {
                    if (n3 == 2) {
                        this.streamParams.videoChannelId = jSONObject4.getInt("channelId");
                    } else {
                        this.streamParams.channelId = jSONObject4.getInt("channelId");
                    }
                    this.streamParams.conferenceId = jSONObject4.getString("conferenceId");
                    this.streamParams.rcode = jSONObject4.getString("rcode");
                }
                ++n2;
            }
            if (this.streamParams.conferenceId == null) {
                this.streamParams.conferenceId = this.sessionId;
            }
            if (this.streamParams.rcode == null) {
                this.streamParams.rcode = "-1";
            }
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            EMLog.d(TAG, "parse nogetiation result fail : " + jSONException.getMessage());
            this.onNegotiationFailed();
            return;
        }
        if (this.callState == EMCallStateChangeListener.CallState.DISCONNNECTED) {
            EMLog.d(TAG, "call state is DISCONNNECTED");
            return;
        }
        this.onConnectionConnected();
    }

    private boolean isVideoCallCandidate(int n2, boolean bl) {
        return n2 == 3 || bl && n2 == 2;
    }

    private boolean isVoiceCallCandidate(int n2) {
        return n2 == 1;
    }

    protected void onConnectionConnected() {
        this.changeState(EMCallStateChangeListener.CallState.CONNECTED, EMCallStateChangeListener.CallError.ERROR_NONE);
        this.jingleStreamManager.startStream(this.streamParams);
    }

    @Override
    protected void closeSession(final Reason reason) {
        this.free();
        if (this.state == DefaultJingleSession.SessionState.CLOSED) {
            return;
        }
        if (reason != null) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        JingleIQ jingleIQ = JinglePacketFactory.createSessionTerminate(EMVoiceCallSession.this.myJid, EMVoiceCallSession.this.peerJid, EMVoiceCallSession.this.sessionId, reason, null);
                        jingleIQ.setStatistic(EMVoiceCallSession.this.getCallStatistic(EMVoiceCallSession.this.jingleStreamManager.callCostTime));
                        EMVoiceCallSession.this.connection.sendPacket(jingleIQ);
                    }
                    catch (IllegalStateException illegalStateException) {
                        illegalStateException.printStackTrace();
                        EMLog.e("DefaultJingleSession", "no connection!");
                    }
                }
            }).start();
        }
        EMLog.d(TAG, "close sesstion, state: " + (Object)((Object)this.state));
        this.state = DefaultJingleSession.SessionState.CLOSED;
        this.jinglePacketHandler.removeJingleSession(this);
        this.callState = EMCallStateChangeListener.CallState.DISCONNNECTED;
    }

    protected String getCallStatistic(int n2) {
        String string = NetUtils.getNetworkType(EMChat.getInstance().getAppContext());
        String string2 = "android," + EMChat.getInstance().getVersion();
        String string3 = this.getCallDirection() == EMCallDirection.OUTGOING ? "caller" : "callee";
        String string4 = this.jingleStreamManager.isVideoCall() ? "video" : "audio";
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<statistics network=\"" + string + "\"").append(" version=\"" + string2 + "\"").append(" identity=\"" + string3 + "\"").append(" type=\"" + string4 + "\"");
        if (n2 > 0) {
            stringBuilder.append(" duration=\"" + n2 + "\"");
        }
        stringBuilder.append("/>");
        return stringBuilder.toString();
    }

    protected void changeState(EMCallStateChangeListener.CallState callState, EMCallStateChangeListener.CallError callError) {
        if (EMVoiceCallManager.getInstance().getActiveSession() == null || this.getSessionId() == null) {
            return;
        }
        if (!this.getSessionId().equals(EMVoiceCallManager.getInstance().getActiveSession().getSessionId())) {
            return;
        }
        this.callState = callState;
        if (this.stateChangeListener != null) {
            this.stateChangeListener.onCallStateChanged(callState, callError);
        }
    }

    protected void free() {
        this.freeIce();
        if (this.jingleStreamManager != null) {
            this.jingleStreamManager.stopStream();
        }
        EMSessionHandler eMSessionHandler = (EMSessionHandler)this.jinglePacketHandler;
        eMSessionHandler.setActiveSession(null);
    }

    void onTimerOut() {
        this.closeSession(Reason.TIMEOUT);
        this.changeState(EMCallStateChangeListener.CallState.DISCONNNECTED, EMCallStateChangeListener.CallError.ERROR_NORESPONSE);
    }
}

