/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.chat;

import com.easemob.EMConnectionListener;
import com.easemob.chat.EMCallDirection;
import com.easemob.chat.EMCallStateChangeListener;
import com.easemob.chat.EMCallerJingleSession;
import com.easemob.chat.EMChatManager;
import com.easemob.chat.EMContactManager;
import com.easemob.chat.EMJingleStreamManager;
import com.easemob.chat.EMReceiverJingleSession;
import com.easemob.chat.EMSessionHandler;
import com.easemob.chat.EMSessionManager;
import com.easemob.chat.EMVoiceCallSession;
import com.easemob.chat.core.f;
import com.easemob.chat.core.p;
import com.easemob.chat.core.t;
import com.easemob.exceptions.EMNetworkUnconnectedException;
import com.easemob.exceptions.EMNoActiveCallException;
import com.easemob.exceptions.EMServiceNotReadyException;
import com.easemob.exceptions.EaseMobException;
import com.easemob.media.EIce;
import com.easemob.util.EMLog;
import com.xonami.javaBells.JingleSession;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.ContentPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.JingleAction;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.JingleIQ;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.IQ;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class EMVoiceCallManager {
    private static final String TAG = EMVoiceCallManager.class.getSimpleName();
    private static EMVoiceCallManager instance = null;
    private EMSessionHandler incomingCallListener = null;
    private EMSessionHandler outgoingCallHandler = null;
    private EMCallStateChangeListener stateChangeListener = null;
    private CallStateChangeListenerDelegate stateChangeListenerDelegate = new CallStateChangeListenerDelegate();
    private boolean inited = false;
    private EMVoiceCallSession activeSession = null;
    private Thread makingCallThread = null;
    private Timer callingTimer = new Timer();
    private boolean callWasEnded = false;
    private static final long CALLING_TIMEROUT = 50000L;
    private EMJingleStreamManager jsm;

    private EMVoiceCallManager() {
    }

    synchronized void init() {
        if (this.inited) {
            return;
        }
        this.registerConnectionListener();
        this.registerIceLogListener();
        this.inited = true;
    }

    private void registerIceLogListener() {
        EIce.registerLogListener(new EIce.LogListener(){

            @Override
            public void onLog(int n2, String string) {
                EMLog.d("EICE", string);
            }
        });
    }

    static synchronized EMVoiceCallManager getInstance() {
        if (instance == null) {
            instance = new EMVoiceCallManager();
        }
        return instance;
    }

    boolean isActiveCallOngoing() {
        return this.activeSession != null;
    }

    EMVoiceCallSession getActiveSession() {
        return this.activeSession;
    }

    public boolean isDirectCall() {
        if (this.getActiveSession() != null) {
            return !this.getActiveSession().isRelayCall;
        }
        return true;
    }

    EMCallDirection getCallDirection() {
        return this.activeSession == null ? this.activeSession.getCallDirection() : EMCallDirection.NONE;
    }

    void addStateChangeListener(EMCallStateChangeListener eMCallStateChangeListener) {
        this.stateChangeListener = eMCallStateChangeListener;
    }

    void removeStateChangeListener(EMCallStateChangeListener eMCallStateChangeListener) {
        this.stateChangeListener = null;
    }

    private void startListeningCall() throws EMServiceNotReadyException {
        if (this.incomingCallListener != null) {
            return;
        }
        XMPPConnection xMPPConnection = EMSessionManager.getInstance().getConnection();
        if (xMPPConnection == null || !xMPPConnection.isConnected()) {
            throw new EMServiceNotReadyException("no connection is initialized!");
        }
        this.incomingCallListener = new EMSessionHandler(xMPPConnection){

            @Override
            protected boolean jiqAccepted(JingleIQ jingleIQ) {
                JingleAction jingleAction = jingleIQ.getAction();
                return jingleAction == JingleAction.SESSION_INITIATE || jingleAction == JingleAction.CALLER_RELAY;
            }

            @Override
            public JingleSession createJingleSession(String string, JingleIQ jingleIQ) {
                EMReceiverJingleSession eMReceiverJingleSession = (EMReceiverJingleSession)new EMReceiverJingleSession(this, string, this.connection).registerCallStateListener(EMVoiceCallManager.this.stateChangeListenerDelegate);
                return eMReceiverJingleSession;
            }
        };
    }

    void makeCall(final String string, final CallType callType) throws EMServiceNotReadyException {
        XMPPConnection xMPPConnection = EMSessionManager.getInstance().getConnection();
        if (xMPPConnection == null || !xMPPConnection.isConnected()) {
            throw new EMServiceNotReadyException("no connection is initialized!");
        }
        if (this.activeSession != null && this.activeSession.getCallDirection() == EMCallDirection.OUTGOING) {
            this.activeSession.endCall();
        }
        if (this.activeSession != null && this.activeSession.getCallDirection() == EMCallDirection.INCOMING) {
            this.activeSession.onBusy();
        }
        if (this.outgoingCallHandler != null) {
            xMPPConnection.removePacketListener(this.outgoingCallHandler);
        }
        this.makingCallThread = new Thread(){

            @Override
            public void run() {
                EMVoiceCallManager.this.syncMakeCall(string, callType);
            }
        };
        this.makingCallThread.start();
    }

    private synchronized void syncMakeCall(String string, CallType callType) {
        Object object;
        XMPPConnection xMPPConnection = EMSessionManager.getInstance().getConnection();
        if (xMPPConnection == null || !xMPPConnection.isConnected()) {
            this.stateChangeListenerDelegate.onCallStateChanged(EMCallStateChangeListener.CallState.DISCONNNECTED, EMCallStateChangeListener.CallError.ERROR_TRANSPORT);
            return;
        }
        if (this.activeSession != null && this.activeSession.getCallDirection() == EMCallDirection.INCOMING) {
            this.activeSession.onBusy();
        }
        final String string2 = String.valueOf(EMContactManager.getEidFromUserName(string)) + "/mobile";
        this.jsm = new EMJingleStreamManager(ContentPacketExtension.CreatorEnum.initiator, callType);
        List<f> list = null;
        List<p.a> list2 = null;
        try {
            object = this.joinP2PConference(callType, string);
            list = ((t)object).a();
            list2 = ((t)object).b();
        }
        catch (EaseMobException easeMobException) {
            easeMobException.printStackTrace();
        }
        object = this.getCallConfig(callType, true, list, list2);
        this.outgoingCallHandler = new EMSessionHandler(xMPPConnection, (String)object){
            private final /* synthetic */ String val$callConfig;
            {
                this.val$callConfig = string22;
                super(xMPPConnection);
            }

            @Override
            protected boolean jiqAccepted(JingleIQ jingleIQ) {
                JingleAction jingleAction = jingleIQ.getAction();
                return jingleAction == JingleAction.CALL_ACCEPT || jingleAction == JingleAction.SESSION_ACCEPT;
            }

            @Override
            public JingleSession createJingleSession(String string, JingleIQ jingleIQ) {
                return new EMCallerJingleSession(this, string, this.connection).buildPeer(string2).build(EMVoiceCallManager.this.jsm).buildCallConfig(this.val$callConfig).registerCallStateListener(EMVoiceCallManager.this.stateChangeListenerDelegate);
            }
        };
        EMCallerJingleSession eMCallerJingleSession = (EMCallerJingleSession)this.outgoingCallHandler.createInitateJingleSession(JingleIQ.generateSID());
        this.activeSession = eMCallerJingleSession;
        try {
            eMCallerJingleSession.makeCall();
        }
        catch (EaseMobException easeMobException) {
            this.stateChangeListenerDelegate.onCallStateChanged(EMCallStateChangeListener.CallState.DISCONNNECTED, EMCallStateChangeListener.CallError.ERROR_TRANSPORT);
        }
        this.makingCallThread = null;
        this.startCallingTimer();
    }

    public void pauseVoiceTransfer() {
        if (this.jsm != null) {
            this.jsm.pauseVoiceStream();
        }
    }

    public void resumeVoiceTransfer() {
        if (this.jsm != null) {
            this.jsm.resumeVoiceStream();
        }
    }

    public int getVoiceInputLevel() {
        if (this.jsm != null) {
            return this.jsm.getVoiceInputLevel();
        }
        return 0;
    }

    public String getCallConfig(CallType callType, boolean bl, List<f> list, List<p.a> list2) {
        JSONObject jSONObject;
        List<p.a> list3 = p.c().M();
        if (bl) {
            list3 = list2;
        }
        JSONObject jSONObject2 = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        try {
            if (callType == CallType.video) {
                jSONObject2.put("compCount", 4);
            } else {
                jSONObject2.put("compCount", 2);
            }
            if (list3 != null) {
                int n2 = 0;
                while (n2 < list3.size()) {
                    jSONObject = new JSONObject();
                    jSONObject.put("host", (Object)list3.get((int)n2).a);
                    jSONObject.put("port", list3.get((int)n2).b);
                    jSONArray.put((Object)jSONObject);
                    ++n2;
                }
                jSONObject2.put("turnAddrs", (Object)jSONArray);
            }
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            EMLog.e(TAG, "get turn server config fail");
            return "{}";
        }
        if (list == null) {
            return jSONObject2.toString();
        }
        JSONObject jSONObject3 = new JSONObject();
        jSONObject = new JSONObject();
        JSONObject jSONObject4 = new JSONObject();
        try {
            for (f f2 : list) {
                if (f2.a().toLowerCase().equals(EMChatManager.getInstance().getCurrentUser().toLowerCase())) {
                    this.putConferenceConfig(jSONObject, f2);
                    jSONObject3.put("caller", (Object)jSONObject);
                    continue;
                }
                this.putConferenceConfig(jSONObject4, f2);
                jSONObject3.put("callee", (Object)jSONObject4);
            }
            jSONObject2.put("relayMS", (Object)jSONObject3);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        return jSONObject2.toString();
    }

    private void putConferenceConfig(JSONObject jSONObject, f f2) throws JSONException {
        jSONObject.put("conferenceId", (Object)f2.c()).put("serverIp", (Object)f2.d()).put("rcode", (Object)f2.e()).put("serverPort", Integer.parseInt(f2.f())).put("channelId", Integer.parseInt(f2.g()));
        if (f2.b() != null) {
            jSONObject.put("vchannelId", Integer.parseInt(f2.b()));
        }
    }

    private void startCallingTimer() {
        this.callingTimer = new Timer();
        this.callingTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                EMCallStateChangeListener.CallState callState;
                if (EMVoiceCallManager.this.activeSession != null && ((callState = EMVoiceCallManager.this.activeSession.getCallState()) != EMCallStateChangeListener.CallState.ACCEPTED || callState != EMCallStateChangeListener.CallState.DISCONNNECTED)) {
                    EMVoiceCallManager.this.activeSession.onTimerOut();
                }
            }
        }, 50000L);
    }

    void answerCall() throws EMNoActiveCallException, EMNetworkUnconnectedException {
        final EMReceiverJingleSession eMReceiverJingleSession = (EMReceiverJingleSession)this.activeSession;
        try {
            this.checkConnection();
        }
        catch (EMNetworkUnconnectedException eMNetworkUnconnectedException) {
            eMNetworkUnconnectedException.printStackTrace();
            if (eMReceiverJingleSession != null) {
                eMReceiverJingleSession.endCall();
            }
            throw new EMNetworkUnconnectedException("Please check your connection!");
        }
        if (eMReceiverJingleSession == null) {
            EMLog.e(TAG, "no imcoming active call");
            throw new EMNoActiveCallException("no imcoming active call");
        }
        new Thread(){

            @Override
            public void run() {
                if (eMReceiverJingleSession != null) {
                    EMVoiceCallManager.this.jsm = eMReceiverJingleSession.jingleStreamManager;
                    eMReceiverJingleSession.answerCall();
                }
            }
        }.start();
    }

    void rejectCall() throws EMNoActiveCallException {
        final EMReceiverJingleSession eMReceiverJingleSession = (EMReceiverJingleSession)this.activeSession;
        if (eMReceiverJingleSession == null) {
            EMLog.e(TAG, "no imcoming active call");
            throw new EMNoActiveCallException("no imcoming active call");
        }
        new Thread(){

            @Override
            public void run() {
                if (eMReceiverJingleSession != null) {
                    eMReceiverJingleSession.rejectCall();
                }
            }
        }.start();
    }

    void endCall() {
        this.callingTimer.cancel();
        new Thread(new Runnable(){

            @Override
            public void run() {
                if (EMVoiceCallManager.this.makingCallThread != null && EMVoiceCallManager.this.makingCallThread.isAlive()) {
                    EMLog.d(TAG, "endcall and wait for call thread end");
                    long l2 = System.currentTimeMillis();
                    try {
                        EMVoiceCallManager.this.makingCallThread.join();
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                    EMLog.d(TAG, "wait for call thread cost time : " + (System.currentTimeMillis() - l2));
                }
                if (EMVoiceCallManager.this.activeSession == null) {
                    EMLog.w(TAG, "no active call!");
                    EMVoiceCallManager.this.stateChangeListenerDelegate.onCallStateChanged(EMCallStateChangeListener.CallState.DISCONNNECTED, EMCallStateChangeListener.CallError.ERROR_NONE);
                    return;
                }
                if (EMVoiceCallManager.this.activeSession != null) {
                    EMLog.d(TAG, "end an active call with call direction = " + (Object)((Object)EMVoiceCallManager.this.activeSession.getCallDirection()));
                    if (EMVoiceCallManager.this.activeSession != null) {
                        EMVoiceCallManager.this.activeSession.endCall();
                    }
                }
            }
        }).start();
    }

    synchronized void onCallRinging(EMVoiceCallSession eMVoiceCallSession) {
        if (this.activeSession != null && this.activeSession != eMVoiceCallSession) {
            eMVoiceCallSession.onBusy();
            return;
        }
        if (this.activeSession == null) {
            this.activeSession = eMVoiceCallSession;
        }
        if (eMVoiceCallSession != null && eMVoiceCallSession.isVideoCall()) {
            EMChatManager.getInstance().notifyIncomingCall(this.activeSession.getPeerJid(), CallType.video);
        } else {
            EMChatManager.getInstance().notifyIncomingCall(this.activeSession.getPeerJid(), CallType.audio);
        }
    }

    void onJingleInitiateAction(EMVoiceCallSession eMVoiceCallSession) {
        EMReceiverJingleSession eMReceiverJingleSession = (EMReceiverJingleSession)eMVoiceCallSession;
        if (this.activeSession != null) {
            eMReceiverJingleSession.rejectSessionInitiate();
        } else {
            this.activeSession = eMVoiceCallSession;
            eMReceiverJingleSession.acceptSessionInitiate();
        }
    }

    void registerConnectionListener() {
        EMChatManager.getInstance().addConnectionListener(new EMConnectionListener(){

            @Override
            public void onConnected() {
                try {
                    XMPPConnection xMPPConnection = EMSessionManager.getInstance().getConnection();
                    if (xMPPConnection != null && EMVoiceCallManager.this.incomingCallListener != null) {
                        xMPPConnection.removePacketListener(EMVoiceCallManager.this.incomingCallListener);
                    }
                    EMVoiceCallManager.this.incomingCallListener = null;
                    EMVoiceCallManager.this.startListeningCall();
                }
                catch (EMServiceNotReadyException eMServiceNotReadyException) {
                    eMServiceNotReadyException.printStackTrace();
                    EMLog.w(TAG, eMServiceNotReadyException.getMessage());
                }
            }

            @Override
            public void onDisconnected(int n2) {
            }
        });
    }

    public t joinP2PConference(CallType callType, String string) throws EaseMobException {
        XMPPConnection xMPPConnection = EMSessionManager.getInstance().getConnection();
        t t2 = t.a(callType == CallType.video, string);
        AndFilter andFilter = new AndFilter(new PacketIDFilter(t2.getPacketID()), new PacketTypeFilter(IQ.class));
        PacketCollector packetCollector = xMPPConnection.createPacketCollector(andFilter);
        xMPPConnection.sendPacket(t2);
        t t3 = (t)packetCollector.nextResult(6000L);
        packetCollector.cancel();
        if (t3 == null) {
            throw new EaseMobException(-1001, "No response from server.");
        }
        if (t3.getType() == IQ.Type.ERROR) {
            throw new EaseMobException(-998, t3.getError().toString());
        }
        return t3;
    }

    public void removeP2PConference(String string) {
        try {
            XMPPConnection xMPPConnection = EMSessionManager.getInstance().getConnection();
            t t2 = t.a(string);
            xMPPConnection.sendPacket(t2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void checkConnection() throws EMNetworkUnconnectedException {
        XMPPConnection xMPPConnection = EMSessionManager.getInstance().getConnection();
        if (xMPPConnection == null || !xMPPConnection.isConnected()) {
            throw new EMNetworkUnconnectedException("no connection is initialized!");
        }
    }

    private class CallStateChangeListenerDelegate
    implements EMCallStateChangeListener {
        private CallStateChangeListenerDelegate() {
        }

        @Override
        public void onCallStateChanged(EMCallStateChangeListener.CallState callState, EMCallStateChangeListener.CallError callError) {
            EMLog.d(TAG, "onCallStateChanged with callState = " + (Object)((Object)callState) + " callError = " + (Object)((Object)callError));
            if (callState == EMCallStateChangeListener.CallState.ACCEPTED) {
                EMVoiceCallManager.this.callingTimer.cancel();
            }
            if (callState == EMCallStateChangeListener.CallState.DISCONNNECTED) {
                EMVoiceCallManager.this.activeSession = null;
                EMVoiceCallManager.this.callingTimer.cancel();
            }
            if (EMVoiceCallManager.this.stateChangeListener != null) {
                EMVoiceCallManager.this.stateChangeListener.onCallStateChanged(callState, callError);
            }
        }
    }

    public static enum CallType {
        audio,
        video;

    }
}

