/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.chat;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.PowerManager;
import com.easemob.EMConnectionListener;
import com.easemob.analytics.EMCollector;
import com.easemob.b.a;
import com.easemob.chat.EMChat;
import com.easemob.chat.EMChatConfig;
import com.easemob.chat.EMChatManager;
import com.easemob.chat.EMHeartBeatReceiver;
import com.easemob.chat.core.ac;
import com.easemob.util.EMLog;
import com.easemob.util.NetUtils;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smackx.ping.packet.Ping;

public class EMSmartHeartBeat {
    private static final String TAG = "smart ping";
    private static final int MOBILE_INTERVAL = 180000;
    private static final int WIFI_INTERVAL = 120000;
    private static final int PING_PONG_TIMEOUT = 15000;
    private static final int MIN_INTERVAL = 30000;
    private static final int MAX_INTERVAL = 270000;
    private static final int MAX_MIN_INTERVAL_COUNTER = 3;
    private int heartbeatStep = 30000;
    private int failTries = 4;
    private int successedInterval;
    private int currentInterval;
    private boolean dataReceivedDuringInterval = false;
    private long lastSuccessPingpongTime;
    private static final int PING_PONG_CHECK_INTERVAL = 900000;
    private int minIntervalCounter = 3;
    private String heartbeatId;
    private EMHeartBeatReceiver alarmIntentReceiver = null;
    private PendingIntent alarmIntent = null;
    private Context appContext;
    private XMPPConnection connection;
    private EMConnectionListener cnnListener = null;
    private PowerManager.WakeLock wakeLock;
    private Object stateLock = new Object();
    private EMSmartPingState pingState = EMSmartPingState.EMReady;
    ac whitePingPacket = new ac();
    Ping pingPacket = new Ping();
    ExecutorService threadPool = null;
    long lastPacketReceivedTime = 0L;
    private PacketListener pktListener = new PacketListener(){

        @Override
        public void processPacket(Packet packet) {
            EMSmartHeartBeat.this.dataReceivedDuringInterval = true;
            EMSmartHeartBeat.this.lastPacketReceivedTime = System.currentTimeMillis();
        }
    };
    private Runnable heartBeatRunnable = new Runnable(){

        @Override
        public void run() {
            EMLog.d(EMSmartHeartBeat.TAG, "has network connection:" + NetUtils.hasNetwork(EMSmartHeartBeat.this.appContext) + " has data conn:" + NetUtils.hasDataConnection(EMSmartHeartBeat.this.appContext) + " isConnected to easemob server : " + EMChatManager.getInstance().isConnected());
            if (EMSmartHeartBeat.this.hasDataConnection()) {
                if (EMSmartHeartBeat.this.pingState == EMSmartPingState.EMHitted) {
                    if (System.currentTimeMillis() - EMSmartHeartBeat.this.lastSuccessPingpongTime >= (long)(900000 + new Random().nextInt(5000))) {
                        EMLog.d(EMSmartHeartBeat.TAG, "Final candiate hitted, but the interval is bigger than PING_PONG_CHECK_INTERVAL");
                        EMSmartHeartBeat.this.checkPingPong();
                    } else {
                        EMSmartHeartBeat.this.sendPing();
                    }
                } else {
                    EMSmartHeartBeat.this.checkPingPong();
                }
            } else {
                EMLog.d(EMSmartHeartBeat.TAG, "....no connection to server");
            }
            a.d();
            EMSmartHeartBeat.this.scheduleNextAlarm();
        }
    };

    private EMSmartHeartBeat() {
    }

    public static EMSmartHeartBeat create() {
        return new EMSmartHeartBeat();
    }

    public void onInit(XMPPConnection xMPPConnection) {
        this.changeState(EMSmartPingState.EMEvaluating);
        this.threadPool = Executors.newSingleThreadExecutor();
        this.reset();
        this.appContext = EMChat.getInstance().getAppContext();
        this.connection = xMPPConnection;
        xMPPConnection.addPacketListener(this.pktListener, new PacketFilter(){

            @Override
            public boolean accept(Packet packet) {
                if (EMSmartHeartBeat.this.heartbeatId != null && packet.getPacketID() != null) {
                    return !packet.getPacketID().equals(EMSmartHeartBeat.this.heartbeatId);
                }
                return true;
            }
        });
        if (this.cnnListener == null) {
            this.cnnListener = new EMConnectionListener(){

                @Override
                public void onDisconnected(int n2) {
                    EMLog.d(EMSmartHeartBeat.TAG, " onDisconnected ...");
                    EMSmartHeartBeat.this.reset();
                }

                @Override
                public void onConnected() {
                    EMLog.d(EMSmartHeartBeat.TAG, " onConnectred ...");
                    EMSmartHeartBeat.this.scheduleNextAlarm();
                }
            };
        }
        EMChatManager.getInstance().removeConnectionListener(this.cnnListener);
        EMChatManager.getInstance().addConnectionListener(this.cnnListener);
        PowerManager powerManager = (PowerManager)this.appContext.getSystemService("power");
        if (this.wakeLock == null) {
            this.wakeLock = powerManager.newWakeLock(1, "heartbeatlock");
        }
    }

    private void sendPing() {
        EMLog.d(TAG, "send white heartbeat");
        try {
            this.heartbeatId = this.whitePingPacket.getPacketID();
            this.connection.sendPacket(this.whitePingPacket);
        }
        catch (Exception exception) {
            EMLog.e(TAG, exception.toString());
        }
    }

    private void checkPingPong() {
        EMLog.d(TAG, "check pingpong ...");
        boolean bl = false;
        int n2 = 0;
        while (n2 < this.failTries) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                EMLog.e(TAG, "heartbeat thread be interrupt");
                return;
            }
            try {
                if (this.dataReceivedDuringInterval) {
                    return;
                }
                bl = this.sendPingPong();
                if (this.dataReceivedDuringInterval) {
                    return;
                }
                if (bl) {
                    EMLog.d(TAG, "success to send ping pong ... with current heartbeat interval : " + EMCollector.timeToString(this.currentInterval));
                    this.successedInterval = this.currentInterval;
                    this.lastSuccessPingpongTime = System.currentTimeMillis();
                    EMLog.d(TAG, "send ping-pong successed");
                    if (this.pingState == EMSmartPingState.EMHitted) {
                        EMLog.d(TAG, "that's already in the EMHitted state, just return...");
                        return;
                    }
                    if (this.successedInterval == 270000 || this.pingState == EMSmartPingState.EMReevaluating) {
                        if (this.successedInterval == 270000) {
                            EMLog.d(TAG, "Find the best interval, interval is the max interval");
                        }
                        if (this.pingState == EMSmartPingState.EMReevaluating) {
                            EMLog.d(TAG, "success to pingping and current state is EMSmartPingState.EMReevaluating, so use current interval as final interval");
                        }
                        EMLog.d(TAG, "enter the ping state : " + (Object)((Object)this.pingState));
                        this.changeState(EMSmartPingState.EMHitted);
                        return;
                    }
                    this.currentInterval += this.heartbeatStep;
                    if (this.currentInterval < 270000) break;
                    this.currentInterval = 270000;
                    break;
                }
            }
            catch (Exception exception) {
                return;
            }
            ++n2;
        }
        if (!bl) {
            EMLog.d(TAG, "failed to send ping pong ... with current heartbeat interval : " + EMCollector.timeToString(this.currentInterval));
            if (this.hasDataConnection()) {
                if (this.successedInterval != 0) {
                    this.currentInterval = this.successedInterval;
                    if (this.pingState == EMSmartPingState.EMEvaluating || this.pingState == EMSmartPingState.EMHitted) {
                        EMLog.d(TAG, "send ping-pong failed, but has success interval candiate with ping state : " + (Object)((Object)this.pingState) + " enter EMSmartPingState.EMReevaluating");
                        this.changeState(EMSmartPingState.EMReevaluating);
                    }
                    this.successedInterval = 0;
                    EMChatManager.getInstance().forceReconnect();
                } else {
                    if (this.pingState == EMSmartPingState.EMReevaluating) {
                        this.pingState = EMSmartPingState.EMEvaluating;
                    }
                    if (this.currentInterval > 30000) {
                        this.currentInterval -= this.heartbeatStep;
                        if (this.currentInterval <= 30000) {
                            this.currentInterval = 30000;
                        }
                        EMChatManager.getInstance().forceReconnect();
                    } else if (this.minIntervalCounter <= 0) {
                        EMChatManager.getInstance().forceReconnect();
                        this.reset();
                    } else {
                        --this.minIntervalCounter;
                    }
                }
            }
        }
    }

    private boolean hasDataConnection() {
        return NetUtils.hasDataConnection(this.appContext) && EMChatManager.getInstance().isConnected();
    }

    private void releaseWakelock() {
        if (this.wakeLock.isHeld()) {
            this.wakeLock.release();
            EMLog.d(TAG, "released the wake lock");
        }
    }

    private boolean sendPingPong() {
        EMLog.d(TAG, "send ping-pong type heartbeat");
        if (this.connection == null || !this.connection.isConnected()) {
            EMLog.d(TAG, "connection is null or not connected");
            return false;
        }
        PacketCollector packetCollector = this.connection.createPacketCollector(new PacketIDFilter(this.pingPacket.getPacketID()));
        this.heartbeatId = this.pingPacket.getPacketID();
        this.connection.sendPacket(this.pingPacket);
        IQ iQ = (IQ)packetCollector.nextResult(15000L);
        packetCollector.cancel();
        if (iQ == null) {
            EMLog.e(TAG, "no result while send ping-pong");
            return false;
        }
        if (iQ.getError() != null) {
            EMLog.e(TAG, "received a error pong: " + iQ.getError());
            return false;
        }
        return true;
    }

    public void start() {
        if (this.pingState == EMSmartPingState.EMStopped) {
            return;
        }
        if (!EMChatManager.getInstance().isConnected() || !NetUtils.hasNetwork(this.appContext)) {
            if (this.dataReceivedDuringInterval) {
                this.dataReceivedDuringInterval = false;
            }
            this.scheduleNextAlarm();
            return;
        }
        if (this.dataReceivedDuringInterval) {
            this.dataReceivedDuringInterval = false;
            long l2 = System.currentTimeMillis() - this.lastPacketReceivedTime;
            if (l2 - (long)this.currentInterval < 100000L) {
                this.scheduleNextAlarm();
                return;
            }
        }
        EMLog.d(TAG, "post heartbeat runnable");
        this.threadPool.execute(this.heartBeatRunnable);
    }

    public void scheduleNextAlarm() {
        try {
            Long l2;
            EMLog.d(TAG, "schedule next alarm");
            EMLog.d(TAG, "current heartbeat interval : " + EMCollector.timeToString(this.currentInterval) + " smart ping state : " + (Object)((Object)this.pingState));
            this.dataReceivedDuringInterval = false;
            AlarmManager alarmManager = (AlarmManager)this.appContext.getSystemService("alarm");
            if (this.alarmIntent == null) {
                l2 = new Intent("easemob.chat.heatbeat." + EMChatConfig.getInstance().APPKEY);
                this.alarmIntent = PendingIntent.getBroadcast((Context)this.appContext, (int)0, (Intent)l2, (int)0);
            }
            if (this.alarmIntentReceiver == null) {
                this.alarmIntentReceiver = new EMHeartBeatReceiver(this);
                l2 = new IntentFilter("easemob.chat.heatbeat." + EMChatConfig.getInstance().APPKEY);
                this.appContext.registerReceiver((BroadcastReceiver)this.alarmIntentReceiver, (IntentFilter)l2);
            }
            l2 = System.currentTimeMillis() + 180000L;
            if (this.hasDataConnection()) {
                if (this.currentInterval <= 0) {
                    this.currentInterval = this.getDefaultInterval();
                    EMLog.d(TAG, "current heartbeat interval is not set, use default interval : " + EMCollector.timeToString(this.currentInterval));
                }
                l2 = System.currentTimeMillis() + (long)this.currentInterval;
            } else {
                l2 = System.currentTimeMillis() + 180000L;
                EMLog.d(TAG, "is not connected to server, so use idle interval : 3 mins");
            }
            if (Build.VERSION.SDK_INT >= 19) {
                alarmManager.setExact(0, l2.longValue(), this.alarmIntent);
            } else {
                alarmManager.set(0, l2.longValue(), this.alarmIntent);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void stop() {
        block4: {
            EMLog.d(TAG, "stop heart beat timer");
            this.changeState(EMSmartPingState.EMStopped);
            this.threadPool.shutdownNow();
            this.reset();
            this.releaseWakelock();
            if (this.connection != null) {
                this.connection.removePacketListener(this.pktListener);
            }
            if (this.cnnListener != null) {
                EMChatManager.getInstance().removeConnectionListener(this.cnnListener);
            }
            try {
                AlarmManager alarmManager = (AlarmManager)this.appContext.getSystemService("alarm");
                alarmManager.cancel(this.alarmIntent);
                this.appContext.unregisterReceiver((BroadcastReceiver)this.alarmIntentReceiver);
                this.alarmIntentReceiver = null;
            }
            catch (Exception exception) {
                if (exception.getMessage().contains("Receiver not registered")) break block4;
                exception.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeState(EMSmartPingState eMSmartPingState) {
        EMLog.d(TAG, "change smart ping state from : " + (Object)((Object)this.pingState) + " to : " + (Object)((Object)eMSmartPingState));
        Object object = this.stateLock;
        synchronized (object) {
            this.pingState = eMSmartPingState;
        }
    }

    private void reset() {
        EMLog.d(TAG, "reset interval...");
        this.currentInterval = 0;
        this.successedInterval = 0;
        this.dataReceivedDuringInterval = false;
        this.minIntervalCounter = 3;
        this.changeState(EMSmartPingState.EMEvaluating);
    }

    private int getDefaultInterval() {
        int n2 = 0;
        n2 = NetUtils.isWifiConnection(this.appContext) ? 120000 : 180000;
        return n2;
    }

    private static enum EMSmartPingState {
        EMReady,
        EMEvaluating,
        EMReevaluating,
        EMHitted,
        EMStopped;

    }
}

