/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.chat;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.PowerManager;
import android.os.Process;
import android.preference.PreferenceManager;
import android.text.TextUtils;
import com.easemob.EMCallBack;
import com.easemob.analytics.EMLoginCollector;
import com.easemob.analytics.EMTimeTag;
import com.easemob.b.a;
import com.easemob.chat.EMChat;
import com.easemob.chat.EMChatConfig;
import com.easemob.chat.EMChatManager;
import com.easemob.chat.EMContact;
import com.easemob.chat.EMContactManager;
import com.easemob.chat.EMCustomerService;
import com.easemob.chat.EMPushNotificationHelper;
import com.easemob.chat.EMSmartHeartBeat;
import com.easemob.chat.core.EMConnectionManager;
import com.easemob.chat.core.p;
import com.easemob.cloud.EMHttpClient;
import com.easemob.cloud.HttpClientConfig;
import com.easemob.exceptions.EMAuthenticationException;
import com.easemob.exceptions.EMNetworkUnconnectedException;
import com.easemob.exceptions.EaseMobException;
import com.easemob.util.CryptoUtils;
import com.easemob.util.EMLog;
import com.easemob.util.NetUtils;
import com.easemob.util.PathUtil;
import java.io.IOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import org.apache.http.conn.ConnectTimeoutException;
import org.jivesoftware.smack.AccountManager;
import org.jivesoftware.smack.XMPPConnection;
import org.json.JSONException;
import org.json.JSONObject;

class EMSessionManager {
    private static final String TAG = "Session";
    private EMConnectionManager connectionManager = null;
    private Context appContext = null;
    private static final String PREF_KEY_LOGIN_USER = "easemob.chat.loginuser";
    private static final String PREF_KEY_LOGIN_PWD = "easemob.chat.loginpwd";
    public EMContact currentUser = null;
    private static EMSessionManager instance = new EMSessionManager();
    private String lastLoginUser = null;
    private String lastLoginPwd = null;
    EMSmartHeartBeat smartHeartbeat = null;
    private Object loginLock = new Object();

    EMSessionManager() {
    }

    public static synchronized EMSessionManager getInstance(Context context) {
        if (context != null) {
            EMSessionManager.instance.appContext = context;
        }
        return instance;
    }

    public static synchronized EMSessionManager getInstance() {
        if (EMSessionManager.instance.appContext == null) {
            EMSessionManager.instance.appContext = EMChat.getInstance().getAppContext();
        }
        return instance;
    }

    synchronized EMSessionManager onInit() {
        if (this.appContext == null) {
            this.appContext = EMChat.getInstance().getAppContext();
        }
        return this;
    }

    private void initXmppConnection(String string, String string2) {
        if (this.connectionManager != null) {
            try {
                EMLog.d(TAG, "try to disconnect previous connection");
                this.connectionManager.disconnect();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            this.connectionManager = new EMConnectionManager();
        }
        this.connectionManager.onInit(string, string2);
        EMChatManager.getInstance().onNewConnectionCreated(this.connectionManager);
        if (this.smartHeartbeat == null) {
            this.smartHeartbeat = EMSmartHeartBeat.create();
        }
        this.smartHeartbeat.onInit(this.getConnection());
    }

    void checkConnection() throws EaseMobException {
        EMLog.d(TAG, "check connection...");
        if (this.connectionManager == null) {
            throw new EMNetworkUnconnectedException("xmppConnectionManager is null");
        }
        if (this.connectionManager.getConnection() == null) {
            throw new EMNetworkUnconnectedException("connection is null");
        }
        if (!this.connectionManager.isConnected() || !this.connectionManager.getConnection().isAuthenticated()) {
            EMLog.e(TAG, "network unconnected");
            throw new EMNetworkUnconnectedException(-1001, "connection is not connected");
        }
        EMLog.d(TAG, "check connection ok");
    }

    void loadDB() {
        EMChatManager.getInstance().loadDB();
    }

    private synchronized void loginSync(String string, String string2, boolean bl, EMCallBack eMCallBack) {
        EMTimeTag eMTimeTag;
        String string3;
        block52: {
            block51: {
                if (string == null || string2 == null || string.equals("") || string2.equals("")) {
                    if (eMCallBack != null) {
                        eMCallBack.onError(-1005, "the username or password is null or empty!");
                    }
                    return;
                }
                String string4 = this.getLastLoginUser();
                String string5 = this.getLastLoginPwd();
                boolean bl2 = false;
                if (string4 != null && string5 != null) {
                    bl2 = string4.equals(string) && string5.equals(string2);
                }
                EMLog.d(TAG, "loginSync : in process " + Process.myPid());
                string3 = EMContactManager.getBareEidFromUserName(string);
                EMLog.d(TAG, "login with eid:" + string3);
                eMTimeTag = new EMTimeTag();
                eMTimeTag.start();
                if (this.isConnected() && bl2) {
                    EMLog.d(TAG, "resue existing connection manager");
                    this.connectionManager.reuse();
                    EMLog.d(TAG, "already loggedin and conected. skip login");
                    if (eMCallBack != null) {
                        eMCallBack.onSuccess();
                    }
                    return;
                }
                if (EMChatConfig.isDebugTrafficMode()) {
                    a.a();
                }
                this.currentUser = new EMContact(string3, string);
                try {
                    this.loadDB();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    if (eMCallBack == null) break block51;
                    eMCallBack.onError(-1, exception.toString());
                }
            }
            try {
                p.c().a(string, string2);
            }
            catch (JSONException jSONException) {
                if (bl) {
                    if (eMCallBack != null) {
                        eMCallBack.onError(-1000, "Wrong response result was returned from server : " + jSONException.getMessage());
                    }
                    return;
                }
            }
            catch (UnknownHostException unknownHostException) {
                EMLog.e(TAG, "unknow host exception:" + unknownHostException.toString());
                if (bl && !NetUtils.hasNetwork(this.appContext)) {
                    if (eMCallBack != null) {
                        eMCallBack.onError(-1001, "there is not network connction, please check you network");
                    }
                    return;
                }
                if (bl) {
                    if (eMCallBack != null) {
                        eMCallBack.onError(-1002, "can't resolve DNS host");
                    }
                    return;
                }
            }
            catch (NoRouteToHostException noRouteToHostException) {
                EMLog.e(TAG, "NoRouteToHostException:" + noRouteToHostException.toString());
                if (bl) {
                    if (eMCallBack != null) {
                        eMCallBack.onError(-1003, "can not connect to server : " + noRouteToHostException.toString());
                    }
                    return;
                }
            }
            catch (ConnectException connectException) {
                EMLog.e(TAG, "ConnectException:" + connectException.toString());
                if (bl) {
                    if (eMCallBack != null) {
                        eMCallBack.onError(-1003, "can not connect to server : " + connectException.toString());
                    }
                    return;
                }
            }
            catch (SocketException socketException) {
                EMLog.e(TAG, "SocketException:" + socketException.toString());
                if (bl) {
                    if (eMCallBack != null) {
                        eMCallBack.onError(-1003, "can not connect to server : " + socketException.toString());
                    }
                    return;
                }
            }
            catch (SocketTimeoutException socketTimeoutException) {
                EMLog.e(TAG, "SocketTimeoutException:" + socketTimeoutException.toString());
                if (bl) {
                    if (eMCallBack != null) {
                        eMCallBack.onError(-1004, "server response timer out");
                    }
                    return;
                }
            }
            catch (EMAuthenticationException eMAuthenticationException) {
                EMLog.e(TAG, "EMAuthenticationException:" + eMAuthenticationException.toString());
                if (bl) {
                    if (eMCallBack != null) {
                        eMCallBack.onError(-1005, "invalid user or password");
                    }
                    return;
                }
            }
            catch (ConnectTimeoutException connectTimeoutException) {
                EMLog.e(TAG, "ConnectTimeoutException:" + connectTimeoutException.toString());
                if (bl) {
                    if (eMCallBack != null) {
                        eMCallBack.onError(-1004, "connection timer out");
                    }
                    return;
                }
            }
            catch (IOException iOException) {
                EMLog.e(TAG, "IOException:" + iOException.toString());
                if (bl) {
                    if (eMCallBack != null) {
                        eMCallBack.onError(-1007, "IO exception : " + iOException.toString());
                    }
                    return;
                }
            }
            catch (Exception exception) {
                if (exception != null) {
                    EMLog.e(TAG, "Exception:" + exception.toString());
                }
                if (!bl) break block52;
                if (eMCallBack != null) {
                    eMCallBack.onError(-1003, "failed to connect to server \uff1a" + exception.toString());
                }
                return;
            }
        }
        boolean bl3 = false;
        try {
            bl3 = EMPushNotificationHelper.getInstance().checkAvailablePushService();
            if (p.c().u() == EMChatConfig.EMSDKMode.EMHelpDeskMode) {
                EMCustomerService.getInstance().scheduleLogout(EMCustomerService.EMScheduleLogoutReason.EMLogin);
            }
            this.appContext = EMChat.getInstance().getAppContext();
            this.initXmppConnection(string3, string2);
            PathUtil.getInstance().initDirs(EMChatConfig.getInstance().APPKEY, string, this.appContext);
            this.connectionManager.setChatTag(eMTimeTag);
            this.connectionManager.connectSync(bl);
            String string6 = this.getLastLoginUser();
            if (!string.equals(string6)) {
                this.setLastLoginUser(string);
                this.setLastLoginPwd(string2);
            }
            EMContactManager.getInstance().init(this.appContext, this.connectionManager);
        }
        catch (EMAuthenticationException eMAuthenticationException) {
            eMAuthenticationException.printStackTrace();
            if (eMCallBack != null) {
                EMLog.e(TAG, "EMAuthenticationException failed: " + eMAuthenticationException.toString());
                eMCallBack.onError(-1005, "invalid password or username");
            }
            return;
        }
        catch (Exception exception) {
            if (exception != null) {
                exception.printStackTrace();
                EMLog.e(TAG, "xmppConnectionManager.connectSync() failed: " + exception.getMessage());
            }
            if (eMCallBack != null) {
                eMCallBack.onError(-1003, exception.getMessage());
            }
            return;
        }
        EMLog.i(TAG, "EaseMob Server connected.");
        EMLoginCollector.collectLoginTime(eMTimeTag.stop());
        if (bl3) {
            EMPushNotificationHelper.getInstance().sendDeviceTokenToServer();
        }
        if (eMCallBack != null) {
            eMCallBack.onSuccess();
        }
    }

    void login(final String string, final String string2, final boolean bl, final EMCallBack eMCallBack) {
        EMChatManager.getInstance().initDB(string);
        Thread thread = new Thread(){

            @Override
            public void run() {
                EMSessionManager.this.loginSync(string, string2, bl, eMCallBack);
            }
        };
        thread.setPriority(9);
        thread.start();
    }

    public PowerManager.WakeLock getWakeLock() {
        return this.connectionManager.getWakeLock();
    }

    public void logout() {
        Thread thread = new Thread(){

            @Override
            public void run() {
                EMLog.d(EMSessionManager.TAG, "Session logout");
                EMSessionManager.this.syncLogout();
            }
        };
        thread.setPriority(9);
        thread.start();
    }

    public void syncLogout() {
        EMLog.d(TAG, "Session logout");
        if (this.smartHeartbeat != null) {
            this.smartHeartbeat.stop();
        }
        try {
            this.connectionManager.disconnect();
            if (p.c().B()) {
                p.c().A();
            }
        }
        catch (Exception exception) {
            EMLog.d(TAG, exception.toString());
        }
    }

    String getLastLoginUser() {
        if (this.lastLoginUser == null) {
            SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)this.appContext);
            this.lastLoginUser = sharedPreferences.getString(PREF_KEY_LOGIN_USER, "");
        }
        return this.lastLoginUser;
    }

    void setLastLoginUser(String string) {
        if (string == null) {
            return;
        }
        this.lastLoginUser = string;
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)this.appContext);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString(PREF_KEY_LOGIN_USER, string);
        editor.commit();
    }

    String getLastLoginPwd() {
        if (this.lastLoginPwd == null) {
            SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)this.appContext);
            String string = sharedPreferences.getString(PREF_KEY_LOGIN_PWD, "");
            if (string.equals("")) {
                this.lastLoginPwd = "";
                return this.lastLoginPwd;
            }
            try {
                CryptoUtils cryptoUtils = EMChatManager.getInstance().getCryptoUtils();
                this.lastLoginPwd = cryptoUtils.decryptBase64String(string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return this.lastLoginPwd;
    }

    void clearLastLoginUser() {
        try {
            this.lastLoginUser = "";
            SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)this.appContext);
            SharedPreferences.Editor editor = sharedPreferences.edit();
            editor.putString(PREF_KEY_LOGIN_USER, this.lastLoginUser);
            editor.commit();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void clearLastLoginPwd() {
        try {
            this.lastLoginPwd = "";
            SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)this.appContext);
            SharedPreferences.Editor editor = sharedPreferences.edit();
            editor.putString(PREF_KEY_LOGIN_PWD, this.lastLoginPwd);
            editor.commit();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void setLastLoginPwd(String string) {
        if (string == null) {
            return;
        }
        this.lastLoginPwd = string;
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)this.appContext);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        try {
            CryptoUtils cryptoUtils = EMChatManager.getInstance().getCryptoUtils();
            String string2 = cryptoUtils.encryptBase64String(string);
            editor.putString(PREF_KEY_LOGIN_PWD, string2);
            editor.commit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean isConnected() {
        if (this.connectionManager == null) {
            return false;
        }
        return this.connectionManager.isConnected() & this.connectionManager.isAuthentificated();
    }

    XMPPConnection getConnection() {
        return this.connectionManager != null ? this.connectionManager.getConnection() : null;
    }

    public String getLoginUserName() {
        return this.currentUser.username;
    }

    void changePasswordXMPP(String string) throws EaseMobException {
        if (this.connectionManager != null && this.connectionManager.isConnected() && this.connectionManager.isAuthentificated()) {
            AccountManager accountManager = this.connectionManager.getConnection().getAccountManager();
            try {
                accountManager.changePassword(string);
            }
            catch (Exception exception) {
                EMLog.e(TAG, "changePasswordInBackground XMPP failed: usr:" + this.getLoginUserName() + ", newPassword:" + string + ", " + exception.toString());
                throw new EaseMobException(exception.getMessage());
            }
        } else {
            EMLog.e(TAG, "changePasswordInBackground failed. xmppConnectionManager is null. ");
            throw new EMNetworkUnconnectedException();
        }
    }

    public void createAccountXMPP(String string, String string2) throws EaseMobException {
        try {
            if (this.connectionManager != null) {
                this.connectionManager.disconnect();
            } else {
                this.connectionManager = new EMConnectionManager();
            }
            this.connectionManager.onInit();
            this.connectionManager.connect();
            AccountManager accountManager = this.connectionManager.getConnection().getAccountManager();
            accountManager.createAccount(string, string2);
            this.connectionManager.disconnect();
            EMLog.d(TAG, "created xmpp user:" + string);
        }
        catch (Exception exception) {
            if (this.connectionManager != null) {
                this.connectionManager.disconnect();
            }
            exception.printStackTrace();
            throw new EaseMobException(exception.toString());
        }
    }

    void forceReconnect() {
        if (this.connectionManager != null) {
            this.connectionManager.forceReconnect();
        }
    }

    public void createAccountRest(String string, String string2) throws EaseMobException {
        JSONObject jSONObject;
        Object object;
        String string3;
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new EaseMobException("username is empty");
        }
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new EaseMobException("password is empty");
        }
        if (TextUtils.isEmpty((CharSequence)EMChatConfig.getInstance().APPKEY)) {
            throw new EaseMobException("appkey is not set");
        }
        String string4 = null;
        try {
            string3 = String.valueOf(HttpClientConfig.getBaseUrlByAppKey()) + "/users/";
            object = new JSONObject();
            object.put("username", (Object)string);
            object.put("password", (Object)string2);
            jSONObject = EMHttpClient.getInstance().sendRequest(string3, null, object.toString(), EMHttpClient.POST);
            string4 = (String)jSONObject.second;
        }
        catch (JSONException jSONException) {
            throw new EaseMobException(-1000, jSONException.getMessage());
        }
        catch (Exception exception) {
            if (exception instanceof EaseMobException) {
                throw new EaseMobException(((EaseMobException)exception).getErrorCode(), exception.getMessage());
            }
            throw new EaseMobException(-998, exception.getMessage());
        }
        if (TextUtils.isEmpty((CharSequence)string4)) {
            throw new EaseMobException(-1007, "response result is null");
        }
        if (string4.contains("error")) {
            string3 = "";
            object = "";
            try {
                jSONObject = new JSONObject(string4);
                string3 = jSONObject.getString("error");
                object = jSONObject.getString("error_description");
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
                throw new EaseMobException(-1000, jSONException.getMessage());
            }
            if (string3.equalsIgnoreCase("duplicate_unique_property_exists")) {
                throw new EaseMobException(-1015, "conflict");
            }
            if (string3.equalsIgnoreCase("unauthorized")) {
                throw new EaseMobException(-1021, "unauthorized:" + (String)object);
            }
            throw new EaseMobException(-999, (String)object);
        }
    }
}

