/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.chat;

import com.easemob.chat.EMCallStateChangeListener;
import com.easemob.chat.EMVoiceCallSession;
import com.easemob.util.EMLog;
import com.xonami.javaBells.JinglePacketHandler;
import com.xonami.javaBells.JingleSession;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.JingleAction;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.JingleIQ;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;

class EMSessionHandler
extends JinglePacketHandler {
    protected EMVoiceCallSession activeSession = null;
    private static final String TAG = EMSessionHandler.class.getSimpleName();

    @Override
    public void processPacket(Packet packet) {
        JingleIQ jingleIQ = (JingleIQ)packet;
        if (jingleIQ.getType() == IQ.Type.ERROR) {
            EMLog.e(TAG, "error is received with error code = " + jingleIQ.getError().getCode());
            if (jingleIQ.getError().getCode() == 503 && this.activeSession != null) {
                this.activeSession.changeState(EMCallStateChangeListener.CallState.DISCONNNECTED, EMCallStateChangeListener.CallError.ERROR_INAVAILABLE);
                this.activeSession.closeSession(null);
            }
            return;
        }
        if (this.isGeneralJiq(jingleIQ)) {
            super.processPacket(packet);
            return;
        }
        JingleSession jingleSession = (JingleSession)this.jingleSessions.get(jingleIQ.getSID());
        if (this.jiqAccepted(jingleIQ)) {
            if (jingleIQ.getAction() == JingleAction.CALL_ACCEPT) {
                if (jingleSession == null) {
                    return;
                }
                EMVoiceCallSession eMVoiceCallSession = (EMVoiceCallSession)jingleSession;
                eMVoiceCallSession.handleCallAccept(jingleIQ);
            } else if (jingleIQ.getAction() == JingleAction.CALLER_RELAY) {
                if (jingleSession == null) {
                    return;
                }
                EMVoiceCallSession eMVoiceCallSession = (EMVoiceCallSession)jingleSession;
                eMVoiceCallSession.handleCallerRelay(jingleIQ);
            } else {
                super.processPacket(packet);
            }
        }
    }

    EMVoiceCallSession getActiveSession() {
        return this.activeSession;
    }

    void setActiveSession(EMVoiceCallSession eMVoiceCallSession) {
        this.activeSession = eMVoiceCallSession;
    }

    EMSessionHandler(XMPPConnection xMPPConnection) {
        super(xMPPConnection);
    }

    protected boolean isGeneralJiq(JingleIQ jingleIQ) {
        JingleAction jingleAction = jingleIQ.getAction();
        return jingleAction == JingleAction.CONTENT_ADD || jingleAction == JingleAction.CONTENT_MODIFY || jingleAction == JingleAction.CONTENT_ACCEPT || jingleAction == JingleAction.CONTENT_REJECT || jingleAction == JingleAction.CONTENT_REMOVE || jingleAction == JingleAction.DESCRIPTION_INFO || jingleAction == JingleAction.SECURITY_INFO || jingleAction == JingleAction.SESSION_INFO || jingleAction == JingleAction.SESSION_TERMINATE;
    }

    protected boolean jiqAccepted(JingleIQ jingleIQ) {
        return false;
    }
}

