/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.chat;

import android.content.ContentValues;
import android.graphics.BitmapFactory;
import android.text.TextUtils;
import com.easemob.EMCallBack;
import com.easemob.analytics.EMMessageCollector;
import com.easemob.analytics.EMTimeTag;
import com.easemob.chat.EMChat;
import com.easemob.chat.EMChatManager;
import com.easemob.chat.EMChatOptions;
import com.easemob.chat.EMCloudOperationCallback;
import com.easemob.chat.EMContactManager;
import com.easemob.chat.EMEncryptUtils;
import com.easemob.chat.EMMessage;
import com.easemob.chat.EMMultiUserChatManager;
import com.easemob.chat.FileMessageBody;
import com.easemob.chat.ImageMessageBody;
import com.easemob.chat.MessageEncoder;
import com.easemob.chat.VideoMessageBody;
import com.easemob.chat.core.i;
import com.easemob.chat.core.k;
import com.easemob.chat.core.p;
import com.easemob.chat.core.x;
import com.easemob.cloud.EMHttpClient;
import com.easemob.util.EMLog;
import com.easemob.util.ImageUtils;
import com.easemob.util.PerfUtils;
import java.io.File;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.json.JSONObject;

class EMSendMessageRunnable
implements Runnable {
    private static final String TAG = "sender";
    private static final String PERF = "perf";
    private Chat chat;
    private MultiUserChat muc;
    private EMMessage msg;
    private EMCallBack callback;
    private static final int WAIT_TIME_OUT = 40;
    static Hashtable<String, Object> sendLocks;
    static Hashtable<String, Object> errorMsgWaitLocks;
    private Object mutex = new Object();
    private Object errorWaitLock = new Object();
    private static final int WAIT_SEND_TIME_OUT = 60;
    static Hashtable<String, Object> sendMsgLocks;
    private Object sendMutex = new Object();
    private String groupId;
    private boolean connectedBeforeSend = true;
    private int numberOfRetried = 3;
    private static long lastForceReconnectTime;
    private static ConcurrentLinkedQueue<EMSendMessageRunnable> pendingMsgQueue;
    private static ExecutorService sendThreadPool;
    EMTimeTag timeTag = new EMTimeTag();

    static {
        errorMsgWaitLocks = new Hashtable();
        lastForceReconnectTime = 0L;
        pendingMsgQueue = new ConcurrentLinkedQueue();
        sendThreadPool = Executors.newFixedThreadPool(3);
    }

    public EMSendMessageRunnable(Chat chat, EMMessage eMMessage, EMCallBack eMCallBack) {
        this.chat = chat;
        this.msg = eMMessage;
        this.callback = eMCallBack;
    }

    public EMSendMessageRunnable(MultiUserChat multiUserChat, EMMessage eMMessage, EMCallBack eMCallBack) {
        this.muc = multiUserChat;
        this.msg = eMMessage;
        this.callback = eMCallBack;
    }

    EMSendMessageRunnable(String string, EMMessage eMMessage, EMCallBack eMCallBack) {
        this.groupId = string;
        this.msg = eMMessage;
        this.callback = eMCallBack;
    }

    static synchronized void addSendLock(String string, Object object) {
        if (sendLocks == null) {
            sendLocks = new Hashtable();
        }
        sendLocks.put(string, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized void notifySendLock(String string) {
        if (sendLocks == null) {
            return;
        }
        Object object = sendLocks.remove(string);
        if (object != null) {
            Object object2 = object;
            synchronized (object2) {
                object.notify();
            }
        }
    }

    static void addErrorMsgWaitLock(String string, Object object) {
        errorMsgWaitLocks.put(string, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean notifyErrorMsgWaitLock(String string) {
        Object object = errorMsgWaitLocks.remove(string);
        if (object != null) {
            Object object2 = object;
            synchronized (object2) {
                object.notify();
            }
            return true;
        }
        return false;
    }

    static synchronized void flushPendingQueue() {
        EMLog.d(TAG, "start flush Pending Queue");
        EMSendMessageRunnable eMSendMessageRunnable = pendingMsgQueue.poll();
        while (eMSendMessageRunnable != null) {
            EMLog.d(TAG, "resend msg : " + eMSendMessageRunnable.msg.getMsgId());
            sendThreadPool.submit(eMSendMessageRunnable);
            eMSendMessageRunnable = pendingMsgQueue.poll();
        }
    }

    @Override
    public void run() {
        this.checkConnection();
        if (this.msg.getChatType() != EMMessage.ChatType.Chat && this.muc == null && this.groupId != null) {
            String string = EMContactManager.getEidFromGroupId(this.groupId);
            try {
                MultiUserChat multiUserChat;
                this.muc = multiUserChat = EMMultiUserChatManager.getInstance().getMUCWithoutJoin(string, this.msg.getChatType());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.msg.status = EMMessage.Status.INPROGRESS;
        this.timeTag.start();
        switch (this.msg.type) {
            case TXT: 
            case LOCATION: 
            case CMD: {
                this.sendMessageXmpp(this.msg);
                break;
            }
            case IMAGE: {
                this.sendImageMessage(this.msg, this.callback);
                break;
            }
            case VOICE: {
                this.sendFileMessage(this.msg, this.callback);
                break;
            }
            case FILE: {
                this.sendFileMessage(this.msg, this.callback);
                break;
            }
            case VIDEO: {
                this.sendVideoMessage(this.msg, this.callback);
                break;
            }
            default: {
                EMLog.e(TAG, "unsupport msg type, need to check:" + (Object)((Object)this.msg.type));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMessageXmpp(EMMessage eMMessage) {
        block32: {
            try {
                Object object;
                String string = MessageEncoder.getJSONMsg(eMMessage, false);
                EMLog.d(TAG, "try to send msg to:" + eMMessage.to + " msg:" + string);
                Message message = new Message();
                message.setPacketID(eMMessage.getMsgId());
                EMChatOptions eMChatOptions = EMChatManager.getInstance().getChatOptions();
                if (eMChatOptions.getUseEncryption()) {
                    string = EMEncryptUtils.encryptMessage(string, eMMessage.getTo());
                    message.addExtension(new k());
                }
                message.setBody(string);
                if (eMChatOptions.getRequireServerAck()) {
                    EMSendMessageRunnable.addSendLock(message.getPacketID(), this.mutex);
                }
                this.connectedBeforeSend = EMChatManager.getInstance().isConnected();
                if (eMMessage.getChatType() == EMMessage.ChatType.GroupChat || eMMessage.getChatType() == EMMessage.ChatType.ChatRoom) {
                    message.setType(Message.Type.groupchat);
                    message.setTo(this.muc.getRoom());
                    if (eMMessage.getChatType() == EMMessage.ChatType.ChatRoom) {
                        message.addExtension(new x());
                    }
                    EMLog.d(TAG, "send message to muc:" + this.muc.getRoom());
                    this.muc.sendMessage(message);
                } else {
                    this.chat.sendMessage(message);
                }
                if (eMChatOptions.getRequireServerAck()) {
                    EMLog.d(TAG, "wait for server ack...");
                    object = this.mutex;
                    synchronized (object) {
                        if (sendLocks.containsKey(message.getPacketID())) {
                            this.mutex.wait(40000L);
                        }
                    }
                    EMLog.d(TAG, "exit from wait");
                    if (sendLocks.remove(message.getPacketID()) != null) {
                        EMLog.e(TAG, "did not receive ack from server for msg:" + message.getPacketID());
                        if (this.connectedBeforeSend && EMChatManager.getInstance().isConnected()) {
                            --this.numberOfRetried;
                            if (this.numberOfRetried <= 0) {
                                eMMessage.status = EMMessage.Status.FAIL;
                                if (eMMessage.getType() != EMMessage.Type.CMD) {
                                    this.updateMsgState(eMMessage);
                                }
                                if (this.callback != null) {
                                    this.callback.onError(-2, "no response from server");
                                }
                                return;
                            }
                            pendingMsgQueue.offer(this);
                            EMLog.d(TAG, "add new msg to pending msg queue : " + eMMessage.getMsgId());
                            if (lastForceReconnectTime == 0L || System.currentTimeMillis() - lastForceReconnectTime > 30000L) {
                                lastForceReconnectTime = System.currentTimeMillis();
                                EMChatManager.getInstance().forceReconnect();
                            } else if (EMChatManager.getInstance().isConnected()) {
                                EMSendMessageRunnable.flushPendingQueue();
                            }
                        } else {
                            eMMessage.status = EMMessage.Status.FAIL;
                            if (eMMessage.getType() != EMMessage.Type.CMD) {
                                this.updateMsgState(eMMessage);
                            }
                            EMMessageCollector.collectSendMsgTime(this.timeTag.stop(), eMMessage);
                            if (this.callback != null) {
                                this.callback.onError(-2, "no response from server");
                            }
                        }
                        return;
                    }
                }
                EMSendMessageRunnable.addErrorMsgWaitLock(eMMessage.getMsgId(), this.errorWaitLock);
                object = this.errorWaitLock;
                synchronized (object) {
                    this.errorWaitLock.wait(50L);
                    errorMsgWaitLocks.remove(eMMessage.getMsgId());
                }
                if (eMMessage.status == EMMessage.Status.FAIL) {
                    EMLog.d(TAG, "server send the msg error : " + eMMessage.getError());
                    EMMessageCollector.collectSendMsgTime(this.timeTag.stop(), eMMessage);
                    if (this.callback != null) {
                        int n2 = -2;
                        if (eMMessage.getError() != 0) {
                            n2 = eMMessage.getError();
                        }
                        this.callback.onError(n2, "send message fail");
                    }
                    return;
                }
                eMMessage.status = EMMessage.Status.SUCCESS;
                if (eMMessage.getType() != EMMessage.Type.CMD) {
                    this.updateMsgState(eMMessage);
                }
                EMMessageCollector.collectSendMsgTime(this.timeTag.stop(), eMMessage);
                if (this.callback != null) {
                    this.callback.onSuccess();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (eMMessage.getType() != EMMessage.Type.CMD) {
                    eMMessage.status = EMMessage.Status.FAIL;
                }
                this.updateMsgState(eMMessage);
                if (this.callback == null) break block32;
                this.callback.onError(-2, exception.toString());
            }
        }
    }

    private void sendImageMessage(final EMMessage eMMessage, final EMCallBack eMCallBack) {
        File file = null;
        String string = null;
        final ImageMessageBody imageMessageBody = (ImageMessageBody)eMMessage.body;
        string = imageMessageBody.localUrl;
        if (string != null && !(file = new File(string)).exists()) {
            string = this.getThumbnailImagePath(string);
            file = new File(string);
        }
        if (file == null || !file.exists()) {
            if (eMCallBack != null) {
                eMCallBack.onError(-3, "file doesn't exist");
            }
            return;
        }
        boolean bl = false;
        if (!imageMessageBody.isSendOriginalImage()) {
            String string2 = ImageUtils.getScaledImage(EMChat.getInstance().getAppContext(), string);
            if (!string2.equals(string)) {
                EMLog.d(TAG, "send scaled image:" + string2);
                bl = true;
                file = new File(string2);
                long l2 = new File(string).length();
                long l3 = file.length();
                EMLog.d(PERF, "original image size:" + l2 + " scaled image size:" + l3 + " ratio:" + (int)(l3 / l2) + "%");
            }
            string = string2;
        }
        final long l4 = file.length();
        EMLog.d(TAG, "start to send file:" + string + " size:" + l4);
        final long l5 = System.currentTimeMillis();
        BitmapFactory.Options options = ImageUtils.getBitmapOptions(string);
        int n2 = options.outWidth;
        int n3 = options.outHeight;
        imageMessageBody.width = n2;
        imageMessageBody.height = n3;
        final String string3 = p.c().K();
        EMLog.d(TAG, "remote file path:" + string3);
        final boolean bl2 = bl;
        final File file2 = file;
        EMChatOptions eMChatOptions = EMChatManager.getInstance().getChatOptions();
        if (eMChatOptions.getUseEncryption()) {
            string = EMEncryptUtils.encryptFile(string, eMMessage.getTo());
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("restrict-access", "true");
        String string4 = EMChatManager.getInstance().getAccessToken();
        if (TextUtils.isEmpty((CharSequence)string4)) {
            eMMessage.status = EMMessage.Status.FAIL;
            this.updateMsgState(eMMessage);
            if (eMCallBack != null) {
                eMCallBack.onError(-2, "unauthorized token is null");
            }
            return;
        }
        hashMap.put("Authorization", "Bearer " + string4);
        EMHttpClient.getInstance().uploadFile(string, string3, hashMap, new EMCloudOperationCallback(){

            @Override
            public void onProgress(int n2) {
                eMMessage.progress = n2;
                if (n2 == 100) {
                    long l2 = System.currentTimeMillis() - l5;
                    EMLog.d(EMSendMessageRunnable.PERF, "upload " + n2 + "% file size:" + l4 + "(bytes) time:" + l2 + "(ms) speed:" + (int)(l4 / l2) + "(byte/ms)");
                }
                if (eMCallBack != null) {
                    eMCallBack.onProgress(n2, null);
                    EMLog.d(EMSendMessageRunnable.TAG, "sendfile progress:" + n2);
                }
            }

            @Override
            public void onError(String string) {
                EMLog.d(EMSendMessageRunnable.TAG, "upload error:" + string);
                if (bl2) {
                    file2.delete();
                }
                eMMessage.status = EMMessage.Status.FAIL;
                EMSendMessageRunnable.this.updateMsgState(eMMessage);
                if (eMCallBack != null) {
                    eMCallBack.onProgress(100, null);
                    eMCallBack.onError(-2, string);
                }
            }

            @Override
            public void onSuccess(String string) {
                block12: {
                    Object object;
                    Object object2;
                    String string2 = "";
                    String string32 = "";
                    try {
                        object2 = new JSONObject(string);
                        object = object2.getJSONArray("entities").getJSONObject(0);
                        string2 = object.getString("uuid");
                        if (object.has("share-secret")) {
                            string32 = object.getString("share-secret");
                        }
                    }
                    catch (Exception exception) {
                        EMLog.e("sendImageMessage", "json parse exception remotefilepath:" + string3);
                    }
                    try {
                        object2 = "";
                        object = "";
                        String string4 = "";
                        EMChatOptions eMChatOptions = EMChatManager.getInstance().getChatOptions();
                        if (eMChatOptions.getUseEncryption()) {
                            EMLog.d(EMSendMessageRunnable.TAG, "start to upload encrypted thumbnail");
                            Map map = EMSendMessageRunnable.this.uploadEncryptedThumbnailImage(file2, eMMessage);
                            object2 = (String)map.get("uuid");
                            object = (String)map.get("share-secret");
                            string4 = String.valueOf(p.c().K()) + (String)object2;
                            EMLog.d(EMSendMessageRunnable.TAG, "encryptd thumbnail uploaded to:" + string4);
                            if (TextUtils.isEmpty((CharSequence)object2)) {
                                if (eMCallBack != null) {
                                    EMLog.e(EMSendMessageRunnable.TAG, "upload thumb uuid is null");
                                    eMCallBack.onError(-2, "upload file fail ");
                                }
                                return;
                            }
                        }
                        long l2 = System.currentTimeMillis() - l5;
                        EMLog.d(EMSendMessageRunnable.PERF, "uploaded file size:" + l4 + "(bytes) time:" + l2 + "(ms) speed:" + (int)(l4 / l2) + "(byte/ms)");
                        if (TextUtils.isEmpty((CharSequence)string2)) {
                            if (eMCallBack != null) {
                                eMCallBack.onError(-2, "upload file fail ");
                            }
                        } else {
                            String string5 = String.valueOf(p.c().K()) + string2;
                            string5 = string5.replaceAll("#", "%23");
                            string4 = string4.replaceAll("#", "%23");
                            imageMessageBody.remoteUrl = string5;
                            imageMessageBody.thumbnailUrl = TextUtils.isEmpty((CharSequence)string4) ? string5 : string4;
                            imageMessageBody.secret = string32;
                            imageMessageBody.thumbnailSecret = object;
                            EMSendMessageRunnable.this.sendMessageXmpp(eMMessage);
                            EMLog.d(EMSendMessageRunnable.TAG, "sent msg successfully:" + eMMessage.toString());
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        if (eMCallBack == null) break block12;
                        eMCallBack.onProgress(100, null);
                        eMCallBack.onError(-2, exception.toString());
                    }
                }
                if (bl2) {
                    file2.delete();
                }
            }
        });
    }

    private void sendVideoMessage(final EMMessage eMMessage, final EMCallBack eMCallBack) {
        String string = null;
        final VideoMessageBody videoMessageBody = (VideoMessageBody)eMMessage.body;
        string = videoMessageBody.localUrl;
        final String string2 = videoMessageBody.localThumb;
        File file = new File(string);
        if (string == null || !file.exists()) {
            if (eMCallBack != null) {
                eMCallBack.onError(-3, "video file doesn't exist");
            }
            return;
        }
        if (string2 == null || !new File(string2).exists()) {
            if (eMCallBack != null) {
                eMCallBack.onError(-3, "video thumb file doesn't exist");
            }
            return;
        }
        final String string3 = p.c().K();
        EMLog.d(TAG, "remote file path:" + string3);
        EMChatOptions eMChatOptions = EMChatManager.getInstance().getChatOptions();
        if (eMChatOptions.getUseEncryption()) {
            string = EMEncryptUtils.encryptFile(string, eMMessage.getTo());
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("restrict-access", "true");
        String string4 = EMChatManager.getInstance().getAccessToken();
        if (TextUtils.isEmpty((CharSequence)string4)) {
            eMMessage.status = EMMessage.Status.FAIL;
            this.updateMsgState(eMMessage);
            if (eMCallBack != null) {
                eMCallBack.onError(-2, "unauthorized token is null");
            }
            return;
        }
        hashMap.put("Authorization", "Bearer " + string4);
        EMHttpClient.getInstance().uploadFile(string, string3, hashMap, new EMCloudOperationCallback(){

            @Override
            public void onSuccess(String string) {
                block11: {
                    Object object;
                    Object object2;
                    String string22 = "";
                    String string32 = "";
                    try {
                        object2 = new JSONObject(string);
                        object = object2.getJSONArray("entities").getJSONObject(0);
                        string22 = object.getString("uuid");
                        if (object.has("share-secret")) {
                            string32 = object.getString("share-secret");
                        }
                    }
                    catch (Exception exception) {
                        EMLog.e(EMSendMessageRunnable.TAG, "json parse exception remotefilePath:" + string3);
                    }
                    try {
                        object2 = "";
                        object = "";
                        String string4 = "";
                        EMLog.d(EMSendMessageRunnable.TAG, "start to upload encrypted thumbnail");
                        Map map = EMSendMessageRunnable.this.uploadEncryptedThumbnailImage(new File(string2), eMMessage);
                        object2 = (String)map.get("uuid");
                        object = (String)map.get("share-secret");
                        string4 = String.valueOf(p.c().K()) + (String)object2;
                        EMLog.d(EMSendMessageRunnable.TAG, "thumbail uploaded to:" + string4);
                        if (TextUtils.isEmpty((CharSequence)string22)) {
                            if (eMCallBack != null) {
                                eMCallBack.onProgress(100, null);
                                eMCallBack.onError(-2, "upload file fail");
                            }
                        } else if (TextUtils.isEmpty((CharSequence)object2)) {
                            if (eMCallBack != null) {
                                eMCallBack.onProgress(100, null);
                                eMCallBack.onError(-2, "upload file fail");
                            }
                        } else {
                            String string5 = String.valueOf(p.c().K()) + string22;
                            string5 = string5.replaceAll("#", "%23");
                            string4 = string4.replaceAll("#", "%23");
                            videoMessageBody.remoteUrl = string5;
                            videoMessageBody.thumbnailUrl = TextUtils.isEmpty((CharSequence)string4) ? string5 : string4;
                            videoMessageBody.secret = string32;
                            videoMessageBody.thumbnailSecret = object;
                            EMSendMessageRunnable.this.sendMessageXmpp(eMMessage);
                            EMLog.d(EMSendMessageRunnable.TAG, "sent msg sucessfully:" + eMMessage.toString());
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        if (eMCallBack == null) break block11;
                        eMCallBack.onProgress(100, null);
                        eMCallBack.onError(-2, exception.getMessage());
                    }
                }
            }

            @Override
            public void onProgress(int n2) {
                eMMessage.progress = n2;
                if (eMCallBack != null) {
                    eMCallBack.onProgress(n2, null);
                }
            }

            @Override
            public void onError(String string) {
                EMLog.d(EMSendMessageRunnable.TAG, "upload error:" + string);
                eMMessage.status = EMMessage.Status.FAIL;
                EMSendMessageRunnable.this.updateMsgState(eMMessage);
                if (eMCallBack != null) {
                    eMCallBack.onProgress(100, null);
                    eMCallBack.onError(-2, string);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> uploadEncryptedThumbnailImage(File file, EMMessage eMMessage) {
        final HashMap<String, String> hashMap = new HashMap<String, String>();
        int n2 = 100;
        String string = ImageUtils.getThumbnailImage(file.getAbsolutePath(), n2);
        EMChatOptions eMChatOptions = EMChatManager.getInstance().getChatOptions();
        if (eMChatOptions.getUseEncryption()) {
            string = EMEncryptUtils.encryptFile(string, eMMessage.getTo());
        }
        String string2 = p.c().K();
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        hashMap2.put("restrict-access", "true");
        String string3 = EMChatManager.getInstance().getAccessToken();
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            hashMap2.put("Authorization", "Bearer " + string3);
        }
        final Object object = new Object();
        EMHttpClient.getInstance().uploadFile(string, string2, hashMap2, new EMCloudOperationCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSuccess(String string) {
                Object object2;
                EMLog.d(EMSendMessageRunnable.TAG, "encrypted thumbnail uploaded");
                String string2 = "";
                String string3 = "";
                try {
                    object2 = new JSONObject(string);
                    JSONObject jSONObject = object2.getJSONArray("entities").getJSONObject(0);
                    string2 = jSONObject.getString("uuid");
                    if (jSONObject.has("share-secret")) {
                        string3 = jSONObject.getString("share-secret");
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                hashMap.put("uuid", string2);
                hashMap.put("share-secret", string3);
                object2 = object;
                synchronized (object2) {
                    object.notify();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onError(String string) {
                EMLog.e(EMSendMessageRunnable.TAG, "encrypted thumbnail upload error:" + string);
                Object object2 = object;
                synchronized (object2) {
                    object.notify();
                }
            }

            @Override
            public void onProgress(int n2) {
            }
        });
        Object object2 = object;
        synchronized (object2) {
            try {
                object.wait(60000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return hashMap;
    }

    private void sendFileMessage(final EMMessage eMMessage, final EMCallBack eMCallBack) {
        File file = null;
        String string = null;
        final FileMessageBody fileMessageBody = (FileMessageBody)eMMessage.body;
        string = fileMessageBody.localUrl;
        if (string != null) {
            file = new File(string);
        }
        if (file == null || !file.exists()) {
            if (eMCallBack != null) {
                eMCallBack.onError(-3, "file doesn't exist");
            }
            return;
        }
        EMChatOptions eMChatOptions = EMChatManager.getInstance().getChatOptions();
        if (eMChatOptions.getUseEncryption()) {
            string = EMEncryptUtils.encryptFile(string, eMMessage.getTo());
        }
        final long l2 = file.length();
        EMLog.d(TAG, "start to send file:" + string + " size:" + l2);
        final long l3 = System.currentTimeMillis();
        final String string2 = p.c().K();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("restrict-access", "true");
        String string3 = EMChatManager.getInstance().getAccessToken();
        if (TextUtils.isEmpty((CharSequence)string3)) {
            eMMessage.status = EMMessage.Status.FAIL;
            this.updateMsgState(eMMessage);
            if (eMCallBack != null) {
                eMCallBack.onError(-2, "unauthorized token is null");
            }
            return;
        }
        hashMap.put("Authorization", "Bearer " + string3);
        EMHttpClient.getInstance().uploadFile(string, string2, hashMap, new EMCloudOperationCallback(){

            @Override
            public void onProgress(int n2) {
                eMMessage.progress = n2;
                if (n2 == 100) {
                    long l22 = PerfUtils.getTimeSpendSecond(l3);
                    EMLog.d(EMSendMessageRunnable.PERF, "upload " + n2 + "% file size(byte)" + l2 + " time(s)" + l22 + " speed(byte/s)" + PerfUtils.getSpeed(l2, System.currentTimeMillis() - l3));
                }
                if (eMCallBack != null) {
                    eMCallBack.onProgress(n2, null);
                }
            }

            @Override
            public void onError(String string) {
                EMLog.d(EMSendMessageRunnable.TAG, "upload error:" + string);
                eMMessage.status = EMMessage.Status.FAIL;
                EMSendMessageRunnable.this.updateMsgState(eMMessage);
                if (eMCallBack != null) {
                    eMCallBack.onProgress(100, null);
                    eMCallBack.onError(-2, string);
                }
            }

            @Override
            public void onSuccess(String string) {
                block9: {
                    try {
                        Object object;
                        String string22;
                        String string3;
                        block8: {
                            string3 = "";
                            string22 = "";
                            try {
                                object = new JSONObject(string);
                                JSONObject jSONObject = object.getJSONArray("entities").getJSONObject(0);
                                string3 = jSONObject.getString("uuid");
                                if (jSONObject.has("share-secret")) {
                                    string22 = jSONObject.getString("share-secret");
                                }
                            }
                            catch (Exception exception) {
                                if (exception == null || exception.getMessage() == null) break block8;
                                EMLog.d("sendFileMessage", exception.getMessage());
                            }
                        }
                        if (TextUtils.isEmpty((CharSequence)string3)) {
                            if (eMCallBack != null) {
                                eMCallBack.onProgress(100, null);
                                eMCallBack.onError(-2, "upload file fail");
                            }
                        } else {
                            object = String.valueOf(string2) + string3;
                            fileMessageBody.remoteUrl = object = ((String)object).replaceAll("#", "%23").replaceAll(" ", "%20");
                            fileMessageBody.secret = string22;
                            long l22 = PerfUtils.getTimeSpendSecond(l3);
                            EMLog.d(EMSendMessageRunnable.PERF, "uploaded file size(bytes)" + l2 + " time(s)" + l22 + " speed(bytes/s)" + PerfUtils.getSpeed(l2, System.currentTimeMillis() - l3));
                            EMSendMessageRunnable.this.sendMessageXmpp(eMMessage);
                            EMLog.d(EMSendMessageRunnable.TAG, "sent msg successfully:" + eMMessage.toString());
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        if (eMCallBack == null) break block9;
                        eMCallBack.onProgress(100, null);
                        eMCallBack.onError(-2, exception.toString());
                    }
                }
            }
        });
    }

    private void updateMsgState(EMMessage eMMessage) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("status", String.valueOf(eMMessage.status.ordinal()));
        i.a().a(eMMessage.msgId, contentValues);
    }

    private String getThumbnailImagePath(String string) {
        String string2 = string.substring(0, string.lastIndexOf("/") + 1);
        string2 = String.valueOf(string2) + "th" + string.substring(string.lastIndexOf("/") + 1, string.length());
        EMLog.d("msg", "original image path:" + string);
        EMLog.d("msg", "thum image path:" + string2);
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkConnection() {
        try {
            EMChatManager.getInstance().checkConnection();
        }
        catch (Exception exception) {
            Object object = this.sendMutex;
            synchronized (object) {
                this.addSendMsgLock(this.msg.getMsgId(), this.sendMutex);
                try {
                    this.sendMutex.wait(60000L);
                    EMLog.d(TAG, "wait send message time out");
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        }
    }

    synchronized void addSendMsgLock(String string, Object object) {
        if (sendMsgLocks == null) {
            sendMsgLocks = new Hashtable();
        }
        sendMsgLocks.put(string, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized void notifySendMsgLocks() {
        if (sendMsgLocks == null || sendMsgLocks.size() == 0) {
            return;
        }
        Iterator<Object> iterator = sendMsgLocks.values().iterator();
        while (iterator.hasNext()) {
            Object object;
            Object object2 = object = iterator.next();
            synchronized (object2) {
                object.notify();
            }
        }
        sendMsgLocks.clear();
    }

    static void onInit() {
        sendThreadPool = Executors.newFixedThreadPool(3);
    }

    static void onDestroy() {
        try {
            sendThreadPool.shutdownNow();
            EMSendMessageRunnable eMSendMessageRunnable = pendingMsgQueue.poll();
            while (eMSendMessageRunnable != null) {
                if (eMSendMessageRunnable.msg != null) {
                    eMSendMessageRunnable.msg.status = EMMessage.Status.FAIL;
                    if (eMSendMessageRunnable.msg.getType() != EMMessage.Type.CMD) {
                        eMSendMessageRunnable.updateMsgState(eMSendMessageRunnable.msg);
                    }
                }
                eMSendMessageRunnable = pendingMsgQueue.poll();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

