/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.chat;

import com.easemob.chat.EMChatDB;
import com.easemob.chat.EMMessage;
import com.easemob.chat.TextMessageBody;
import com.easemob.util.EMLog;

class EMSDKLocalTest {
    static long previousMsgTime = 0L;

    EMSDKLocalTest() {
    }

    public static void addMsgs(String string, int n2) {
        EMLog.d("db", "start to add test message to:" + string + " msgs:" + n2);
        long l2 = System.currentTimeMillis();
        int n3 = 0;
        while (n3 < n2) {
            EMMessage eMMessage = n3 % 2 == 0 ? EMSDKLocalTest.createSentTextMsg(string) : EMSDKLocalTest.createReceivedTextMsg(string);
            EMChatDB.getInstance().importMessage(eMMessage);
            ++n3;
        }
        EMLog.d("db", "finished add test data. time spend:" + (System.currentTimeMillis() - l2) / 1000L);
    }

    public static void addConversations(int n2, int n3) {
        EMLog.d("db", "[perf] start to add test conversations:" + n2 + " msg:" + n3);
        long l2 = System.currentTimeMillis();
        int n4 = 1;
        while (n4 <= n2) {
            String string = "user" + n4;
            EMSDKLocalTest.addMsgs(string, n3);
            ++n4;
        }
        EMLog.d("db", "[perf]finished add test conversatoins. time spend(s):" + (System.currentTimeMillis() - l2) / 1000L);
    }

    private static EMMessage createSentTextMsg(String string) {
        EMMessage eMMessage = EMMessage.createSendMessage(EMMessage.Type.TXT);
        TextMessageBody textMessageBody = new TextMessageBody("send text msg " + System.currentTimeMillis());
        eMMessage.addBody(textMessageBody);
        eMMessage.setTo(string);
        eMMessage.setMsgTime(EMSDKLocalTest.getNextMsgTime());
        return eMMessage;
    }

    private static EMMessage createReceivedTextMsg(String string) {
        EMMessage eMMessage = EMMessage.createReceiveMessage(EMMessage.Type.TXT);
        TextMessageBody textMessageBody = new TextMessageBody("receive text msg " + System.currentTimeMillis());
        eMMessage.addBody(textMessageBody);
        eMMessage.setFrom(string);
        eMMessage.setMsgTime(EMSDKLocalTest.getNextMsgTime());
        return eMMessage;
    }

    private static long getNextMsgTime() {
        long l2 = previousMsgTime == 0L ? System.currentTimeMillis() : previousMsgTime + 10000L;
        previousMsgTime = l2;
        return l2;
    }
}

