/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.chat;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import com.easemob.chat.EMContact;
import com.easemob.chat.EMContactManager;
import com.easemob.chat.EMSessionManager;
import com.easemob.util.EMLog;
import java.util.ArrayList;
import java.util.List;
import org.jivesoftware.smack.RosterStorage;
import org.jivesoftware.smack.packet.RosterPacket;

class EMRosterStorageImpl
implements RosterStorage {
    private static final String TAG = "rosterstorage";
    private static final String PERF_KEY_ROSTERVER = "easemob.roster.ver.";
    private String version;
    private EMContactManager contactManager;
    private Context appContext;
    private ArrayList<RosterPacket.Item> rosterItems;

    public EMRosterStorageImpl(Context context, EMContactManager eMContactManager) {
        this.appContext = context;
        this.contactManager = eMContactManager;
        this.version = null;
        this.rosterItems = new ArrayList();
    }

    void loadEntries() {
        for (EMContact eMContact : this.contactManager.contactTable.values()) {
            EMContactManager.getInstance();
            RosterPacket.Item item = new RosterPacket.Item(EMContactManager.getEidFromUserName(eMContact.username), eMContact.username);
            item.setItemType(RosterPacket.ItemType.both);
            this.rosterItems.add(item);
        }
        EMLog.d(TAG, "roster storage load entries, roster items size:" + this.rosterItems.size());
    }

    @Override
    public void addEntry(RosterPacket.Item item, String string) {
        if (item.getItemType() == RosterPacket.ItemType.both || item.getItemType() == RosterPacket.ItemType.from) {
            EMLog.d(TAG, "roster storage add new contact:" + item.getUser());
            String string2 = item.getUser();
            String string3 = EMContactManager.getUserNameFromEid(string2);
            String string4 = EMContactManager.getBareEidFromUserName(string3);
            EMContactManager.getInstance().addContactInternal(new EMContact(string4, string3));
        }
        if (string != null && !string.equals("") && !string.equals(this.version)) {
            this.updateRosterVersion(string);
        }
    }

    @Override
    public List<RosterPacket.Item> getEntries() {
        return this.rosterItems;
    }

    @Override
    public RosterPacket.Item getEntry(String string) {
        for (RosterPacket.Item item : this.rosterItems) {
            if (!item.getName().equals(string)) continue;
            return item;
        }
        EMLog.e(TAG, "cant find roster entry for jid:" + string);
        return null;
    }

    @Override
    public int getEntryCount() {
        EMLog.d(TAG, "get entry count return:" + this.rosterItems.size());
        return this.rosterItems.size();
    }

    @Override
    public String getRosterVersion() {
        if (this.version == null) {
            this.version = PreferenceManager.getDefaultSharedPreferences((Context)this.appContext).getString(PERF_KEY_ROSTERVER + EMSessionManager.getInstance().currentUser.eid, "");
            EMLog.d(TAG, "load roster storage for jid" + EMSessionManager.getInstance().currentUser.eid + " version:" + this.version);
        }
        return this.version;
    }

    private void updateRosterVersion(String string) {
        this.version = string;
        SharedPreferences.Editor editor = PreferenceManager.getDefaultSharedPreferences((Context)this.appContext).edit();
        editor.putString(PERF_KEY_ROSTERVER + EMSessionManager.getInstance().currentUser.eid, string);
        editor.commit();
        EMLog.d(TAG, "updated roster version to:" + string);
    }

    @Override
    public void removeEntry(String string, String string2) {
        String string3 = EMContactManager.getUserNameFromEid(string);
        EMContactManager.getInstance().deleteContactInternal(string3);
        if (string2 != null && !string2.equals("") && !string2.equals(this.version)) {
            this.updateRosterVersion(string2);
        }
    }

    @Override
    public void updateLocalEntry(RosterPacket.Item item) {
        EMLog.d(TAG, "[skip]roster storage uplodateLocalEntry:" + item);
    }
}

