/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.chat;

import com.easemob.chat.EMChatManager;
import com.easemob.chat.EMContactManager;
import com.easemob.util.EMLog;
import java.util.ArrayList;
import java.util.Collection;
import org.jivesoftware.smack.Roster;
import org.jivesoftware.smack.RosterEntry;
import org.jivesoftware.smack.RosterListener;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.RosterPacket;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EMRosterListener
implements RosterListener {
    private static final String TAG = "contact";
    private EMContactManager contactManager;
    private Roster roster;

    public EMRosterListener(EMContactManager eMContactManager, Roster roster) {
        this.contactManager = eMContactManager;
        this.roster = roster;
    }

    @Override
    public void entriesAdded(Collection<String> collection) {
        EMLog.d(TAG, "on contact entries added:" + collection);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : collection) {
            RosterEntry rosterEntry = this.roster.getEntry(string);
            if (rosterEntry == null) continue;
            if (rosterEntry.getType() != RosterPacket.ItemType.both && rosterEntry.getType() != RosterPacket.ItemType.from) {
                EMLog.d(TAG, "ignore entry type:" + (Object)((Object)rosterEntry.getType()));
                continue;
            }
            EMLog.d(TAG, "entry add: roster entry name:" + rosterEntry.getName() + " user:" + rosterEntry.getUser());
            String string2 = EMContactManager.getUserNameFromEid(string);
            String string3 = EMContactManager.getBareEidFromUserName(string2);
            arrayList.add(string2);
        }
        if (this.contactManager.contactListener != null && arrayList.size() != 0) {
            this.contactManager.contactListener.onContactAdded(arrayList);
        }
    }

    @Override
    public void entriesDeleted(Collection<String> collection) {
        EMLog.d(TAG, "on contact entries deleted:" + collection);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : collection) {
            String string2 = EMContactManager.getUserNameFromEid(string);
            if (!this.contactManager.hasContact(string2)) continue;
            arrayList.add(string2);
            this.contactManager.removeContactByUsername(string2);
        }
        if (this.contactManager.contactListener != null && arrayList.size() != 0) {
            this.contactManager.contactListener.onContactDeleted(arrayList);
        }
    }

    @Override
    public void entriesUpdated(Collection<String> collection) {
        EMLog.d(TAG, "on contact entries updated:" + collection);
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (String string : collection) {
            RosterEntry rosterEntry = this.roster.getEntry(string);
            if (rosterEntry.getType() == RosterPacket.ItemType.both || rosterEntry.getType() == RosterPacket.ItemType.from) {
                String string2 = EMContactManager.getUserNameFromEid(string);
                arrayList.add(string2);
            }
            EMLog.d(TAG, "entry.getType() = " + (Object)((Object)rosterEntry.getType()) == null ? "null" : rosterEntry.getType().toString());
            if (rosterEntry.getType() == RosterPacket.ItemType.none) {
                if (EMContactManager.getInstance().deleteContactsSet.contains(string)) {
                    arrayList2.add(EMContactManager.getUserNameFromEid(string));
                } else {
                    if (rosterEntry.getStatus() != null && RosterPacket.ItemStatus.SUBSCRIPTION_PENDING.toString().equals(rosterEntry.getStatus().toString())) {
                        return;
                    }
                    if (this.contactManager.contactListener != null) {
                        this.contactManager.contactListener.onContactRefused(EMContactManager.getUserNameFromEid(string));
                    }
                }
                try {
                    this.roster.removeEntry(rosterEntry);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.contactManager.contactListener != null && arrayList.size() != 0) {
                this.contactManager.contactListener.onContactAdded(arrayList);
            }
            if (this.contactManager.contactListener == null || arrayList2.size() == 0) continue;
            for (String string3 : arrayList2) {
                EMChatManager.getInstance().deleteConversation(string3);
            }
            this.contactManager.contactListener.onContactDeleted(arrayList2);
        }
    }

    @Override
    public void presenceChanged(Presence presence) {
    }
}

