/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.chat;

import android.text.TextUtils;
import com.easemob.chat.EMChatManager;
import com.easemob.chat.EMContactManager;
import com.easemob.chat.EMMessage;
import com.easemob.chat.EMMessageListener;
import com.easemob.chat.EMSendMessageRunnable;
import com.easemob.chat.core.a;
import com.easemob.chat.core.i;
import com.easemob.util.EMLog;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PacketExtension;

class EMRecvAckListener
implements PacketListener {
    private static final String TAG = "acklistener";

    EMRecvAckListener() {
    }

    @Override
    public void processPacket(Packet packet) {
        Message message = (Message)packet;
        EMLog.d(TAG, message.toXML());
        EMMessageListener.ackMessage(message);
        if (this.processClientAckMessage(message)) {
            return;
        }
        PacketExtension packetExtension = message.getExtension("urn:xmpp:receipts");
        if (packetExtension != null && packetExtension.getElementName().equals("received")) {
            String string;
            String string2 = message.getBody();
            EMMessage eMMessage = EMChatManager.getInstance().getMessage(string2);
            if (eMMessage != null && packetExtension instanceof a && !TextUtils.isEmpty((CharSequence)(string = ((a)packetExtension).a()))) {
                EMLog.d(TAG, " found returned global server msg id : " + string);
                EMChatManager.getInstance().replaceMessageId(string2, string);
            }
            EMLog.d(TAG, "received server ack for msg:" + string2);
            EMSendMessageRunnable.notifySendLock(string2);
        }
    }

    private synchronized boolean processClientAckMessage(Message message) {
        PacketExtension packetExtension = message.getExtension("urn:xmpp:receipts");
        if (packetExtension == null) {
            return false;
        }
        String string = packetExtension.getElementName();
        if (string.equals("acked")) {
            if (!EMChatManager.getInstance().getChatOptions().getRequireAck()) {
                EMLog.d(TAG, "msg read ack is not enabled. skip ack msg received");
                return true;
            }
            EMLog.d(TAG, "received message read ack for msg id:" + message.getBody());
            this.onReadAckReceived(message);
            return true;
        }
        if (string.equals("delivery")) {
            if (!EMChatManager.getInstance().getChatOptions().getRequireDeliveryAck()) {
                EMLog.d(TAG, "msg delivery ack is not enabled. skip ack msg received");
                return true;
            }
            EMLog.d(TAG, "received message delivered ack for msg id:" + message.getBody());
            this.onDeliveryAckReceived(message);
            return true;
        }
        return false;
    }

    private void onReadAckReceived(Message message) {
        String string = message.getBody();
        EMMessage eMMessage = EMChatManager.getInstance().getMessage(string);
        if (eMMessage == null) {
            eMMessage = i.a().c(string);
        }
        if (eMMessage != null) {
            String string2 = EMContactManager.getUserNameFromEid(message.getFrom());
            eMMessage.isAcked = true;
            i.a().e(string, true);
            EMChatManager.getInstance().notifiyReadAckMessage(string2, string);
        }
    }

    private void onDeliveryAckReceived(Message message) {
        String string = message.getBody();
        EMMessage eMMessage = EMChatManager.getInstance().getMessage(string);
        if (eMMessage == null) {
            eMMessage = i.a().c(string);
        }
        if (eMMessage != null) {
            String string2 = EMContactManager.getUserNameFromEid(message.getFrom());
            eMMessage.isDelivered = true;
            i.a().g(string, true);
            EMChatManager.getInstance().notifyDeliveryAckMessage(string2, string);
        }
    }
}

