/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.chat;

import com.easemob.chat.EMCallDirection;
import com.easemob.chat.EMCallStateChangeListener;
import com.easemob.chat.EMJingleStreamManager;
import com.easemob.chat.EMSessionHandler;
import com.easemob.chat.EMVoiceCallManager;
import com.easemob.chat.EMVoiceCallSession;
import com.easemob.media.EIce;
import com.easemob.util.EMLog;
import com.xonami.javaBells.DefaultJingleSession;
import java.util.List;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.ContentPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.JingleIQ;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.JinglePacketFactory;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.Reason;
import org.jivesoftware.smack.XMPPConnection;

class EMReceiverJingleSession
extends EMVoiceCallSession {
    private static final String TAG = EMReceiverJingleSession.class.getSimpleName();
    private List<ContentPacketExtension> acceptedContent = null;
    private String acceptedContentJsonStr = null;
    private EIce callee;

    public EMReceiverJingleSession(EMSessionHandler eMSessionHandler, String string, XMPPConnection xMPPConnection) {
        super(eMSessionHandler, string, xMPPConnection);
        this.callDirection = EMCallDirection.INCOMING;
    }

    @Override
    protected void closeSession(Reason reason) {
        super.closeSession(reason);
    }

    @Override
    public void handleCallerRelay(JingleIQ jingleIQ) {
        EMLog.d(TAG, "handleCallerRelay : " + jingleIQ.getReason().getText());
        this.jingleIQ = jingleIQ;
        this.ack(this.jingleIQ);
    }

    @Override
    public void handleSessionAccept(JingleIQ jingleIQ) {
    }

    public void answerCall() {
        EMLog.d(TAG, "start answer call");
        if (this.callState == EMCallStateChangeListener.CallState.CONNECTED || this.callState == EMCallStateChangeListener.CallState.ACCEPTED) {
            return;
        }
        EMLog.i(TAG, "Accepting incomig call!");
        JingleIQ jingleIQ = JinglePacketFactory.createCallAccept(this.myJid, this.peerJid, this.sessionId);
        jingleIQ.setStatistic(this.getCallStatistic(0));
        this.connection.sendPacket(jingleIQ);
        this.jingleStreamManager.startStream(this.streamParams);
        this.changeState(EMCallStateChangeListener.CallState.CONNECTED, EMCallStateChangeListener.CallError.ERROR_NONE);
        this.changeState(EMCallStateChangeListener.CallState.ACCEPTED, EMCallStateChangeListener.CallError.ERROR_NONE);
    }

    private void acceptContent(final boolean bl) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Object object;
                    boolean bl2 = true;
                    if (EMReceiverJingleSession.this.jingleIQ.getSdpJsonString() != null) {
                        EMReceiverJingleSession.this.acceptedContentJsonStr = EMReceiverJingleSession.this.jingleIQ.getSdpJsonString();
                    } else {
                        bl2 = false;
                        EMReceiverJingleSession.this.acceptedContent = EMReceiverJingleSession.this.jingleIQ.getContentList();
                        EMReceiverJingleSession.this.acceptedContentJsonStr = EMReceiverJingleSession.this.contentListToJson(EMReceiverJingleSession.this.acceptedContent);
                    }
                    EMLog.i(TAG, "Accepting incomig jingle call!");
                    EMVoiceCallManager.CallType callType = bl ? EMVoiceCallManager.CallType.video : EMVoiceCallManager.CallType.audio;
                    EMReceiverJingleSession.this.buildCallConfig(EMVoiceCallManager.getInstance().getCallConfig(callType, false, null, null));
                    EMReceiverJingleSession.this.callee = EIce.newCallee(EMReceiverJingleSession.this.callConfig, EMReceiverJingleSession.this.acceptedContentJsonStr);
                    String string = EMReceiverJingleSession.this.callee.getLocalContent();
                    JingleIQ jingleIQ = null;
                    if (bl2) {
                        jingleIQ = JinglePacketFactory.createSessionAccept(EMReceiverJingleSession.this.myJid, EMReceiverJingleSession.this.peerJid, EMReceiverJingleSession.this.sessionId, string);
                    } else {
                        object = EMReceiverJingleSession.this.jingleStreamManager.createcontentList(string);
                        jingleIQ = JinglePacketFactory.createSessionAccept(EMReceiverJingleSession.this.myJid, EMReceiverJingleSession.this.peerJid, EMReceiverJingleSession.this.sessionId, object);
                    }
                    jingleIQ.setStatistic(EMReceiverJingleSession.this.getCallStatistic(0));
                    EMReceiverJingleSession.this.connection.sendPacket(jingleIQ);
                    EMReceiverJingleSession.this.state = DefaultJingleSession.SessionState.NEGOTIATING_TRANSPORT;
                    EMReceiverJingleSession.this.callee.calleeNego(null);
                    EMReceiverJingleSession.this.changeState(EMCallStateChangeListener.CallState.CONNECTING, EMCallStateChangeListener.CallError.ERROR_NONE);
                    object = EMReceiverJingleSession.this.callee.waitforNegoResult();
                    EMReceiverJingleSession.this.freeIce();
                    EMReceiverJingleSession.this.handleNegoResult((String)object);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    EMLog.w(TAG, "An error occured. Rejecting call!");
                    JingleIQ jingleIQ = JinglePacketFactory.createCancel(EMReceiverJingleSession.this.myJid, EMReceiverJingleSession.this.peerJid, EMReceiverJingleSession.this.sessionId);
                    EMReceiverJingleSession.this.connection.sendPacket(jingleIQ);
                    EMReceiverJingleSession.this.closeSession(Reason.FAILED_APPLICATION);
                    EMReceiverJingleSession.this.changeState(EMCallStateChangeListener.CallState.DISCONNNECTED, EMCallStateChangeListener.CallError.ERROR_TRANSPORT);
                }
            }
        }).start();
    }

    @Override
    protected synchronized void freeIce() {
        if (this.callee != null) {
            EMLog.d(TAG, "callee free ice");
            this.callee.freeCall();
            this.callee = null;
        } else {
            EMLog.d(TAG, "callee is null when free ice");
        }
    }

    public void rejectCall() {
        EMLog.i(TAG, "Rejecting call!");
        try {
            this.closeSession(Reason.DECLINE);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            EMLog.e(TAG, exception.getMessage());
        }
        this.changeState(EMCallStateChangeListener.CallState.DISCONNNECTED, EMCallStateChangeListener.CallError.ERROR_NONE);
    }

    void rejectSessionInitiate() {
        EMLog.d(TAG, "try to reject an incoming session initiate IQ request : from peer " + this.peerJid + " session id = " + this.sessionId);
        this.onBusy();
    }

    void acceptSessionInitiate() {
        EMLog.d(TAG, "accept an incoming session initiate request : from peer " + this.peerJid + " session id = " + this.sessionId);
        List<ContentPacketExtension> list = this.jingleIQ.getContentList();
        boolean bl = false;
        for (ContentPacketExtension contentPacketExtension : list) {
            String string = contentPacketExtension.getAttributeAsString("name");
            if (!EMVoiceCallManager.CallType.video.toString().equals(string)) continue;
            bl = true;
            break;
        }
        this.jingleStreamManager = !bl ? new EMJingleStreamManager(ContentPacketExtension.CreatorEnum.initiator) : new EMJingleStreamManager(ContentPacketExtension.CreatorEnum.initiator, EMVoiceCallManager.CallType.video);
        try {
            this.acceptContent(bl);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            EMLog.d(TAG, exception.getMessage());
        }
    }

    @Override
    public void handleSessionInitiate(JingleIQ jingleIQ) {
        EMLog.d(TAG, "call from : " + jingleIQ + " is ringing!");
        this.jingleIQ = jingleIQ;
        this.ack(this.jingleIQ);
        this.peerJid = jingleIQ.getFrom();
        EMVoiceCallManager.getInstance().onJingleInitiateAction(this);
    }

    @Override
    public void handleSessionTerminate(JingleIQ jingleIQ) {
        this.callState = EMCallStateChangeListener.CallState.DISCONNNECTED;
        this.freeIce();
        super.handleSessionTerminate(jingleIQ);
        this.changeState(EMCallStateChangeListener.CallState.DISCONNNECTED, EMCallStateChangeListener.CallError.ERROR_NONE);
    }

    @Override
    public void onConnectionConnected() {
        EMVoiceCallManager.getInstance().onCallRinging(this);
    }

    private boolean acceptCallFrom(String string) {
        return true;
    }
}

