/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.chat;

import android.content.ContentValues;
import android.text.TextUtils;
import com.easemob.chat.EMChatManager;
import com.easemob.chat.EMCloudOperationCallback;
import com.easemob.chat.EMEncryptUtils;
import com.easemob.chat.EMMessage;
import com.easemob.chat.FileMessageBody;
import com.easemob.chat.ImageMessageBody;
import com.easemob.chat.MessageEncoder;
import com.easemob.chat.VideoMessageBody;
import com.easemob.chat.core.i;
import com.easemob.cloud.EMHttpClient;
import com.easemob.util.EMLog;
import com.easemob.util.PathUtil;
import java.io.File;
import java.util.HashMap;

class EMReceiveMessageThread
implements Runnable {
    private static final String TAG = "receiver";
    private EMMessage msg;
    private FileMessageBody msgbody;
    private boolean encrypted = false;

    public EMReceiveMessageThread(EMMessage eMMessage) {
        this.msg = eMMessage;
        this.msgbody = (FileMessageBody)eMMessage.body;
    }

    public EMReceiveMessageThread(EMMessage eMMessage, boolean bl) {
        this.msg = eMMessage;
        this.msgbody = (FileMessageBody)eMMessage.body;
        this.encrypted = bl;
    }

    @Override
    public void run() {
        String string;
        this.msg.status = EMMessage.Status.INPROGRESS;
        String string2 = this.msgbody.localUrl;
        String string3 = this.msgbody.remoteUrl;
        String string4 = this.msgbody.fileName;
        if (this.msg.type == EMMessage.Type.IMAGE) {
            if (!TextUtils.isEmpty((CharSequence)((ImageMessageBody)this.msgbody).thumbnailUrl)) {
                string3 = ((ImageMessageBody)this.msgbody).thumbnailUrl;
            }
        } else if (this.msg.type != EMMessage.Type.VOICE && this.msg.type == EMMessage.Type.VIDEO) {
            string3 = ((VideoMessageBody)this.msgbody).thumbnailUrl;
        }
        if (this.msg.type == EMMessage.Type.IMAGE) {
            string4 = "th" + string3.substring(string3.lastIndexOf("/") + 1, string3.length());
            string = PathUtil.getInstance().getImagePath() + "/" + string4;
        } else if (this.msg.type == EMMessage.Type.VIDEO) {
            string4 = string3.substring(string3.lastIndexOf("/") + 1, string3.length());
            ((VideoMessageBody)this.msgbody).localThumb = string = PathUtil.getInstance().getImagePath() + "/" + string4;
            ((VideoMessageBody)this.msgbody).localUrl = PathUtil.getInstance().getVideoPath() + "/" + string4 + ".mp4";
        } else if (this.msg.type == EMMessage.Type.VOICE) {
            string4 = string3.substring(string3.lastIndexOf("/") + 1, string3.length());
            string = !EMChatManager.getInstance().getChatOptions().getAudioFileWithExt() ? PathUtil.getInstance().getVoicePath() + "/" + string4 : PathUtil.getInstance().getVoicePath() + "/" + string4 + ".amr";
            this.msgbody.localUrl = string;
        } else if (this.msg.type == EMMessage.Type.FILE) {
            this.msgbody.localUrl = string = PathUtil.getInstance().getFilePath() + "/" + string4;
        } else {
            string = string2;
        }
        if (TextUtils.isEmpty((CharSequence)string4) || string4.equals("th")) {
            this.msg.status = EMMessage.Status.FAIL;
            this.updateMsgState();
            if (this.msgbody.downloadCallback != null) {
                this.msgbody.downloadCallback.onError(-1, "file name is null or empty");
            }
            if (this.msg.messageStatusCallBack != null) {
                this.msg.messageStatusCallBack.onError(-1, "file name is null or empty");
            }
            return;
        }
        final String string5 = string;
        EMLog.d(TAG, "localUrl:" + this.msgbody.localUrl + " remoteurl:" + string3 + " localThumb:" + string5);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (this.msg.type == EMMessage.Type.IMAGE) {
            String string6 = ((ImageMessageBody)this.msgbody).thumbnailSecret;
            if (TextUtils.isEmpty((CharSequence)string6)) {
                string6 = this.msgbody.secret;
            }
            if (!TextUtils.isEmpty((CharSequence)string6)) {
                hashMap.put("share-secret", string6);
            }
        } else if (this.msg.type == EMMessage.Type.VIDEO) {
            String string7 = ((VideoMessageBody)this.msgbody).thumbnailSecret;
            if (!TextUtils.isEmpty((CharSequence)string7)) {
                hashMap.put("share-secret", string7);
            }
        } else if (this.msg.type == EMMessage.Type.VOICE && this.msgbody.secret != null) {
            hashMap.put("share-secret", this.msgbody.secret);
        }
        if (this.msg.type == EMMessage.Type.IMAGE || this.msg.type == EMMessage.Type.VIDEO) {
            hashMap.put("thumbnail", "true");
        }
        EMHttpClient.getInstance().downloadFile(string3, string5, hashMap, new EMCloudOperationCallback(){

            @Override
            public void onSuccess(String string2) {
                File file = new File(string5);
                EMLog.d(EMReceiveMessageThread.TAG, "file downloaded:" + string5 + " size:" + file.length());
                if (EMReceiveMessageThread.this.encrypted) {
                    EMEncryptUtils.decryptFile(file.getAbsolutePath(), EMReceiveMessageThread.this.msg.getFrom());
                }
                ((EMReceiveMessageThread)EMReceiveMessageThread.this).msgbody.downloaded = true;
                ((EMReceiveMessageThread)EMReceiveMessageThread.this).msg.status = EMMessage.Status.SUCCESS;
                EMReceiveMessageThread.this.updateMsgState();
                ((EMReceiveMessageThread)EMReceiveMessageThread.this).msg.progress = 100;
                if (((EMReceiveMessageThread)EMReceiveMessageThread.this).msgbody.downloadCallback != null) {
                    ((EMReceiveMessageThread)EMReceiveMessageThread.this).msgbody.downloadCallback.onProgress(100, null);
                    ((EMReceiveMessageThread)EMReceiveMessageThread.this).msgbody.downloadCallback.onSuccess();
                }
                if (((EMReceiveMessageThread)EMReceiveMessageThread.this).msg.messageStatusCallBack != null) {
                    ((EMReceiveMessageThread)EMReceiveMessageThread.this).msg.messageStatusCallBack.onProgress(100, null);
                    ((EMReceiveMessageThread)EMReceiveMessageThread.this).msg.messageStatusCallBack.onSuccess();
                }
                if (((EMReceiveMessageThread)EMReceiveMessageThread.this).msg.type == EMMessage.Type.VOICE || ((EMReceiveMessageThread)EMReceiveMessageThread.this).msg.type == EMMessage.Type.VIDEO) {
                    EMReceiveMessageThread.this.updateMsgBody(EMReceiveMessageThread.this.msg);
                }
            }

            @Override
            public void onError(String string2) {
                ((EMReceiveMessageThread)EMReceiveMessageThread.this).msg.status = EMMessage.Status.FAIL;
                EMLog.e(EMReceiveMessageThread.TAG, "download file localThumbnailFilePath:" + string5 + ",error : " + string2);
                if (string != null && new File(string).exists()) {
                    File file = new File(string);
                    try {
                        if (file.isFile()) {
                            file.delete();
                        }
                    }
                    catch (Exception exception) {
                        EMLog.d(EMReceiveMessageThread.TAG, "temp file del fail." + string);
                    }
                }
                EMReceiveMessageThread.this.updateMsgState();
                if (((EMReceiveMessageThread)EMReceiveMessageThread.this).msgbody.downloadCallback != null) {
                    ((EMReceiveMessageThread)EMReceiveMessageThread.this).msgbody.downloadCallback.onError(-998, string2);
                }
                if (((EMReceiveMessageThread)EMReceiveMessageThread.this).msg.messageStatusCallBack != null) {
                    ((EMReceiveMessageThread)EMReceiveMessageThread.this).msg.messageStatusCallBack.onError(-998, string2);
                }
            }

            @Override
            public void onProgress(int n2) {
                ((EMReceiveMessageThread)EMReceiveMessageThread.this).msg.progress = n2;
                if (((EMReceiveMessageThread)EMReceiveMessageThread.this).msgbody.downloadCallback != null) {
                    ((EMReceiveMessageThread)EMReceiveMessageThread.this).msgbody.downloadCallback.onProgress(n2, null);
                }
                if (((EMReceiveMessageThread)EMReceiveMessageThread.this).msg.messageStatusCallBack != null) {
                    ((EMReceiveMessageThread)EMReceiveMessageThread.this).msg.messageStatusCallBack.onProgress(n2, null);
                }
            }
        });
    }

    protected void updateMsgState() {
        ContentValues contentValues = new ContentValues();
        contentValues.put("status", Integer.valueOf(this.msg.status.ordinal()));
        i.a().a(this.msg.getMsgId(), contentValues);
    }

    protected void updateMsgBody(EMMessage eMMessage) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("msgbody", MessageEncoder.getJSONMsg(eMMessage, true));
        i.a().a(this.msg.getMsgId(), contentValues);
    }
}

