/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.chat;

import android.content.Context;
import android.os.Build;
import android.util.Pair;
import com.easemob.chat.EMChat;
import com.easemob.chat.EMChatManager;
import com.easemob.chat.EMRandomDelay;
import com.easemob.chat.core.j;
import com.easemob.chat.core.p;
import com.easemob.cloud.EMHttpClient;
import com.easemob.exceptions.EaseMobException;
import com.easemob.util.EMLog;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.gcm.GoogleCloudMessaging;
import java.io.IOException;
import org.json.JSONObject;

class EMPushNotificationHelper {
    public static final String TAG = "EMPushNotificationHelper";
    private static EMPushNotificationHelper instance;
    private Thread pushThread = null;
    private Object sendTokenLock = new Object();
    private boolean isLogout = false;

    EMPushNotificationHelper() {
    }

    public static EMPushNotificationHelper getInstance() {
        if (instance == null) {
            instance = new EMPushNotificationHelper();
        }
        return instance;
    }

    boolean checkAvailablePushService() {
        boolean bl = j.a().i() != null ? j.a().i().d : false;
        EMLog.d(TAG, "GCM is enabled : " + bl);
        if (!bl) {
            return false;
        }
        boolean bl2 = false;
        try {
            if (Class.forName("com.google.android.gms.common.GooglePlayServicesUtil") != null) {
                int n2 = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)EMChat.getInstance().getAppContext());
                bl2 = n2 == 0;
                p.c().a(bl2);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            EMLog.e(TAG, classNotFoundException.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        EMLog.d(TAG, "GCM service enabled : " + bl2);
        return bl2;
    }

    boolean isPushServiceEnabled() {
        return p.c().a();
    }

    void onInit() {
        this.isLogout = false;
    }

    void sendDeviceTokenToServer() {
        if (p.c().a()) {
            EMLog.d(TAG, "GCM available");
            if (this.isLogout) {
                return;
            }
            if (this.pushThread != null && this.pushThread.isAlive()) {
                return;
            }
            if (this.pushThread == null) {
                this.pushThread = new Thread(){

                    @Override
                    public void run() {
                        try {
                            boolean bl;
                            int n2;
                            String string = EMPushNotificationHelper.this.getDeviceToken();
                            if (string == null) {
                                n2 = 0;
                                while (n2 < 3) {
                                    string = EMPushNotificationHelper.this.getDeviceToken();
                                    if (string != null) break;
                                    ++n2;
                                }
                                if (string == null) {
                                    p.c().a(false);
                                    EMChatManager.getInstance().doStopService();
                                    EMChatManager.getInstance().doStartService();
                                    return;
                                }
                            }
                            n2 = -1;
                            EMRandomDelay eMRandomDelay = new EMRandomDelay();
                            if (this.isInterrupted()) {
                                return;
                            }
                            if (p.c().P() == null) {
                                bl = EMPushNotificationHelper.this.sendDeviceInfo(string);
                                while (!bl) {
                                    ++n2;
                                    try {
                                        1.sleep(eMRandomDelay.timeDelay(n2) * 1000);
                                    }
                                    catch (Exception exception) {
                                        exception.printStackTrace();
                                        return;
                                    }
                                    bl = EMPushNotificationHelper.this.sendDeviceInfo(string);
                                }
                            }
                            eMRandomDelay.reset();
                            n2 = -1;
                            if (this.isInterrupted()) {
                                return;
                            }
                            bl = EMPushNotificationHelper.this.sendTokenToServer(string);
                            while (!bl) {
                                ++n2;
                                try {
                                    1.sleep(eMRandomDelay.timeDelay(n2) * 1000);
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                    return;
                                }
                                bl = EMPushNotificationHelper.this.sendTokenToServer(string);
                            }
                        }
                        catch (Exception exception) {
                            EMLog.e(EMPushNotificationHelper.TAG, exception.toString());
                        }
                    }
                };
                this.pushThread.start();
            }
        } else {
            EMLog.d(TAG, "GCM not available");
        }
    }

    public void onDestroy(boolean bl) throws EaseMobException {
        if (this.pushThread != null) {
            this.pushThread.interrupt();
            this.pushThread = null;
        }
        this.isLogout = true;
        if (bl && this.isPushServiceEnabled()) {
            boolean bl2 = this.sendTokenToServer("");
            if (!bl2) {
                throw new EaseMobException(-3000, "unbind device token failed");
            }
            p.c().a(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean sendTokenToServer(String string) {
        Object object = this.sendTokenLock;
        synchronized (object) {
            String string2 = String.valueOf(p.c().L()) + "/users/" + EMChatManager.getInstance().getCurrentUser();
            try {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("device_token", (Object)string);
                jSONObject.put("notifier_name", (Object)p.c().b());
                Pair<Integer, String> pair = EMHttpClient.getInstance().sendRequestWithToken(string2, jSONObject.toString(), EMHttpClient.PUT);
                int n2 = (Integer)pair.first;
                String string3 = (String)pair.second;
                switch (n2) {
                    case 200: {
                        EMLog.d(TAG, "sendTokenToServer SC_OK:");
                        return true;
                    }
                }
                EMLog.d(TAG, "sendTokenToServer error:" + string3);
            }
            catch (Exception exception) {
                EMLog.e(TAG, exception.toString());
            }
            return false;
        }
    }

    boolean sendDeviceInfo(String string) {
        String string2;
        block7: {
            String string3 = String.valueOf(p.c().L()) + "/devices";
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("model", (Object)"android");
            jSONObject.put("name", (Object)string);
            jSONObject.put("token", (Object)string);
            jSONObject.put("sdk_version", (Object)EMChat.getInstance().getVersion());
            jSONObject.put("os_version", (Object)Build.VERSION.RELEASE);
            Pair<Integer, String> pair = EMHttpClient.getInstance().sendRequest(string3, null, jSONObject.toString(), EMHttpClient.POST);
            int n2 = (Integer)pair.first;
            string2 = (String)pair.second;
            switch (n2) {
                case 200: {
                    p.c().j(string);
                    EMLog.d(TAG, "sendDeviceToServer SC_OK:");
                    return true;
                }
            }
            if (!string2.contains("duplicate_unique_property_exists")) break block7;
            return true;
        }
        try {
            EMLog.d(TAG, "sendDeviceToServer error : " + string2);
        }
        catch (Exception exception) {
            EMLog.e(TAG, exception.toString());
        }
        return false;
    }

    String getDeviceToken() {
        String string = p.c().P();
        if (string != null) {
            return string;
        }
        try {
            if (p.c().b() != null) {
                GoogleCloudMessaging googleCloudMessaging = null;
                if (googleCloudMessaging == null) {
                    googleCloudMessaging = GoogleCloudMessaging.getInstance((Context)EMChat.getInstance().getAppContext());
                }
                string = googleCloudMessaging.register(new String[]{p.c().b()});
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        EMLog.d(TAG, "devicetoken = " + string);
        return string;
    }

    private boolean notificationDisplayStyle(int n2) {
        String string = String.valueOf(p.c().L()) + "/users/" + EMChatManager.getInstance().getCurrentUser();
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("notification_display_style", n2);
        Pair<Integer, String> pair = EMHttpClient.getInstance().sendRequest(string, null, jSONObject.toString(), EMHttpClient.PUT);
        int n3 = (Integer)pair.first;
        String string2 = (String)pair.second;
        switch (n3) {
            case 200: {
                EMLog.d(TAG, "notificationDisplayStyle SC_OK");
                return true;
            }
        }
        try {
            EMLog.d(TAG, "notificationDisplayStyle error:" + string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }
}

