/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.chat;

import android.content.Intent;
import android.text.TextUtils;
import com.easemob.chat.EMChat;
import com.easemob.chat.EMChatManager;
import com.easemob.chat.EMContactManager;
import com.easemob.chat.EMSessionManager;
import com.easemob.exceptions.EaseMobException;
import com.easemob.util.EMLog;
import org.jivesoftware.smack.packet.Presence;

class EMPresenceHandler {
    private static final String TAG = EMPresenceHandler.class.getSimpleName();
    private static EMPresenceHandler me = new EMPresenceHandler();

    EMPresenceHandler() {
    }

    static EMPresenceHandler getInstance() {
        return me;
    }

    void acceptInvitation(String string, boolean bl) throws EaseMobException {
        try {
            EMSessionManager.getInstance().checkConnection();
            Presence presence = new Presence(Presence.Type.subscribed);
            presence.setMode(Presence.Mode.available);
            presence.setPriority(24);
            presence.setTo(string);
            presence.setStatus("[resp:" + bl + "]");
            EMSessionManager.getInstance().getConnection().sendPacket(presence);
            if (bl) {
                Presence presence2 = new Presence(Presence.Type.subscribe);
                presence2.setStatus("[resp:true]");
                presence2.setTo(string);
                EMSessionManager.getInstance().getConnection().sendPacket(presence2);
            }
        }
        catch (Exception exception) {
            throw new EaseMobException(exception.getMessage());
        }
    }

    void refuseInvitation(String string) throws EaseMobException {
        try {
            EMSessionManager.getInstance().checkConnection();
            Presence presence = new Presence(Presence.Type.unsubscribed);
            presence.setTo(EMContactManager.getEidFromUserName(string));
            EMSessionManager.getInstance().getConnection().sendPacket(presence);
        }
        catch (Exception exception) {
            throw new EaseMobException(exception.getMessage());
        }
    }

    void processRosterPresence(Presence presence) {
        boolean bl = false;
        if (presence.getType().equals((Object)Presence.Type.subscribe)) {
            String string;
            String string2 = null;
            boolean bl2 = false;
            if (presence.getStatus() != null) {
                string2 = presence.getStatus();
            }
            String string3 = "[resp:";
            if (!TextUtils.isEmpty((CharSequence)string2) && string2.startsWith(string3)) {
                string = string2.substring(string3.length(), string2.indexOf("]"));
                bl2 = Boolean.parseBoolean(string);
                string2 = string2.length() > string2.indexOf("]") + 1 ? string2.substring(string2.indexOf("]1"), string2.length()) : null;
            }
            EMLog.d(TAG, "isresp:" + bl2 + " reason:" + string2);
            if (bl2) {
                try {
                    this.acceptInvitation(presence.getFrom(), false);
                    if (!bl) {
                        if (bl2) {
                            string = new Intent(EMChatManager.getInstance().getContactInviteEventBroadcastAction());
                            string.putExtra("username", EMContactManager.getUserNameFromEid(presence.getFrom()));
                            string.putExtra("isResponse", bl2);
                            EMChat.getInstance().getAppContext().sendBroadcast((Intent)string);
                            if (EMContactManager.getInstance().contactListener != null) {
                                EMContactManager.getInstance().contactListener.onContactAgreed(EMContactManager.getUserNameFromEid(presence.getFrom()));
                            }
                        }
                        bl = true;
                    }
                }
                catch (EaseMobException easeMobException) {
                    EMLog.e(TAG, easeMobException.getMessage());
                    easeMobException.printStackTrace();
                }
            } else {
                if (EMChatManager.getInstance().getChatOptions().getAcceptInvitationAlways()) {
                    try {
                        EMLog.d(TAG, "auto acceptance inviation from:" + presence.getFrom());
                        this.acceptInvitation(presence.getFrom(), true);
                    }
                    catch (EaseMobException easeMobException) {
                        EMLog.e(TAG, easeMobException.getMessage());
                        easeMobException.printStackTrace();
                    }
                    return;
                }
                string = EMContactManager.getUserNameFromEid(presence.getFrom());
                Intent intent = new Intent(EMChatManager.getInstance().getContactInviteEventBroadcastAction());
                intent.putExtra("username", string);
                intent.putExtra("reason", string2);
                intent.putExtra("isResponse", bl2);
                EMChat.getInstance().getAppContext().sendOrderedBroadcast(intent, null);
                EMLog.d(TAG, "send roster broadcast username:" + string + " reason:" + string2 + "resp:" + bl2);
                EMContactManager.getInstance().contactListener.onContactInvited(string, string2);
            }
        } else if (presence.getType().equals((Object)Presence.Type.unsubscribe)) {
            EMContactManager.getInstance().deleteContactsSet.add(presence.getFrom());
            Presence presence2 = new Presence(Presence.Type.unsubscribed);
            presence2.setMode(Presence.Mode.available);
            presence2.setPriority(24);
            presence2.setTo(presence.getFrom());
            EMSessionManager.getInstance().getConnection().sendPacket(presence2);
        } else if (presence.getType().equals((Object)Presence.Type.subscribed) && !bl) {
            Object object;
            boolean bl3 = false;
            String string = null;
            if (presence.getStatus() != null) {
                string = presence.getStatus();
            }
            String string4 = "[resp:";
            if (string != null && string.startsWith(string4)) {
                object = string.substring(string4.length(), string.indexOf("]"));
                bl3 = Boolean.parseBoolean((String)object);
            }
            if (bl3) {
                object = new Intent(EMChatManager.getInstance().getContactInviteEventBroadcastAction());
                object.putExtra("username", EMContactManager.getUserNameFromEid(presence.getFrom()));
                object.putExtra("isResponse", bl3);
                EMChat.getInstance().getAppContext().sendBroadcast(object);
                EMContactManager.getInstance().contactListener.onContactAgreed(EMContactManager.getUserNameFromEid(presence.getFrom()));
            }
            bl = true;
        }
    }
}

